/*
 * Decompiled with CFR 0.152.
 */
package wireless;

import java.text.DecimalFormat;
import util.Conv;
import wireless.PHY_TwoRay;
import wireless.Units_Distance;
import wireless.Units_Frequency;

class PHY_TwoWay_Test {
    private static final DecimalFormat f7dec = new DecimalFormat("#,##0.0000000");

    PHY_TwoWay_Test() {
    }

    public static void main(String[] args) {
        Units_Distance d_units = Units_Distance.METERS;
        Units_Frequency f_units = Units_Frequency.GHZ;
        double ptx = 13.0103;
        double prx = -89.0;
        double gtx = 1.0;
        double grx = 1.0;
        double htx = 1.0;
        double hrx = 1.0;
        double f = 5.89;
        double dc = PHY_TwoRay.minimumDistance(htx, hrx, f, d_units, f_units);
        System.out.println("dc = " + f7dec.format(dc));
        double d1 = PHY_TwoRay.communicationRange_dB1(ptx, prx, gtx, grx, f, d_units, f_units);
        System.out.println("d1 = " + f7dec.format(d1));
        double d2 = PHY_TwoRay.communicationRange_dB2(ptx, prx, gtx, grx, f, d_units, f_units);
        System.out.println("d2 = " + f7dec.format(d2));
        double pl_dB = PHY_TwoRay.pathLoss_dB(d1, gtx, grx, htx, hrx, d_units);
        System.out.println("pl(dB) = " + f7dec.format(pl_dB));
        double d1_km = d1 / 1000.0;
        pl_dB = PHY_TwoRay.pathLoss_dB(d1_km, gtx, grx, htx, hrx, Units_Distance.KM);
        System.out.println("pl(dB) = " + f7dec.format(pl_dB));
        double gtx_abs = gtx;
        double grx_abs = grx;
        double pl_mW = PHY_TwoRay.pathLoss_mW(d1_km, gtx_abs, grx_abs, htx, hrx, Units_Distance.KM);
        System.out.println("pl(mW) = " + f7dec.format(pl_mW));
        double pl_db2 = Conv.watts_to_dBm(pl_mW / 1000.0);
        System.out.println("pl(dB) = " + f7dec.format(pl_db2));
    }
}

