/*
 * Decompiled with CFR 0.152.
 */
package wireless;

import wireless.PHY_FSPL;
import wireless.Units_Distance;
import wireless.Units_Frequency;

public class PHY_TwoRay
extends PHY_FSPL {
    public static double minimumDistance(double htx, double hrx, double f, Units_Distance d_units, Units_Frequency f_units) {
        double f_herz = f / f_units.getConv2Hz();
        double lamda = 3.0E8 / f_herz;
        double d = 20.0 * (htx * hrx) / lamda;
        if (d_units != Units_Distance.METERS) {
            d *= d_units.getConv2Meters();
        }
        return d;
    }

    public static double pathLoss_mW(double d) {
        double pathloss = PHY_TwoRay.pathLoss_mW(d, 1.0, 1.0, 1.0, 1.0, Units_Distance.METERS);
        return pathloss;
    }

    public static double pathLoss_mW(double d, double gtx, double grx, double htx, double hrx, Units_Distance d_units) {
        double pathloss = 0.0;
        if (d_units != Units_Distance.METERS) {
            d /= d_units.getConv2Meters();
        }
        pathloss = Math.pow(d, 4.0) / (gtx * grx * (htx * htx) * (hrx * hrx));
        return pathloss;
    }

    public static double pathLoss_dB(double d) {
        double pathloss = PHY_TwoRay.pathLoss_dB(d, 0.0, 0.0, 1.0, 1.0, Units_Distance.METERS);
        return pathloss;
    }

    public static double pathLoss_dB(double d, double gtx, double grx, double htx, double hrx, Units_Distance d_units) {
        if (d_units != Units_Distance.METERS) {
            d /= d_units.getConv2Meters();
        }
        double pathloss = 40.0 * Math.log10(d) - 10.0 * Math.log10(gtx * gtx) - 20.0 * Math.log10(hrx * hrx);
        return pathloss;
    }

    public static double receivedPower_dB(double ptx, double pathLoss) {
        double prx = ptx - pathLoss;
        return prx;
    }

    public static double receivedPower_dB(double ptx, double gtx, double grx, double htx, double hrx, double d, Units_Distance d_units) {
        double prx = ptx - PHY_TwoRay.pathLoss_dB(gtx, grx, htx, hrx, d, d_units);
        return prx;
    }

    public static double receivedPower_mW(double ptx, double gtx, double grx, double htx, double hrx, Units_Distance d_units) {
        double d = 0.0;
        double a = ptx * gtx * grx * (htx * htx) * (hrx * hrx);
        double b = Math.pow(d, 4.0) * 1.0;
        double prx = a / b;
        return prx;
    }

    public static double communicationRange_dB1(double ptx, double prx, double gtx, double grx, double htx, double hrx, Units_Distance d_units) {
        double y = (ptx - prx + 10.0 * Math.log10(gtx * grx) + 20.0 * Math.log10(htx * hrx)) / 40.0;
        double d = Math.pow(10.0, y);
        if (d_units != Units_Distance.METERS) {
            d *= d_units.getConv2Meters();
        }
        return d;
    }

    public static double communicationRange_dB2(double ptx, double prx, double gtx, double grx, double htx, double hrx, Units_Distance d_units) {
        double d = PHY_TwoRay.communicationRange_mW(PHY_TwoRay.db2mw(ptx), PHY_TwoRay.db2mw(prx), gtx, grx, htx, htx, d_units);
        return d;
    }

    public static double communicationRange_mW(double ptx, double prx, double gtx, double grx, double htx, double hrx, Units_Distance d_units) {
        double d = 0.0;
        double a = ptx * gtx * grx * (htx * htx) * (hrx * hrx);
        double b = prx * 1.0;
        d = Math.pow(a / b, 0.25);
        if (d_units != Units_Distance.METERS) {
            d *= d_units.getConv2Meters();
        }
        return d;
    }
}

