/*
 * Decompiled with CFR 0.152.
 */
package wireless;

import java.text.DecimalFormat;
import wireless.PHY_FSPL;
import wireless.Units_Distance;
import wireless.Units_Frequency;

class PHY_FSPL_Test {
    private static final int REPETICIONES = 10;
    private static final int ITERACIONES = 10000000;
    private static final long NANOSECONDS_TO_MILLISECONDS = 1000000L;
    private static final DecimalFormat f7dec = new DecimalFormat("#,##0.0000000");

    PHY_FSPL_Test() {
    }

    public static void main(String[] args) {
        double d = 0.0;
        Units_Distance d_units = Units_Distance.METERS;
        Units_Frequency f_units = Units_Frequency.GHZ;
        double ptx = 13.0103;
        double prx = -89.0;
        double gtx = 1.0;
        double grx = 1.0;
        double f = 5.89;
        double d1 = PHY_FSPL.communicationRange_dB1(ptx, prx, gtx, grx, f, d_units, f_units);
        System.out.println("d1 = " + f7dec.format(d1));
        double d2 = PHY_FSPL.communicationRange_dB2(ptx, prx, gtx, grx, f, d_units, f_units);
        System.out.println("d2 = " + f7dec.format(d2));
        double pl = PHY_FSPL.pathLoss_dB(d1, f, gtx, grx, d_units, f_units);
        System.out.println("pl = " + f7dec.format(pl));
        for (int m = 0; m < 2; ++m) {
            double duration_avg = 0.0;
            System.out.println("M\u00e9todo " + (m + 1) + ":");
            for (int r = 0; r < 10; ++r) {
                long time_start = System.nanoTime();
                for (int i = 0; i < 10000000; ++i) {
                    d = m == 0 ? PHY_FSPL.communicationRange_dB1(ptx, prx, gtx, grx, f, d_units, f_units) : PHY_FSPL.communicationRange_dB2(ptx, prx, gtx, grx, f, d_units, f_units);
                }
                long time_end = System.nanoTime();
                long duration = (time_end - time_start) / 1000000L;
                duration_avg += (double)duration;
                System.out.println("   d = " + f7dec.format(d));
                System.out.println("   Tiempo transcurrido = " + duration + " ms");
            }
            System.out.println("   Media = " + f7dec.format(duration_avg / 10.0) + " ms\n");
        }
    }
}

