/*
 * Decompiled with CFR 0.152.
 */
package wireless;

import wireless.Units_Distance;
import wireless.Units_Frequency;

public class PHY_FSPL {
    public static final long SPEED_OF_LIGHT_MS = 300000000L;
    protected static final double FOUR_PI = Math.PI * 4;
    protected static final double CTE_FSPL_DB_M_HZ = 20.0 * Math.log10(4.1887902047863906E-8);
    protected static final double L = 1.0;

    public static double pathLoss_mW(double d, double f) {
        double pathloss = PHY_FSPL.pathLoss_mW(d, f, 1.0, 1.0);
        return pathloss;
    }

    public static double pathLoss_mW(double d, double f, double gtx, double grx) {
        double pathloss = Math.PI * 4 * d * f * gtx * grx / 3.0E8;
        pathloss *= pathloss;
        return pathloss;
    }

    public static double pathLoss_dB(double d, double f) {
        double pathloss = PHY_FSPL.pathLoss_dB(d, f, 0.0, 0.0, Units_Distance.METERS, Units_Frequency.HZ);
        return pathloss;
    }

    public static double pathLoss_dB(double d, double f, double gtx, double grx, Units_Distance d_units, Units_Frequency f_units) {
        double convUnitsDistance = d_units.getSumando();
        double convUnitsFrecuency = f_units.getSumando();
        double cte = CTE_FSPL_DB_M_HZ - convUnitsDistance - convUnitsFrecuency;
        double pathloss = 20.0 * Math.log10(d) + 20.0 * Math.log10(f) + cte - 10.0 * Math.log10(gtx * grx);
        return pathloss;
    }

    public static double receivedPower_dB(double ptx, double pathLoss) {
        double prx = ptx - pathLoss;
        return prx;
    }

    public static double receivedPower_dB(double ptx, double d, double f, double gtx, double grx, Units_Distance d_units, Units_Frequency f_units) {
        double prx = ptx - PHY_FSPL.pathLoss_dB(d, f, gtx, grx, d_units, f_units);
        return prx;
    }

    public static double receivedPower_mW(double ptx, double d, double f, double gtx, double grx, Units_Distance d_units, Units_Frequency f_units) {
        double f_herz = f / f_units.getConv2Hz();
        double lamda = 3.0E8 / f_herz;
        double a = ptx * gtx * grx * lamda * lamda;
        double b = 157.91367041742973 * d * d * 1.0;
        double prx = a / b;
        return prx;
    }

    public static boolean packetIsReceived(double prx, double sensitivity) {
        boolean received = prx >= sensitivity;
        return received;
    }

    public static double communicationRange_dB1(double ptx, double prx, double gtx, double grx, double f, Units_Distance d_units, Units_Frequency f_units) {
        double convUnitsDistance = d_units.getSumando();
        double convUnitsFrecuency = f_units.getSumando();
        double cte = CTE_FSPL_DB_M_HZ - convUnitsDistance - convUnitsFrecuency;
        double y = (ptx - prx + 10.0 * Math.log10(gtx * grx) - cte) / 20.0 - Math.log10(f);
        double d = Math.pow(10.0, y);
        return d;
    }

    public static double communicationRange_dB2(double ptx, double prx, double gtx, double grx, double f, Units_Distance d_units, Units_Frequency f_units) {
        double d = PHY_FSPL.communicationRange_mW(PHY_FSPL.db2mw(ptx), PHY_FSPL.db2mw(prx), gtx, grx, f, d_units, f_units);
        return d;
    }

    public static double communicationRange_mW(double ptx, double prx, double gtx, double grx, double f, Units_Distance d_units, Units_Frequency f_units) {
        double d = 0.0;
        double f_herz = f / f_units.getConv2Hz();
        double lamda = 3.0E8 / f_herz;
        double alpha = 2.0;
        double a = ptx * gtx * grx * lamda * lamda;
        double b = 157.91367041742973 * prx;
        d = Math.pow(a / b, 1.0 / alpha);
        if (d_units != Units_Distance.METERS) {
            d *= d_units.getConv2Meters();
        }
        return d;
    }

    public static double mw2db(double mw) {
        double db = 10.0 * Math.log10(mw);
        return db;
    }

    public static double db2mw(double db) {
        double mw = Math.pow(10.0, db / 10.0);
        return mw;
    }
}

