/*
 * Decompiled with CFR 0.152.
 */
package util.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.Arrays;
import java.util.EventObject;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.text.JTextComponent;
import util.Util;

public class MyTable
implements Printable,
ListSelectionListener,
TableModelListener {
    public JTable table;
    public JScrollPane scrollpane;
    public Object[][] datos;
    public String[] titulos;
    private int[] nonEditableCols;
    private DefaultTableModel model;
    private TableColumnModel colmodel;
    private boolean enableEvents = true;
    private Listener oListener = null;

    public void addListener(Listener oListener) {
        this.oListener = oListener;
    }

    public MyTable(Object[][] datos, String[] titulos, Listener listener) {
        this(datos, titulos, listener, null);
    }

    public MyTable(Object[][] datos, String[] titulos, Listener listener, int[] nonEditableCols) {
        this.datos = datos;
        this.titulos = titulos;
        this.oListener = listener;
        this.nonEditableCols = nonEditableCols;
        this.buildTable();
        this.scrollpane = new JScrollPane(this.table);
    }

    private void buildTable() {
        this.model = this.nonEditableCols == null || this.nonEditableCols.length == 0 ? new DefaultTableModel(this.datos, this.titulos) : new DefaultTableModel(this.datos, this.titulos){

            @Override
            public boolean isCellEditable(int row, int column) {
                int index = Arrays.binarySearch(MyTable.this.nonEditableCols, column);
                boolean editable = index < 0;
                return editable;
            }
        };
        this.table = new JTable(this.model){

            @Override
            public boolean editCellAt(int row, int column, EventObject e) {
                boolean result = super.editCellAt(row, column, e);
                final Component editor = this.getEditorComponent();
                if (editor == null || !(editor instanceof JTextComponent)) {
                    return result;
                }
                if (e instanceof MouseEvent) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ((JTextComponent)editor).selectAll();
                        }
                    });
                } else {
                    ((JTextComponent)editor).selectAll();
                }
                return result;
            }
        };
        this.colmodel = this.table.getColumnModel();
        this.table.setShowGrid(true);
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(false);
        this.table.setSelectionMode(0);
        if (this.oListener != null) {
            ListSelectionModel rowSM = this.table.getSelectionModel();
            rowSM.addListSelectionListener(this);
            this.model.addTableModelListener(this);
        }
    }

    public void enableEvents(boolean enable) {
        this.enableEvents = enable;
    }

    public void setColumnMaxWidth(int c, int w) {
        if (c >= this.colmodel.getColumnCount()) {
            return;
        }
        this.colmodel.getColumn(c).setMaxWidth(w);
    }

    public int getNumCols() {
        int ncols = this.model.getColumnCount();
        return ncols;
    }

    public int getNumRows() {
        int nrows = this.model.getRowCount();
        return nrows;
    }

    public void setData(Object[][] datos) {
        this.datos = datos;
        this.scrollpane.getViewport().remove(this.table);
        this.buildTable();
        this.scrollpane.getViewport().add((Component)this.table, null);
        if (this.model.getRowCount() > 0) {
            this.selectRow(0);
        }
    }

    public void setData(int row, Object[] values) {
        int nrows = this.model.getRowCount();
        int ncols = this.model.getColumnCount();
        if (nrows <= 0 || ncols <= 0) {
            return;
        }
        if (row >= 0 && row < nrows && values.length == ncols) {
            this.model.removeTableModelListener(this);
            for (int col = 0; col < ncols; ++col) {
                this.model.setValueAt(values[col], row, col);
            }
            this.model.addTableModelListener(this);
        }
    }

    public void setData(int row, int col, Object value) {
        int nrows = this.model.getRowCount();
        int ncols = this.model.getColumnCount();
        if (nrows <= 0 || ncols <= 0) {
            return;
        }
        if (row >= 0 && row < nrows && col >= 0 && col < ncols) {
            this.model.removeTableModelListener(this);
            this.model.setValueAt(value, row, col);
            this.model.addTableModelListener(this);
        }
    }

    public Object[][] getData() {
        int nrows = this.model.getRowCount();
        int ncols = this.model.getColumnCount();
        Object[][] s = new String[nrows][ncols];
        for (int row = 0; row < nrows; ++row) {
            for (int col = 0; col < ncols; ++col) {
                s[row][col] = (String)this.model.getValueAt(row, col);
            }
        }
        return s;
    }

    public Object[] getData(int row) {
        int nrows = this.model.getRowCount();
        int ncols = this.model.getColumnCount();
        Object[] s = new String[ncols];
        if (nrows <= 0 || ncols <= 0) {
            return null;
        }
        if (row >= 0 && row < nrows) {
            for (int col = 0; col < ncols; ++col) {
                s[col] = (String)this.model.getValueAt(row, col);
            }
        }
        return s;
    }

    public Object getData(int row, int col) {
        Object o = null;
        int nrows = this.model.getRowCount();
        int ncols = this.model.getColumnCount();
        if (nrows <= 0 || ncols <= 0) {
            return null;
        }
        if (row >= 0 && row < nrows && col >= 0 && col < ncols) {
            o = this.model.getValueAt(row, col);
        }
        return o;
    }

    public String getDataString(int row, int col) {
        String s = this.getData(row, col).toString();
        return s;
    }

    public int getDataInt(int row, int col) {
        int n = Util.parseInt(this.getData(row, col).toString());
        return n;
    }

    public float getDataFloat(int row, int col) {
        float n = Util.parseFloat(this.getData(row, col).toString());
        return n;
    }

    public boolean getDataBoolean(int row, int col) {
        Boolean b = Boolean.FALSE;
        Object o = this.getData(row, col);
        if (o != null) {
            Boolean bool = (Boolean)o;
            b = (boolean)bool;
        }
        return b;
    }

    public int getSelectedRow() {
        return this.table.getSelectedRow();
    }

    public void selectRow(int row) {
        int nrows = this.model.getRowCount();
        if (row < nrows) {
            this.table.setRowSelectionInterval(row, row);
        }
    }

    public void setVisible(int row) {
        int nrows = this.model.getRowCount();
        if (row < nrows) {
            int col = 0;
            Rectangle rect = this.table.getCellRect(row, col, true);
            this.table.scrollRectToVisible(rect);
        }
    }

    public void selectAll() {
        int nrows = this.model.getRowCount();
        this.table.setRowSelectionInterval(0, nrows - 1);
    }

    public void removeAllRows() {
        int nrows = this.model.getRowCount();
        for (int i = 0; i < nrows; ++i) {
            this.model.removeRow(0);
        }
    }

    public void removeRow(int row) {
        int nrows = this.model.getRowCount();
        if (nrows <= 0) {
            return;
        }
        if (row >= 0 && row < nrows) {
            this.model.removeRow(row);
            if (this.model.getRowCount() > 0) {
                this.selectRow(row);
            }
        }
    }

    public void insertRow(int row, Object[] data, boolean select, boolean setVisible) {
        this.model.insertRow(row, data);
        if (select) {
            this.selectRow(row);
        }
        if (setVisible) {
            this.setVisible(row);
        }
    }

    public void appendRow(Object[] data, boolean setVisible) {
        this.model.addRow(data);
        int row = this.model.getRowCount() - 1;
        this.selectRow(row);
        if (setVisible) {
            this.setVisible(row);
        }
    }

    public void moveUp() {
        int[] rows = this.table.getSelectedRows();
        int firstRow = rows[rows.length - 1];
        if (firstRow > 0) {
            this.model.moveRow(rows[0], rows[rows.length - 1], rows[0] - 1);
            this.table.setRowSelectionInterval(rows[0] - 1, rows[rows.length - 1] - 1);
        }
    }

    public void moveDown() {
        int[] rows = this.table.getSelectedRows();
        int lastRow = rows[rows.length - 1];
        if (lastRow + 1 < this.model.getRowCount()) {
            this.model.moveRow(rows[0], rows[rows.length - 1], rows[0] + 1);
            this.table.setRowSelectionInterval(rows[0] + 1, rows[rows.length - 1] + 1);
        }
    }

    public void moveUp(int row) {
        this.model.moveRow(row, row, row - 1);
    }

    public void moveDown(int row) {
        this.model.moveRow(row, row, row + 1);
    }

    public void print(String title) {
        PrinterJob pj = PrinterJob.getPrinterJob();
        pj.setPrintable(this);
        pj.setJobName(title);
        pj.printDialog();
        try {
            pj.print();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(Color.black);
        int fontHeight = g2.getFontMetrics().getHeight();
        int fontDesent = g2.getFontMetrics().getDescent();
        double pageHeight = pageFormat.getImageableHeight() - (double)fontHeight;
        double pageWidth = pageFormat.getImageableWidth();
        double tableWidth = this.table.getColumnModel().getTotalColumnWidth();
        double scale = 1.0;
        if (tableWidth >= pageWidth) {
            scale = pageWidth / tableWidth;
        }
        double headerHeightOnPage = (double)this.table.getTableHeader().getHeight() * scale;
        double tableWidthOnPage = tableWidth * scale;
        double oneRowHeight = (double)(this.table.getRowHeight() + this.table.getRowMargin()) * scale;
        int numRowsOnAPage = (int)((pageHeight - headerHeightOnPage) / oneRowHeight);
        double pageHeightForTable = oneRowHeight * (double)numRowsOnAPage;
        int totalNumPages = (int)Math.ceil((double)this.table.getRowCount() / (double)numRowsOnAPage);
        if (pageIndex >= totalNumPages) {
            return 1;
        }
        g2.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        g2.drawString("Pagina: " + (pageIndex + 1), (int)pageWidth / 2 - 35, (int)(pageHeight + (double)fontHeight - (double)fontDesent));
        g2.translate(0.0, headerHeightOnPage);
        g2.translate(0.0, (double)(-pageIndex) * pageHeightForTable);
        if (pageIndex + 1 == totalNumPages) {
            int lastRowPrinted = numRowsOnAPage * pageIndex;
            int numRowsLeft = this.table.getRowCount() - lastRowPrinted;
            g2.setClip(0, (int)(pageHeightForTable * (double)pageIndex), (int)Math.ceil(tableWidthOnPage), (int)Math.ceil(oneRowHeight * (double)numRowsLeft));
        } else {
            g2.setClip(0, (int)(pageHeightForTable * (double)pageIndex), (int)Math.ceil(tableWidthOnPage), (int)Math.ceil(pageHeightForTable));
        }
        g2.scale(scale, scale);
        this.table.paint(g2);
        g2.scale(1.0 / scale, 1.0 / scale);
        g2.translate(0.0, (double)pageIndex * pageHeightForTable);
        g2.translate(0.0, -headerHeightOnPage);
        g2.setClip(0, 0, (int)Math.ceil(tableWidthOnPage), (int)Math.ceil(headerHeightOnPage));
        g2.scale(scale, scale);
        this.table.getTableHeader().paint(g2);
        return 0;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        if (this.oListener == null || !this.enableEvents) {
            return;
        }
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        if (!lsm.isSelectionEmpty()) {
            int row = lsm.getMinSelectionIndex();
            int previousRow = e.getFirstIndex();
            this.oListener.rowSelected(new Event(this), previousRow, row, 0);
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (this.oListener == null || !this.enableEvents) {
            return;
        }
        int row = e.getFirstRow();
        int col = e.getColumn();
        if (e.getType() == 1) {
            this.oListener.rowInserted(new Event(this), row);
        } else if (e.getType() == -1) {
            this.oListener.rowDeleted(new Event(this), row);
        } else if (e.getType() == 0) {
            String value = null;
            if (col >= 0) {
                value = (String)this.model.getValueAt(row, col);
            }
            this.oListener.rowUpdated(new Event(this), row, col, value);
        }
    }

    public class Event
    extends EventObject {
        Event(MyTable o) {
            super(o);
        }
    }

    public static interface Listener {
        public void rowSelected(Event var1, int var2, int var3, int var4);

        public void rowInserted(Event var1, int var2);

        public void rowDeleted(Event var1, int var2);

        public void rowUpdated(Event var1, int var2, int var3, String var4);
    }
}

