/*
 * Decompiled with CFR 0.152.
 */
package util.gps;

import java.awt.Dimension;
import java.text.DecimalFormat;
import javax.swing.ImageIcon;
import util.Util;

public class Navigation {
    private static final int NUM_DIRS = 8;
    private static final double SECTOR = 45.0;
    private static final String[] DIRECTION_NAME = new String[]{"N", "NE", "E", "SE", "S", "SW", "W", "NW"};
    private static final String[] DIRECTION_IMAGENAME = new String[]{"ClockN.png", "ClockNE.png", "ClockE.png", "ClockSE.png", "ClockS.png", "ClockSW.png", "ClockW.png", "ClockNW.png"};
    private static final String[] NAVIGATION_INSTRUCTIONS = new String[]{"Go straight ahead", "Change the direction", "Turn left", "Turn right"};
    private static ImageIcon[] DIRECTION_IMAGE;
    private static Dimension ImagesDimension;
    private static final DecimalFormat f2;

    public Navigation() {
        DIRECTION_IMAGE = new ImageIcon[DIRECTION_IMAGENAME.length];
        for (int d = 0; d < DIRECTION_NAME.length; ++d) {
            Navigation.DIRECTION_IMAGE[d] = Util.cargarImagen("/images/", DIRECTION_IMAGENAME[d]);
        }
        int width = DIRECTION_IMAGE[0].getIconWidth();
        int height = DIRECTION_IMAGE[0].getIconHeight();
        ImagesDimension = new Dimension(width, height);
    }

    public Dimension getImagesDimension() {
        return ImagesDimension;
    }

    public static double getAzimuth(double x1, double y1, double x2, double y2) {
        double radians = Math.atan2(x2 - x1, y2 - y1);
        double degrees = Math.toDegrees(radians);
        if (degrees < 0.0) {
            degrees += 360.0;
        }
        return degrees;
    }

    public static int getBearingSector(double azimuth) {
        int index = (int)Math.round(azimuth / 45.0) % 8;
        return index;
    }

    public static String getBearingName(double azimuth) {
        int index = Navigation.getBearingSector(azimuth);
        return DIRECTION_NAME[index];
    }

    public static ImageIcon getBearingImage(double azimuth) {
        int index = Navigation.getBearingSector(azimuth);
        return DIRECTION_IMAGE[index];
    }

    public static String getBearingString(double azimuth) {
        String s = Navigation.getBearingName(azimuth) + " (" + f2.format(azimuth) + "\u00ba)";
        return s;
    }

    public static String getNavInstructions(int bearing0, int bearing1) {
        String navInstr = "";
        int dirDiff = (bearing1 + 8 - bearing0) % 8;
        if (dirDiff == 0) {
            navInstr = NAVIGATION_INSTRUCTIONS[0];
        } else if (Math.abs(dirDiff) == 4) {
            navInstr = NAVIGATION_INSTRUCTIONS[1];
        } else if (dirDiff > 4) {
            navInstr = NAVIGATION_INSTRUCTIONS[2];
        } else if (dirDiff < 4) {
            navInstr = NAVIGATION_INSTRUCTIONS[3];
        }
        return navInstr;
    }

    static {
        f2 = new DecimalFormat("##0.00");
    }
}

