/*
 * Decompiled with CFR 0.152.
 */
package util.gps;

import util.gps.Elipsoide;
import util.gps.Elipsoides;
import util.gps.GeodeticCoordinates;
import util.gps.UTMCoordinates;

public class LatLongUTM {
    public static final int WGS84 = 23;
    private static final double FOURTHPI = 0.7853981633974483;
    private static final double deg2rad = Math.PI / 180;
    private static final double rad2deg = 57.29577951308232;
    private static Elipsoides elipsoides = new Elipsoides();

    public static UTMCoordinates LLtoUTM(int ReferenceEllipsoid, GeodeticCoordinates geocoord) {
        Elipsoide elipsoide = elipsoides.getElipsoide(ReferenceEllipsoid);
        if (elipsoide == null) {
            return null;
        }
        UTMCoordinates utmcoor = new UTMCoordinates();
        double k0 = 0.9996;
        double a = elipsoide.getRadioEcuatorial();
        double eccSquared = elipsoide.getExcentricidadAlCuadrado();
        double LatRad = geocoord.latitude * (Math.PI / 180);
        double LongRad = geocoord.longitude * (Math.PI / 180);
        double LongOrigin = geocoord.longitude > -6.0 && geocoord.longitude <= 0.0 ? -3.0 : (geocoord.longitude < 6.0 && geocoord.longitude > 0.0 ? 3.0 : (double)((int)(geocoord.longitude / 6.0)) * 6.0 + 3.0 * (double)((int)(geocoord.longitude / 6.0)) / (double)((int)Math.abs(geocoord.longitude / 6.0)));
        double LongOriginRad = LongOrigin * (Math.PI / 180);
        utmcoor.zoneNumber = (int)((geocoord.longitude + 180.0) / 6.0) + 1;
        utmcoor.zoneLetter = LatLongUTM.UTMLetterDesignator(geocoord.latitude);
        double eccPrimeSquared = eccSquared / (1.0 - eccSquared);
        double N = a / Math.sqrt(1.0 - eccSquared * Math.sin(LatRad) * Math.sin(LatRad));
        double T = Math.tan(LatRad) * Math.tan(LatRad);
        double C = eccPrimeSquared * Math.cos(LatRad) * Math.cos(LatRad);
        double A = Math.cos(LatRad) * (LongRad - LongOriginRad);
        double M = a * ((1.0 - eccSquared / 4.0 - 3.0 * eccSquared * eccSquared / 64.0 - 5.0 * eccSquared * eccSquared * eccSquared / 256.0) * LatRad - (3.0 * eccSquared / 8.0 + 3.0 * eccSquared * eccSquared / 32.0 + 45.0 * eccSquared * eccSquared * eccSquared / 1024.0) * Math.sin(2.0 * LatRad) + (15.0 * eccSquared * eccSquared / 256.0 + 45.0 * eccSquared * eccSquared * eccSquared / 1024.0) * Math.sin(4.0 * LatRad) - 35.0 * eccSquared * eccSquared * eccSquared / 3072.0 * Math.sin(6.0 * LatRad));
        utmcoor.x = k0 * N * (A + (1.0 - T + C) * A * A * A / 6.0 + (5.0 - 18.0 * T + T * T + 72.0 * C - 58.0 * eccPrimeSquared) * A * A * A * A * A / 120.0) + 500000.0;
        utmcoor.y = k0 * (M + N * Math.tan(LatRad) * (A * A / 2.0 + (5.0 - T + 9.0 * C + 4.0 * C * C) * A * A * A * A / 24.0 + (61.0 - 58.0 * T + T * T + 600.0 * C - 330.0 * eccPrimeSquared) * A * A * A * A * A * A / 720.0));
        if (geocoord.latitude < 0.0) {
            utmcoor.y += 1.0E7;
        }
        return utmcoor;
    }

    public static GeodeticCoordinates UTMtoLL(int ellipsoid, UTMCoordinates utmcoord) {
        Elipsoide elipsoide = elipsoides.getElipsoide(ellipsoid);
        if (elipsoide == null) {
            return null;
        }
        double k0 = 0.9996;
        double a = elipsoide.getRadioEcuatorial();
        double eccSquared = elipsoide.getExcentricidadAlCuadrado();
        double aux = Math.sqrt(1.0 - eccSquared);
        double e1 = (1.0 - aux) / (1.0 + aux);
        double x = utmcoord.x - 500000.0;
        double y = utmcoord.y;
        if (utmcoord.northernHemisphere()) {
            boolean NorthernHemisphere = true;
        } else {
            boolean NorthernHemisphere = false;
            y -= 1.0E7;
        }
        double LongOrigin = (utmcoord.zoneNumber - 1) * 6 - 180 + 3;
        double eccPrimeSquared = eccSquared / (1.0 - eccSquared);
        double M = y / k0;
        double mu = M / (a * (1.0 - eccSquared / 4.0 - 3.0 * eccSquared * eccSquared / 64.0 - 5.0 * eccSquared * eccSquared * eccSquared / 256.0));
        double phi1Rad = mu + (3.0 * e1 / 2.0 - 27.0 * e1 * e1 * e1 / 32.0) * Math.sin(2.0 * mu) + (21.0 * e1 * e1 / 16.0 - 55.0 * e1 * e1 * e1 * e1 / 32.0) * Math.sin(4.0 * mu) + 151.0 * e1 * e1 * e1 / 96.0 * Math.sin(6.0 * mu);
        double N1 = a / Math.sqrt(1.0 - eccSquared * Math.sin(phi1Rad) * Math.sin(phi1Rad));
        double T1 = Math.tan(phi1Rad) * Math.tan(phi1Rad);
        double C1 = eccPrimeSquared * Math.cos(phi1Rad) * Math.cos(phi1Rad);
        double R1 = a * (1.0 - eccSquared) / Math.pow(1.0 - eccSquared * Math.sin(phi1Rad) * Math.sin(phi1Rad), 1.5);
        double D = x / (N1 * k0);
        GeodeticCoordinates geocoord = new GeodeticCoordinates();
        double latRad = phi1Rad - N1 * Math.tan(phi1Rad) / R1 * (D * D / 2.0 - (5.0 + 3.0 * T1 + 10.0 * C1 - 4.0 * C1 * C1 - 9.0 * eccPrimeSquared) * D * D * D * D / 24.0 + (61.0 + 90.0 * T1 + 298.0 * C1 + 45.0 * T1 * T1 - 252.0 * eccPrimeSquared - 3.0 * C1 * C1) * D * D * D * D * D * D / 720.0);
        geocoord.latitude = latRad * 57.29577951308232;
        double lonRad = (D - (1.0 + 2.0 * T1 + C1) * D * D * D / 6.0 + (5.0 - 2.0 * C1 + 28.0 * T1 - 3.0 * C1 * C1 + 8.0 * eccPrimeSquared + 24.0 * T1 * T1) * D * D * D * D * D / 120.0) / Math.cos(phi1Rad);
        geocoord.longitude = LongOrigin + lonRad * 57.29577951308232;
        return geocoord;
    }

    public static GeodeticCoordinates UTMtoLL(double x, double y, int zoneNumber, char zoneLetter, int ellipsoid) {
        UTMCoordinates utm = new UTMCoordinates(zoneNumber, zoneLetter, x, y);
        GeodeticCoordinates geo = LatLongUTM.UTMtoLL(ellipsoid, utm);
        return geo;
    }

    public static char UTMLetterDesignator(double Lat) {
        int LetterDesignator = 80.0 >= Lat && Lat > 72.0 ? 88 : (72.0 >= Lat && Lat > 64.0 ? 87 : (64.0 >= Lat && Lat > 56.0 ? 86 : (56.0 >= Lat && Lat > 48.0 ? 85 : (48.0 >= Lat && Lat > 40.0 ? 84 : (40.0 >= Lat && Lat > 32.0 ? 83 : (32.0 >= Lat && Lat > 24.0 ? 82 : (24.0 >= Lat && Lat > 16.0 ? 81 : (16.0 >= Lat && Lat > 8.0 ? 80 : (8.0 >= Lat && Lat > 0.0 ? 78 : (0.0 >= Lat && Lat > -8.0 ? 77 : (-8.0 >= Lat && Lat > -16.0 ? 76 : (-16.0 >= Lat && Lat > -24.0 ? 75 : (-24.0 >= Lat && Lat > -32.0 ? 74 : (-32.0 >= Lat && Lat > -40.0 ? 72 : (-40.0 >= Lat && Lat > -48.0 ? 71 : (-48.0 >= Lat && Lat > -56.0 ? 70 : (-56.0 >= Lat && Lat > -64.0 ? 69 : (-64.0 >= Lat && Lat > -72.0 ? 68 : (-72.0 >= Lat && Lat > -80.0 ? 67 : 90)))))))))))))))))));
        return (char)LetterDesignator;
    }
}

