/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class Util {
    static final Color[] colors = new Color[]{Color.BLACK, Color.BLUE, Color.CYAN, Color.DARK_GRAY};
    private static Cursor cursorNormal = new Cursor(0);
    private static Cursor cursorEsperas = new Cursor(3);
    private static Toolkit tk = Toolkit.getDefaultToolkit();

    public static void setCursorNormal(Container c) {
        c.setCursor(cursorNormal);
    }

    public static void setCursorEsperas(Container c) {
        c.setCursor(cursorEsperas);
    }

    public static boolean writeTextFile(String filename, String text) {
        FileWriter fw;
        File file = new File(".", filename);
        try {
            fw = new FileWriter(file);
        }
        catch (IOException e) {
            System.err.println("Error al abrir fichero " + file);
            return false;
        }
        try {
            fw.write(text);
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static JPanel createBorderPanel(String title) {
        JPanel p = new JPanel();
        TitledBorder b = new TitledBorder(title);
        p.setBorder(b);
        return p;
    }

    public static int parseInt(String s) {
        int n = 0;
        try {
            n = Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    public static long parseLong(String s) {
        long n = 0L;
        try {
            n = Long.parseLong(s);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    public static float parseFloat(String s) {
        float n = 0.0f;
        s = s.replace(',', '.');
        try {
            n = Float.parseFloat(s);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    public static double parseDouble(String s) {
        double n = 0.0;
        s = s.replace(',', '.');
        try {
            n = Double.parseDouble(s);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    public static String doubleWithDotPoint(String v) {
        String s = v.replace(',', '.');
        return s;
    }

    public static File getCurrentPath() {
        File path = new File(System.getProperty("user.dir", "."));
        return path;
    }

    public static File getUserHome() {
        File path = new File(System.getProperty("user.home"));
        return path;
    }

    public static String getUserName() {
        String s = System.getProperty("user.name");
        return s;
    }

    public static boolean isWindows() {
        String OS = System.getProperty("os.name").toLowerCase();
        return OS.indexOf("win") >= 0;
    }

    public static boolean isMac() {
        String OS = System.getProperty("os.name").toLowerCase();
        return OS.indexOf("mac") >= 0;
    }

    public static boolean isUnix() {
        String OS = System.getProperty("os.name").toLowerCase();
        return OS.indexOf("nix") >= 0 || OS.indexOf("nux") >= 0 || OS.indexOf("aix") > 0;
    }

    public static boolean isSolaris() {
        String OS = System.getProperty("os.name").toLowerCase();
        return OS.indexOf("sunos") >= 0;
    }

    public static File searchFile(String filename, String fromPath) {
        File path = new File(fromPath);
        File file = Util.searchFile(filename, path);
        return file;
    }

    public static File searchFile(String filename, File path) {
        File fileFound = null;
        File[] files = path.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    fileFound = Util.searchFile(filename, file);
                    if (fileFound == null) continue;
                    return fileFound;
                }
                if (!filename.equalsIgnoreCase(file.getName())) continue;
                return file;
            }
        }
        return null;
    }

    public static ImageIcon cargarImagen(String path, String filename) {
        URL url = Util.class.getResource(path + filename);
        ImageIcon icon = new ImageIcon(url);
        return icon;
    }

    public static boolean overwriteFile(JFrame f, String filename) {
        File file = new File(filename);
        if (!file.exists()) {
            return true;
        }
        int n = JOptionPane.showConfirmDialog(f, "File '" + filename + "' exists.\nAre you sure to overwrite it?", "Overwrite existing file", 0);
        boolean write = n == 0;
        return write;
    }

    public static void clipboardCopy(String text) {
        Clipboard clipboard = tk.getSystemClipboard();
        StringSelection data = new StringSelection(text);
        clipboard.setContents(data, data);
    }
}

