/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import util.Util;

public class MyXML {
    private Document doc;
    private String errorMessage;

    public String getErrorMessage() {
        this.errorMessage = this.errorMessage.replace(';', '\n');
        return this.errorMessage;
    }

    public boolean open(String filename_xml) {
        this.errorMessage = "";
        this.doc = null;
        try {
            File f = new File(filename_xml);
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            this.doc = dBuilder.parse(f);
            this.doc.getDocumentElement().normalize();
        }
        catch (ParserConfigurationException e) {
            System.err.println(e);
            this.errorMessage = e.toString();
            return false;
        }
        catch (SAXException e) {
            System.err.println(e);
            this.errorMessage = e.toString();
            return false;
        }
        catch (IOException e) {
            System.err.println(e);
            this.errorMessage = e.toString();
            return false;
        }
        return true;
    }

    public String getRoot() {
        if (this.doc == null) {
            return null;
        }
        String s = this.doc.getDocumentElement().getNodeName();
        return s;
    }

    public NodeList getElements(String tagName) {
        NodeList listXML = this.doc.getElementsByTagName(tagName);
        return listXML;
    }

    public NodeList getSubElements(Element parent, String tagName) {
        NodeList sublistXML = parent.getElementsByTagName(tagName);
        return sublistXML;
    }

    public static Element getElement(NodeList listXML, int index) {
        Element elementXML = null;
        Node nodeXML = listXML.item(index);
        if (nodeXML.getNodeType() == 1) {
            elementXML = (Element)nodeXML;
        }
        return elementXML;
    }

    public static String getParam(Element element, String name, String currentValue) {
        String s = element.getAttribute(name);
        if (s == null || s.isEmpty()) {
            s = currentValue;
        }
        return s;
    }

    public static int getParam(Element element, String name, int currentValue) {
        String s = element.getAttribute(name);
        int n = s == null || s.isEmpty() ? currentValue : Util.parseInt(s);
        return n;
    }

    public static long getParam(Element element, String name, long currentValue) {
        String s = element.getAttribute(name);
        long n = s == null || s.isEmpty() ? currentValue : Util.parseLong(s);
        return n;
    }

    public static float getParam(Element element, String name, float currentValue) {
        String s = element.getAttribute(name);
        float n = s == null || s.isEmpty() ? currentValue : Util.parseFloat(s);
        return n;
    }

    public static double getParam(Element element, String name, double currentValue) {
        String s = element.getAttribute(name);
        double n = s == null || s.isEmpty() ? currentValue : Util.parseDouble(s);
        return n;
    }

    public static boolean getParam(Element element, String name, boolean currentValue) {
        String s = element.getAttribute(name);
        boolean n = s == null || s.isEmpty() ? currentValue : s.equals("1");
        return n;
    }
}

