/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JTextArea;
import javax.swing.SwingWorker;
import util.ProcessWatcher;

public class ExternalCommand
extends SwingWorker<Integer, String> {
    private static final String PREFIX_CLEAR = "clr: ";
    private static final String PREFIX_OUTPUT = "out: ";
    private static final String PREFIX_ERRORS = "err: ";
    private File path;
    private String title;
    private String command;
    private JTextArea txtOutput;
    private JTextArea txtErrors;
    private long timeout_ms;
    private boolean clear;
    private boolean gui;
    Process p = null;
    ProcessWatcher pw = null;
    private BufferedReader stdInput;
    private BufferedReader stdError;
    private boolean successful;
    private boolean cancelledByTimeout;
    private boolean cancelledByUser;
    private int exitValue;

    public ExternalCommand(File path, String title, String command, long timeout_ms, JTextArea txtOutput, JTextArea txtErrors, boolean clear, boolean gui) {
        this.path = path;
        this.title = title;
        this.command = command;
        this.timeout_ms = timeout_ms;
        this.txtOutput = txtOutput;
        this.txtErrors = txtErrors == null ? txtOutput : txtErrors;
        this.clear = clear;
        this.gui = gui;
    }

    public boolean getSuccessful() {
        try {
            this.get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
        return this.successful;
    }

    public int exitValue() {
        return this.exitValue;
    }

    public boolean getCancelledByTimeout() {
        return this.cancelledByTimeout;
    }

    public boolean getCancelledByUser() {
        return this.cancelledByUser;
    }

    public Process getProcess() {
        return this.p;
    }

    public void abort() {
        this.exitValue = -1;
        if (this.pw != null) {
            this.pw.thread.interrupt();
            this.pw = null;
        }
        if (this.p != null) {
            this.p.destroy();
            try {
                this.p.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.cancel(true);
    }

    @Override
    protected Integer doInBackground() throws Exception {
        long elapsedTime;
        long endTime;
        boolean timeout = false;
        if (this.clear) {
            this.publish(PREFIX_CLEAR);
            Thread.sleep(10L);
        }
        this.publish(PREFIX_OUTPUT + this.title + "\n");
        this.publish("out: $ " + this.command + "\n");
        if (this.path != null && !this.path.exists()) {
            this.publish("err: Working path does not exists:\n    " + this.path);
            return 1;
        }
        long startTime = System.nanoTime();
        int numLinesError = 0;
        this.cancelledByUser = false;
        this.cancelledByTimeout = false;
        this.successful = false;
        try {
            if (!this.command.contains("\"")) {
                this.p = Runtime.getRuntime().exec(this.command, null, this.path);
            } else {
                ArrayList<String> list = new ArrayList<String>();
                Matcher m = Pattern.compile("([^\"]\\S*|\".+?\")\\s*").matcher(this.command);
                while (m.find()) {
                    String s = m.group(1);
                    s = s.replace("\"", "");
                    list.add(s);
                }
                String[] args = new String[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    args[i] = (String)list.get(i);
                }
                this.p = Runtime.getRuntime().exec(args, null, this.path);
            }
        }
        catch (Exception e) {
            this.publish(PREFIX_ERRORS + e.getMessage());
            return 1;
        }
        this.stdInput = new BufferedReader(new InputStreamReader(this.p.getInputStream()));
        this.stdError = new BufferedReader(new InputStreamReader(this.p.getErrorStream()));
        if (this.gui) {
            this.p.waitFor();
        } else {
            try {
                this.pw = new ProcessWatcher(this.p);
                while (!(this.isCancelled() || this.pw.isFinished() || timeout)) {
                    numLinesError += this.showMessages();
                    endTime = System.nanoTime();
                    elapsedTime = (endTime - startTime) / 1000000L;
                    timeout = this.timeout_ms > 0L && elapsedTime > this.timeout_ms;
                    Thread.sleep(100L);
                }
                if (timeout) {
                    this.cancelledByTimeout = timeout;
                    this.abort();
                }
            }
            catch (InterruptedException e) {
                this.cancelledByUser = true;
            }
        }
        numLinesError += this.showMessages();
        this.exitValue = this.p.exitValue();
        endTime = System.nanoTime();
        elapsedTime = (endTime - startTime) / 1000000L;
        if (this.isCancelled() || timeout) {
            this.successful = false;
            this.publish("out: Cancelled " + (timeout ? "because of timeout" : "by user") + " (" + elapsedTime + " ms.)\n\n");
        } else {
            this.successful = this.exitValue == 0;
            this.publish(PREFIX_OUTPUT + (this.successful ? "Successful" : "Failed") + " (" + elapsedTime + " ms.)\n\n");
        }
        return numLinesError;
    }

    private int showMessages() {
        int numLinesError = 0;
        try {
            String line;
            if (this.stdInput.ready()) {
                while ((line = this.stdInput.readLine()) != null) {
                    this.publish(PREFIX_OUTPUT + line + "\n");
                }
            }
            if (this.stdError.ready()) {
                while ((line = this.stdError.readLine()) != null) {
                    this.publish(PREFIX_ERRORS + line + "\n");
                    ++numLinesError;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return numLinesError;
    }

    @Override
    protected void process(List<String> chunks) {
        for (String chunk : chunks) {
            String line = chunk;
            if (line.startsWith(PREFIX_CLEAR)) {
                this.txtOutput.setText("");
                this.txtErrors.setText("");
                continue;
            }
            if (line.startsWith(PREFIX_OUTPUT)) {
                this.txtOutput.append(line.substring(PREFIX_OUTPUT.length()));
                continue;
            }
            this.txtOutput.append(line.substring(PREFIX_ERRORS.length()));
        }
    }

    @Override
    protected void done() {
        try {
            int n = (Integer)this.get();
        }
        catch (InterruptedException e) {
        }
        catch (ExecutionException e) {
        }
        catch (CancellationException e) {
        }
        finally {
            try {
                if (this.stdInput != null) {
                    this.stdInput.close();
                }
                if (this.stdError != null) {
                    this.stdError.close();
                }
            }
            catch (IOException e) {
                String msg = e.getMessage();
                this.txtErrors.append(msg + "\n");
            }
        }
    }
}

