/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.awt.Choice;
import java.awt.Color;
import java.awt.List;

public enum Colors {
    BLACK(Color.BLACK, "Black"),
    BLUE(Color.BLUE, "Blue"),
    CYAN(Color.CYAN, "Cyan"),
    DARK_GRAY(Color.DARK_GRAY, "Dark Gray"),
    GRAY(Color.GRAY, "Gray"),
    GREEN(Color.GREEN, "Green"),
    LIGHT_GRAY(Color.LIGHT_GRAY, "Light Gray"),
    MAGENTA(Color.MAGENTA, "Magenta"),
    ORANGE(Color.ORANGE, "Orange"),
    PINK(Color.PINK, "Pink"),
    RED(Color.RED, "Red"),
    WHITE(Color.WHITE, "White"),
    YELLOW(Color.YELLOW, "Yellow");

    private Color color;
    private String name;

    private Colors(Color color, String name) {
        this.color = color;
        this.name = name;
    }

    public Color getColor() {
        return this.color;
    }

    public String getName() {
        return this.name;
    }

    public static Colors search(Color color) {
        for (Colors c : Colors.values()) {
            if (c.getColor() != color) continue;
            return c;
        }
        return null;
    }

    public static Colors search(String name) {
        for (Colors c : Colors.values()) {
            if (!c.getName().equalsIgnoreCase(name)) continue;
            return c;
        }
        return null;
    }

    public static int fill(Choice comp) {
        comp.removeAll();
        for (Colors c : Colors.values()) {
            comp.add(c.getName());
        }
        return Colors.values().length;
    }

    public static int fill(List comp) {
        comp.removeAll();
        for (Colors c : Colors.values()) {
            comp.add(c.getName());
        }
        return Colors.values().length;
    }

    public String toString() {
        return this.name;
    }
}

