/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.osm;

import gatcomsumo.osm.OSM_Edge;
import gatcomsumo.osm.OSM_Exception;
import gatcomsumo.osm.OSM_ExportFormat;
import gatcomsumo.osm.OSM_Node;
import gatcomsumo.osm.OpenStreetMap;
import gatcomsumo.osm.Scenario;
import java.awt.geom.Point2D;
import util.gps.GeodeticCoordinates;
import util.gps.LatLongUTM;
import util.gps.UTMCoordinates;

public class ScenarioOSM
extends Scenario {
    public OpenStreetMap osm;
    static final int MAX_NODES_PER_WAY = 2000;
    int[] xPoints = new int[2000];
    int[] yPoints = new int[2000];

    public ScenarioOSM() {
        this(0L, "scenario");
    }

    public ScenarioOSM(long seed, String name) {
        this(seed, name, 38.26615, -0.69742, 38.2831, -0.67708);
    }

    public ScenarioOSM(long seed, String name, double south, double west, double north, double east) {
        super(seed, name);
        this.setLatLong(name, south, west, north, east);
    }

    public void setLatLong(String name, double south, double west, double north, double east) {
        this.osm = new OpenStreetMap(name, south, west, north, east);
        this.area = this.osm.area;
        this.utilizarBuffer = false;
    }

    public void setUTM(String name, double x_min, double y_min, double x_max, double y_max, double margin, int zoneNumber, char zoneLetter, int ellipsoid) {
        UTMCoordinates utm_sw = new UTMCoordinates(zoneNumber, zoneLetter, x_min - margin, y_min - margin);
        GeodeticCoordinates geo_sw = LatLongUTM.UTMtoLL(ellipsoid, utm_sw);
        UTMCoordinates utm_ne = new UTMCoordinates(zoneNumber, zoneLetter, x_max + margin, y_max + margin);
        GeodeticCoordinates geo_ne = LatLongUTM.UTMtoLL(ellipsoid, utm_ne);
        double west = geo_sw.longitude;
        double south = geo_sw.latitude;
        double east = geo_ne.longitude;
        double north = geo_ne.latitude;
        this.setLatLong(name, west, south, east, north);
    }

    public String download(String filename) {
        String request = this.download(filename, OSM_ExportFormat.OSM_XML, 0);
        return request;
    }

    public String download(String filename, OSM_ExportFormat format, int timeout) {
        String request = "";
        try {
            request = this.osm.download(filename, format, 0);
        }
        catch (OSM_Exception e) {
            e.printStackTrace();
        }
        return request;
    }

    public void loadXML(String filename) {
        if (!filename.endsWith(".osm.xml")) {
            filename = filename + ".osm.xml";
        }
        this.osm.loadXML(filename);
    }

    @Override
    public Point2D randomPosition() {
        Point2D position;
        int numVias = this.osm.edges.size();
        if (numVias == 0) {
            double x = this.rng.random(0.0, this.osm.area.width);
            double y = this.rng.random(0.0, this.osm.area.height);
            int signoX = this.osm.area.p0.getX() < this.osm.area.p1.getX() ? 1 : -1;
            int signoY = this.osm.area.p0.getY() < this.osm.area.p1.getY() ? 1 : -1;
            x = this.osm.area.p0.getX() + (double)signoX * x;
            y = this.osm.area.p0.getY() + (double)signoY * y;
            position = new Point2D.Double(x, y);
        } else {
            int v = (int)this.rng.random(0.0, numVias);
            OSM_Edge osm_edge = this.osm.edges.get(v);
            int numNodes = osm_edge.nodes.size();
            int n = (int)this.rng.random(0.0, numNodes);
            OSM_Node osm_node = osm_edge.nodes.get(n);
            position = osm_node.getPoint();
        }
        return position;
    }

    @Override
    public boolean containsPosition(Point2D position) {
        return this.osm.area.inside(position);
    }

    @Override
    public boolean containsPosition(double x, double y) {
        return this.osm.area.inside(x, y);
    }

    public String toString() {
        return "(" + this.osm.area.width + "x" + this.osm.area.height + ")";
    }
}

