/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.osm;

import gatcomsumo.osm.GeometryRectangle;
import gatcomsumo.osm.OSM_Edge;
import gatcomsumo.osm.OSM_Exception;
import gatcomsumo.osm.OSM_ExportFormat;
import gatcomsumo.osm.OSM_Node;
import java.awt.geom.Point2D;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import util.MyXML;
import util.Util;
import util.gps.GeodeticCoordinates;
import util.gps.LatLongUTM;
import util.gps.UTMCoordinates;

public class OpenStreetMap {
    private static final String URL_XML = "http://api.openstreetmap.org/api/0.6/map";
    private static final String URL_XML2 = "http://overpass-api.de/api/map";
    private static final String URL_IMG = "http://parent.tile.openstreetmap.org/cgi-bin/export";
    private static final String URL_IMG2 = "http://render.openstreetmap.org/cgi-bin/export";
    private static final int SCALE_IMAGE = 13584;
    private String name = "";
    private String downloadErrorMessage = "";
    private double south = 0.0;
    private double west = 0.0;
    private double north = 0.0;
    private double east = 0.0;
    public GeometryRectangle area;
    public GeodeticCoordinates geo_sw;
    public GeodeticCoordinates geo_ne;
    public UTMCoordinates utm_sw;
    public UTMCoordinates utm_ne;
    public ArrayList<OSM_Node> nodes;
    public ArrayList<OSM_Edge> edges;

    public OpenStreetMap() {
        this("Elche", 38.26615, -0.69742, 38.2831, -0.67708);
    }

    public OpenStreetMap(String name, double south, double west, double north, double east) {
        this.name = name;
        this.south = south;
        this.west = west;
        this.north = north;
        this.east = east;
        this.area = this.createArea(south, west, north, east);
        this.nodes = new ArrayList();
        this.edges = new ArrayList();
    }

    public OpenStreetMap(String name, GeodeticCoordinates geo_sw, GeodeticCoordinates geo_ne) {
        this(name, geo_sw.latitude, geo_sw.longitude, geo_ne.latitude, geo_ne.longitude);
    }

    public OpenStreetMap(String name, UTMCoordinates utm_sw, UTMCoordinates utm_ne, double margin) {
        this.geo_sw = LatLongUTM.UTMtoLL(utm_sw.x - margin, utm_sw.y - margin, utm_sw.zoneNumber, utm_sw.zoneLetter, 23);
        this.geo_ne = LatLongUTM.UTMtoLL(utm_ne.x + margin, utm_ne.y + margin, utm_ne.zoneNumber, utm_ne.zoneLetter, 23);
        this.name = name;
        this.south = this.geo_sw.latitude;
        this.west = this.geo_sw.longitude;
        this.north = this.geo_ne.latitude;
        this.east = this.geo_ne.longitude;
        this.area = this.createArea(this.south, this.west, this.north, this.east);
        this.nodes = new ArrayList();
        this.edges = new ArrayList();
    }

    private GeometryRectangle createArea(double south, double west, double north, double east) {
        GeodeticCoordinates geocoord_topleft = new GeodeticCoordinates(north, west);
        GeodeticCoordinates geocoord_bottomright = new GeodeticCoordinates(south, east);
        UTMCoordinates utmcoord_topleft = LatLongUTM.LLtoUTM(23, geocoord_topleft);
        UTMCoordinates utmcoord_bottomright = LatLongUTM.LLtoUTM(23, geocoord_bottomright);
        Point2D topleft = utmcoord_topleft.getPoint();
        Point2D bottomright = utmcoord_bottomright.getPoint();
        GeometryRectangle area = new GeometryRectangle(topleft, bottomright);
        return area;
    }

    public boolean downloable() {
        if (this.south < -90.0 || this.south > 90.0 || this.north < -90.0 || this.north > 90.0) {
            this.downloadErrorMessage = "The latitudes must be between -90 and 90.";
            return false;
        }
        if (this.west < -180.0 || this.west > 180.0 || this.east < -180.0 || this.east > 180.0) {
            this.downloadErrorMessage = "The longitudes must be between -180 and 180.";
            return false;
        }
        if (this.south > this.north) {
            this.downloadErrorMessage = "The south-west latitude should be less than the north-east one.";
            return false;
        }
        if (this.west > this.east) {
            this.downloadErrorMessage = "The south-west longitude should be less than the north-east one.";
            return false;
        }
        this.downloadErrorMessage = "";
        return true;
    }

    public String getDownloadErrorMessage() {
        return this.downloadErrorMessage;
    }

    public String download(String filename) throws OSM_Exception {
        String request = this.download(filename, OSM_ExportFormat.OSM_XML, 0);
        return request;
    }

    public String download(String filename, OSM_ExportFormat format, int timeout) throws OSM_Exception {
        if (!this.downloable()) {
            System.err.println(this.downloadErrorMessage);
            return "";
        }
        String bbox = "bbox=" + this.west + "," + this.south + "," + this.east + "," + this.north;
        String request = "";
        request = format == OSM_ExportFormat.OSM_XML ? "http://overpass-api.de/api/map?" + bbox : "http://parent.tile.openstreetmap.org/cgi-bin/export?" + bbox + "&scale=" + 13584 + "&format=" + format.extension;
        Util.clipboardCopy(request);
        if (!filename.endsWith("." + format.extension)) {
            filename = filename + "." + format.extension;
        }
        try {
            URL url = new URL(request);
            URLConnection con = url.openConnection();
            if (timeout > 0) {
                con.setReadTimeout(timeout);
            }
            if (format == OSM_ExportFormat.OSM_XML) {
                String line;
                InputStream is = con.getInputStream();
                InputStreamReader isr = new InputStreamReader(is, "UTF-8");
                BufferedReader br = new BufferedReader(isr);
                FileOutputStream fos = new FileOutputStream(filename);
                OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                BufferedWriter bw = new BufferedWriter(osw);
                PrintWriter file = new PrintWriter(bw);
                while ((line = br.readLine()) != null) {
                    file.println(line);
                }
                file.flush();
                file.close();
                bw.close();
                osw.close();
                fos.close();
                br.close();
                isr.close();
                is.close();
            } else {
                byte[] buffer = new byte[1024];
                int bytesRead = 0;
                InputStream is = con.getInputStream();
                BufferedInputStream bis = new BufferedInputStream(is);
                FileOutputStream fos = new FileOutputStream(filename);
                BufferedOutputStream bos = new BufferedOutputStream(fos);
                while ((bytesRead = bis.read(buffer)) != -1) {
                    bos.write(buffer, 0, bytesRead);
                }
                bos.flush();
                bos.close();
                bis.close();
                is.close();
            }
        }
        catch (UnknownHostException e) {
            request = "";
            this.downloadErrorMessage = "Check your Internet connection or try later.\n\nRequest: " + request.substring(0, 75) + "...\n(fully copied to the clipboard; test it from your Internet navigator for more details)";
        }
        catch (Exception e) {
            this.downloadErrorMessage = "";
            if (e.getMessage().contains("code: 400")) {
                this.downloadErrorMessage = this.downloadErrorMessage + "Bad Request or server busy; try later.\n";
                this.downloadErrorMessage = format == OSM_ExportFormat.OSM_XML ? this.downloadErrorMessage + "\n" : this.downloadErrorMessage + "(NOTE: calls to /cgi-bin/export may only be triggered by direct end-user action in OpenStreetMap website\n       http://www.openstreetmap.org/export).\n\n";
            } else if (e.getMessage().contains("code: 509")) {
                this.downloadErrorMessage = this.downloadErrorMessage + "Too much data; bandwidth Limit Exceeded\n\n";
            }
            this.downloadErrorMessage = this.downloadErrorMessage + "Request: " + request.substring(0, 75) + "...\n(fully copied to the clipboard; test it from your Internet navigator for more details)";
            request = "";
            throw new OSM_Exception(this.downloadErrorMessage);
        }
        return request;
    }

    public boolean loadXML(String filename) {
        try {
            int i;
            Element element;
            Node node;
            File f = new File(filename);
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(f);
            doc.getDocumentElement().normalize();
            String s = doc.getDocumentElement().getNodeName();
            if (!s.equalsIgnoreCase("osm")) {
                return false;
            }
            this.nodes.clear();
            this.edges.clear();
            NodeList list = doc.getElementsByTagName("bounds");
            if (list.getLength() > 0 && (node = list.item(0)).getNodeType() == 1) {
                element = (Element)node;
                double minlat = MyXML.getParam(element, "minlat", 0.0);
                double minlon = MyXML.getParam(element, "minlon", 0.0);
                double maxlat = MyXML.getParam(element, "maxlat", 0.0);
                double maxlon = MyXML.getParam(element, "maxlon", 0.0);
                this.south = minlat;
                this.west = minlon;
                this.north = maxlat;
                this.east = maxlon;
                this.area = new GeometryRectangle(this.south, this.west, this.north, this.east);
            }
            list = doc.getElementsByTagName("node");
            int n = list.getLength();
            for (i = 0; i < n; ++i) {
                node = list.item(i);
                if (node.getNodeType() != 1) continue;
                element = (Element)node;
                OSM_Node osm_node = new OSM_Node();
                this.nodes.add(osm_node);
                osm_node.id = MyXML.getParam(element, "id", osm_node.id);
                double lat = MyXML.getParam(element, "lat", 0.0);
                double lon = MyXML.getParam(element, "lon", 0.0);
                osm_node.geocoord = new GeodeticCoordinates(lat, lon);
                osm_node.utmcoord = LatLongUTM.LLtoUTM(23, osm_node.geocoord);
                s = this.getTagValue(element, "name");
                if (s != null && s.length() > 0) {
                    osm_node.name = s;
                }
                if ((s = this.getTagValue(element, "amenity")) != null && s.length() > 0) {
                    osm_node.amenity = s;
                }
                if ((s = this.getTagValue(element, "highway")) == null || s.length() <= 0) continue;
                osm_node.highway = s;
                osm_node.traffic_signals = s.equalsIgnoreCase("traffic_signals");
                osm_node.bus_stop = s.equalsIgnoreCase("bus_stop");
                osm_node.crossing = s.equalsIgnoreCase("crossing");
            }
            list = doc.getElementsByTagName("way");
            n = list.getLength();
            for (i = 0; i < n; ++i) {
                node = list.item(i);
                if (node.getNodeType() != 1) continue;
                element = (Element)node;
                OSM_Edge osm_edge = new OSM_Edge();
                s = element.getAttribute("id");
                osm_edge.id = Long.parseLong(s);
                ArrayList<Long> nodes_id = this.getLongList(element, "nd", "ref");
                block6: for (long id : nodes_id) {
                    for (OSM_Node osm_node_id : this.nodes) {
                        if (osm_node_id.id != id) continue;
                        osm_edge.nodes.add(osm_node_id);
                        osm_node_id.edges.add(osm_edge);
                        continue block6;
                    }
                }
                s = this.getTagValue(element, "name");
                if (s != null && s.length() > 0) {
                    osm_edge.name = s;
                }
                if ((s = this.getTagValue(element, "highway")) != null && s.length() > 0) {
                    osm_edge.highway = s;
                }
                if ((s = this.getTagValue(element, "oneway")) != null && s.length() > 0 && s.equalsIgnoreCase("yes")) {
                    osm_edge.oneway = true;
                }
                if ((s = this.getTagValue(element, "junction")) != null && s.length() > 0 && s.equalsIgnoreCase("roundabout")) {
                    osm_edge.roundabout = true;
                }
                if ((s = this.getTagValue(element, "lanes")) != null && s.length() > 0) {
                    osm_edge.lanes = Integer.parseInt(s);
                }
                if ((s = this.getTagValue(element, "amenity")) != null && s.length() > 0) {
                    osm_edge.amenity = s;
                    osm_edge.parking = s.equalsIgnoreCase("parking");
                }
                if ((s = this.getTagValue(element, "landuse")) != null && s.length() > 0) {
                    osm_edge.landuse = s;
                    osm_edge.greenarea = true;
                }
                if ((s = this.getTagValue(element, "leisure")) != null && s.length() > 0) {
                    osm_edge.leisure = s;
                }
                this.edges.add(osm_edge);
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public String getTagValue(Element element, String tag_k) {
        String tag_v = "";
        NodeList list = element.getElementsByTagName("tag");
        int n = list.getLength();
        for (int i = 0; i < n; ++i) {
            Node t = list.item(i);
            Element tag = (Element)t;
            String s = tag.getAttribute("k");
            if (!s.equalsIgnoreCase(tag_k)) continue;
            tag_v = tag.getAttribute("v");
            break;
        }
        return tag_v;
    }

    public ArrayList<Long> getLongList(Element element, String label, String attribute) {
        ArrayList<Long> nodes = new ArrayList<Long>();
        NodeList list = element.getElementsByTagName(label);
        int n = list.getLength();
        for (int i = 0; i < n; ++i) {
            Node t = list.item(i);
            Element tag = (Element)t;
            String s = tag.getAttribute(attribute);
            long id = Long.parseLong(s);
            nodes.add(id);
        }
        return nodes;
    }
}

