/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.osm;

import gatcomsumo.osm.Geometry;
import gatcomsumo.osm.GeometryLine;
import java.awt.geom.Point2D;

public class GeometrySegment {
    public Point2D p1;
    public Point2D p2;
    public double distance;
    public double azimuth;
    public double radians;

    public GeometrySegment(double x1, double y1, double x2, double y2) {
        this.p1 = new Point2D.Double(x1, y1);
        this.p2 = new Point2D.Double(x2, y2);
        this.distance = Geometry.dist2points(this.p1, this.p2);
        this.azimuth = this.azimuth();
        this.radians = GeometrySegment.azimuth2radians(this.azimuth);
    }

    public GeometrySegment(Point2D p1, Point2D p2) {
        this(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public GeometrySegment(Point2D p1, double azimuth, double distance) {
        this.p1 = (Point2D)p1.clone();
        this.azimuth = azimuth;
        this.distance = distance;
        this.radians = GeometrySegment.azimuth2radians(azimuth);
        double x = p1.getX() + distance * Math.cos(this.radians);
        double y = p1.getY() - distance * Math.sin(this.radians);
        this.p2 = new Point2D.Double(x, y);
    }

    public double distance() {
        double d = Geometry.dist2points(this.p1, this.p2);
        return d;
    }

    public boolean isVertical() {
        return Math.abs(this.p2.getX() - this.p1.getX()) < 1.0E-5;
    }

    public boolean isHorizontal() {
        return Math.abs(this.p2.getY() - this.p1.getY()) < 1.0E-5;
    }

    public boolean inside(Point2D p) {
        return (p.getX() + 1.0E-5 >= this.p1.getX() && p.getX() - 1.0E-5 <= this.p2.getX() || p.getX() - 1.0E-5 <= this.p1.getX() && p.getX() + 1.0E-5 >= this.p2.getX()) && (p.getY() + 1.0E-5 >= this.p1.getY() && p.getY() - 1.0E-5 <= this.p2.getY() || p.getY() - 1.0E-5 <= this.p1.getY() && p.getY() + 1.0E-5 >= this.p2.getY());
    }

    public Point2D intersection(GeometrySegment s2) {
        return GeometrySegment.intersection(this, s2);
    }

    public static Point2D intersection(GeometrySegment s1, GeometrySegment s2) {
        GeometryLine r1 = new GeometryLine(s1);
        GeometryLine r2 = new GeometryLine(s2);
        Point2D pos = r1.intersection(r2);
        if (pos == null) {
            return null;
        }
        if (s1.inside(pos) && s2.inside(pos)) {
            return pos;
        }
        return null;
    }

    public static double azimuth2radians(double azimuth) {
        double degrees = 90.0 - azimuth;
        if (degrees < 0.0) {
            degrees += 360.0;
        }
        double radians = Math.toRadians(degrees);
        return radians;
    }

    public static double radians2azimuth(double radians) {
        double degrees = Math.toDegrees(radians);
        double azimuth = degrees + 90.0;
        if (degrees > 360.0) {
            degrees -= 360.0;
        }
        return azimuth;
    }

    public double azimuth() {
        double azimuth = 0.0;
        if (this.isHorizontal()) {
            azimuth = this.p1.getX() < this.p2.getX() ? 90.0 : 270.0;
            return azimuth;
        }
        if (this.isVertical()) {
            azimuth = this.p1.getY() < this.p2.getY() ? 180.0 : 0.0;
            return azimuth;
        }
        double diffX = Math.abs(this.p1.getX() - this.p2.getX());
        double diffY = Math.abs(this.p1.getY() - this.p2.getY());
        double tan = diffX / diffY;
        double atan = Math.atan(tan);
        double alfa = Math.toDegrees(atan);
        int cuad = GeometrySegment.cuadrante(this.p1, this.p2);
        switch (cuad) {
            case 1: {
                azimuth = 0.0 + alfa;
                break;
            }
            case 2: {
                azimuth = 180.0 - alfa;
                break;
            }
            case 3: {
                azimuth = 180.0 + alfa;
                break;
            }
            case 4: {
                azimuth = 360.0 - alfa;
                break;
            }
        }
        return azimuth;
    }

    public static int cuadrante(Point2D p1, Point2D p2) {
        if (p1 == null || p2 == null) {
            return 0;
        }
        if (p2.getX() > p1.getX()) {
            if (p2.getY() <= p1.getY()) {
                return 1;
            }
            return 2;
        }
        if (p2.getY() > p1.getY()) {
            return 3;
        }
        return 4;
    }

    public String toString() {
        String s = "(" + Geometry.f4.format(this.p1.getX()) + "," + Geometry.f4.format(this.p1.getY()) + ") - (" + Geometry.f4.format(this.p2.getX()) + "," + Geometry.f4.format(this.p2.getY()) + ")";
        return s;
    }
}

