/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.osm;

import gatcomsumo.osm.Geometry;
import java.awt.geom.Point2D;
import util.gps.GeodeticCoordinates;
import util.gps.LatLongUTM;
import util.gps.UTMCoordinates;

public class GeometryRectangle {
    public Point2D p0;
    public Point2D p1;
    public double width;
    public double height;

    public GeometryRectangle(double width, double height) {
        this.p0 = new Point2D.Double(0.0, 0.0);
        this.p1 = new Point2D.Double(width, height);
        this.width = width;
        this.height = height;
    }

    public GeometryRectangle(Point2D p0, double width, double height) {
        this.p0 = new Point2D.Double(p0.getX(), p0.getY());
        this.p1 = new Point2D.Double(p0.getX() + width, p0.getY() + height);
        this.width = width;
        this.height = height;
    }

    public GeometryRectangle(Point2D p0, Point2D p1) {
        this.p0 = new Point2D.Double(p0.getX(), p0.getY());
        this.p1 = new Point2D.Double(p1.getX(), p1.getY());
        this.width = Math.abs(p1.getX() - p0.getX());
        this.height = Math.abs(p1.getY() - p0.getY());
    }

    public GeometryRectangle(double south, double west, double north, double east) {
        GeodeticCoordinates geocoord_topleft = new GeodeticCoordinates(north, west);
        UTMCoordinates utmcoord_topleft = LatLongUTM.LLtoUTM(23, geocoord_topleft);
        GeodeticCoordinates geocoord_bottomright = new GeodeticCoordinates(south, east);
        UTMCoordinates utmcoord_bottomright = LatLongUTM.LLtoUTM(23, geocoord_bottomright);
        Point2D topleft = utmcoord_topleft.getPoint();
        Point2D bottomright = utmcoord_bottomright.getPoint();
        this.p0 = new Point2D.Double(topleft.getX(), topleft.getY());
        this.p1 = new Point2D.Double(bottomright.getX(), bottomright.getY());
        this.width = Math.abs(bottomright.getX() - topleft.getX());
        this.height = Math.abs(bottomright.getY() - topleft.getY());
    }

    public boolean inside(Point2D position) {
        return this.inside(position.getX(), position.getY());
    }

    public boolean inside(double x, double y) {
        boolean insideY;
        boolean insideX = x >= this.p0.getX() && x <= this.p1.getX() || x >= this.p1.getX() && x <= this.p0.getX();
        boolean bl = insideY = y >= this.p0.getY() && y <= this.p1.getY() || y >= this.p1.getY() && y <= this.p0.getY();
        return insideX && insideY;
    }

    public boolean negativeEasting() {
        return this.p0.getX() > this.p1.getX();
    }

    public boolean negativeNorthing() {
        return this.p1.getY() > this.p0.getY();
    }

    public String toString() {
        String s = "p0=(" + Geometry.f4.format(this.p0.getX()) + "," + Geometry.f4.format(this.p0.getY()) + ") " + this.width + "x" + this.height;
        return s;
    }
}

