/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.osm;

import gatcomsumo.osm.Geometry;
import gatcomsumo.osm.GeometrySegment;
import java.awt.geom.Point2D;

class GeometryLine {
    public double m;
    public double c;

    public GeometryLine(double m, double c) {
        this.m = m;
        this.c = c;
    }

    public GeometryLine(Point2D p1, Point2D p2) {
        this(new GeometrySegment(p1, p2));
    }

    public GeometryLine(GeometrySegment seg) {
        if (seg.isVertical()) {
            this.m = 999999.0;
            this.c = seg.p1.getX();
        } else {
            this.m = (seg.p2.getY() - seg.p1.getY()) / (seg.p2.getX() - seg.p1.getX());
            this.c = seg.p1.getY() - this.m * seg.p1.getX();
        }
    }

    public boolean isVertical() {
        return this.m == 999999.0;
    }

    public boolean isHorizontal() {
        return this.m < 1.0E-5;
    }

    public Point2D intersection(GeometryLine r2) {
        return GeometryLine.intersection(this, r2);
    }

    public static Point2D intersection(GeometryLine r1, GeometryLine r2) {
        double y;
        double x;
        if (r1.m == 999999.0 && r2.m == 999999.0) {
            return null;
        }
        if (r1.m == 999999.0) {
            x = r1.c;
            y = r2.m * x + r2.c;
        } else if (r2.m == 999999.0) {
            x = r2.c;
            y = r1.m * x + r1.c;
        } else {
            if (Math.abs(r1.m - r2.m) < 1.0E-5) {
                return null;
            }
            x = (r1.c - r2.c) / (r2.m - r1.m);
            y = r1.m * x + r1.c;
        }
        Point2D.Double p = new Point2D.Double(x, y);
        return p;
    }

    public String toString() {
        String s = "y = " + Geometry.f2.format(this.m) + "x + " + Geometry.f2.format(this.c);
        return s;
    }
}

