/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.frontend;

import gatcomsumo.backend.Edge;
import gatcomsumo.backend.Node;
import gatcomsumo.backend.SUMO;
import gatcomsumo.frontend.DlgConvCoord;
import gatcomsumo.frontend.MyFrame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import util.gps.GeodeticCoordinates;
import util.gps.UTMCoordinates;

class StatusBar
extends JPanel
implements ActionListener,
ItemListener {
    private static final DecimalFormat F6DEC = new DecimalFormat("###0.000000");
    private static final String[] COORD_SYSTEMS = new String[]{"UTM", "Geodetic", "SUMO", "OMNeT++"};
    public JComboBox cbCoord;
    public JTextField txtID;
    public JTextField txtCoord;
    public JButton pbConvCoord;
    private MyFrame f;
    private SUMO sumo;
    private Point2D.Double pUTM;
    private Point2D.Double pGeo;
    private Point2D.Double pSUMO;
    private Point2D.Double pOMNET;

    public StatusBar(MyFrame f, SUMO sumo) {
        this.f = f;
        this.sumo = sumo;
        TitledBorder b = new TitledBorder(" Selected object(s) / Coordinates ");
        this.setBorder(b);
        this.txtID = new JTextField("Select object ...");
        this.txtID.setEditable(false);
        this.cbCoord = new JComboBox<String>(COORD_SYSTEMS);
        this.cbCoord.setSelectedIndex(1);
        this.cbCoord.addItemListener(this);
        this.txtCoord = new JTextField("", 80);
        this.txtCoord.setEditable(false);
        this.pbConvCoord = new JButton("Convert ...");
        this.pbConvCoord.setToolTipText("Coordinates conversion tool");
        this.pbConvCoord.addActionListener(this);
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(1, 2));
        panel.add(this.pbConvCoord);
        panel.add(this.cbCoord);
        this.setLayout(new GridLayout(1, 3));
        this.add(this.txtID);
        this.add(panel);
        this.add(this.txtCoord);
        this.pUTM = new Point2D.Double();
        this.pGeo = new Point2D.Double();
        this.pSUMO = new Point2D.Double();
        this.pOMNET = new Point2D.Double();
    }

    public Point2D.Double updateCoord(Point2D.Double pSUMO) {
        String coord;
        this.pSUMO = pSUMO;
        UTMCoordinates utm = this.sumo.network.sumo2utm(pSUMO, this.pUTM);
        GeodeticCoordinates geo = this.sumo.network.sumo2lonlat(pSUMO, this.pGeo);
        this.sumo.network.sumo2omnet(pSUMO, this.pOMNET);
        int index = this.cbCoord.getSelectedIndex();
        switch (index) {
            case 0: {
                coord = utm.toString();
                break;
            }
            case 1: {
                coord = geo.toString();
                break;
            }
            case 2: {
                coord = "x=" + F6DEC.format(pSUMO.x) + "  y=" + F6DEC.format(pSUMO.y);
                break;
            }
            case 3: {
                coord = "x=" + F6DEC.format(this.pOMNET.x) + "  y=" + F6DEC.format(this.pOMNET.y);
                break;
            }
            default: {
                coord = "";
            }
        }
        this.txtCoord.setText(coord);
        return pSUMO;
    }

    public void updateObjects(Node node, Edge edge) {
        String id = "";
        if (node != null) {
            id = "Node: " + node.toString();
        }
        if (edge != null) {
            if (node != null) {
                id = id + " / ";
            }
            id = id + "Edge: " + edge.toString();
        }
        this.txtID.setText(id);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.updateCoord(this.pSUMO);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.pbConvCoord) {
            DlgConvCoord dlg = new DlgConvCoord(this.f, this.sumo);
            dlg.setVisible(true);
        }
    }
}

