/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.frontend;

import java.awt.FlowLayout;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class Panel_XY
extends JPanel {
    private static final DecimalFormat F6DEC = new DecimalFormat("###0.000000");
    private JLabel lblX;
    private JLabel lblY;
    public JTextField txtX;
    public JTextField txtY;

    public Panel_XY(String title, boolean enabled) {
        if (title != null && !title.isEmpty()) {
            TitledBorder b = new TitledBorder(title);
            this.setBorder(b);
        }
        this.setLayout(new FlowLayout(0));
        this.lblX = new JLabel("X:");
        this.txtX = new JTextField("", 15);
        this.txtX.setToolTipText("X coordinate");
        this.txtX.setHorizontalAlignment(4);
        if (!enabled) {
            this.txtX.setEditable(false);
        }
        this.lblY = new JLabel("Y:");
        this.txtY = new JTextField("", 15);
        this.txtY.setToolTipText("Y coordinate");
        this.txtY.setHorizontalAlignment(4);
        if (!enabled) {
            this.txtY.setEditable(false);
        }
        this.add(this.lblX);
        this.add(this.txtX);
        this.add(this.lblY);
        this.add(this.txtY);
    }

    public void setValues(Point2D.Double pUTM) {
        this.txtX.setText(F6DEC.format(pUTM.getX()));
        this.txtY.setText(F6DEC.format(pUTM.getY()));
    }

    public Point2D.Double getValues() {
        double y;
        double x;
        String valueX = this.txtX.getText().trim();
        valueX = valueX.replace(',', '.');
        String valueY = this.txtY.getText().trim();
        valueY = valueY.replace(',', '.');
        try {
            x = Double.parseDouble(valueX);
            y = Double.parseDouble(valueY);
        }
        catch (NumberFormatException e) {
            return null;
        }
        Point2D.Double p = new Point2D.Double(x, y);
        return p;
    }
}

