/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.frontend;

import gatcomsumo.backend.Edge;
import gatcomsumo.backend.Node;
import gatcomsumo.backend.SUMO;
import gatcomsumo.frontend.DlgSelect;
import gatcomsumo.frontend.MyFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

class Panel_ViewList
extends JPanel
implements ActionListener {
    private MyFrame f;
    private SUMO sumo;
    private boolean nodes;
    private JLabel lblID;
    private JTextField txtID;
    private JButton pbID;
    private JButton pbView;
    private JTextArea txtItem;

    public Panel_ViewList(MyFrame f, SUMO sumo, String title) {
        this.f = f;
        this.sumo = sumo;
        this.nodes = title.equalsIgnoreCase("Nodes");
        TitledBorder b = new TitledBorder(title);
        this.setBorder(b);
        JPanel pNorte = new JPanel();
        this.lblID = new JLabel("ID:");
        this.txtID = new JTextField("", 20);
        this.pbID = new JButton("...");
        this.pbID.addActionListener(this);
        this.pbView = new JButton("View");
        this.pbView.addActionListener(this);
        pNorte.setLayout(new FlowLayout(0));
        pNorte.add(this.lblID);
        pNorte.add(this.txtID);
        pNorte.add(this.pbID);
        pNorte.add(this.pbView);
        this.txtItem = new JTextArea(10, 50);
        this.txtItem.setLineWrap(true);
        this.txtItem.setEditable(false);
        JScrollPane sp = new JScrollPane(this.txtItem);
        sp.setHorizontalScrollBarPolicy(30);
        sp.setVerticalScrollBarPolicy(20);
        this.setLayout(new BorderLayout());
        this.add((Component)pNorte, "North");
        this.add((Component)sp, "Center");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.pbID) {
            if (this.nodes) {
                DlgSelect dlg = this.f.pNetwork.dlgSelectNode;
                if (dlg == null) {
                    JOptionPane.showMessageDialog(this, "There is no nodes; the network should be loaded before.\n", "Error", 0);
                    return;
                }
                dlg.setTitle("Node");
                dlg.setVisible(true);
                Node node = (Node)dlg.getObject();
                if (node != null) {
                    this.txtID.setText(node.id);
                    this.txtItem.setText(node.getDescription());
                }
            } else {
                DlgSelect dlg = this.f.pNetwork.dlgSelectEdge;
                if (dlg == null) {
                    JOptionPane.showMessageDialog(this, "There is no edges; the network should be loaded before.\n", "Error", 0);
                    return;
                }
                dlg.setTitle("Edge");
                dlg.setVisible(true);
                Edge edge = (Edge)dlg.getObject();
                if (edge != null) {
                    this.txtID.setText(edge.id);
                    this.txtItem.setText(edge.getDescription());
                }
            }
        } else if (e.getSource() == this.pbView) {
            String id = this.txtID.getText().trim();
            if (this.nodes) {
                Node node = this.sumo.network.nodes.searchBinary(id);
                if (node != null) {
                    this.txtItem.setText(node.getDescription());
                } else {
                    this.txtItem.setText("");
                }
            } else {
                Edge edge = this.sumo.network.edges.searchBinary(id);
                if (edge != null) {
                    this.txtItem.setText(edge.getDescription());
                } else {
                    this.txtItem.setText("");
                }
            }
        }
    }
}

