/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.frontend;

import gatcomsumo.backend.SUMO;
import gatcomsumo.backend.Vehicle;
import gatcomsumo.backend.VehicleType;
import gatcomsumo.frontend.DlgVehicle;
import gatcomsumo.frontend.MyFrame;
import gatcomsumo.frontend.Panel_GenericTable;

public class Panel_Vehicles
extends Panel_GenericTable
implements Panel_GenericTable.MyListener {
    public Panel_Vehicles(MyFrame f, String title, SUMO sumo) {
        super(f, title, sumo, Vehicle.HEADERS, Vehicle.NONEDITABLECOLS, true, true, true, false, false);
        this.addListener(this);
    }

    @Override
    public void addItem(Panel_GenericTable.MyEvent e) {
        VehicleType type;
        int nrows;
        int row = nrows = this.table.getNumRows();
        int nVehicles = this.sumo.trafficDemand.vehicles.list.size();
        int nVehicleTypes = this.sumo.trafficDemand.vehicletypes.list.size();
        if (nVehicles == 0) {
            if (nVehicleTypes == 0) {
                type = new VehicleType(row + 1 + "");
                this.sumo.trafficDemand.vehicletypes.list.add(type);
            }
            type = this.sumo.trafficDemand.vehicletypes.list.get(0);
        } else {
            Vehicle vehicle = this.sumo.trafficDemand.vehicles.list.get(nVehicles - 1);
            type = vehicle.type;
        }
        String prefix = this.sumo.trafficDemand.vehicles.getLastPrefix();
        int index = this.sumo.trafficDemand.vehicles.getLastIndex(prefix) + 1;
        String id = prefix + "-" + index;
        Vehicle vehicle = new Vehicle(id, type);
        this.sumo.trafficDemand.vehicles.list.add(vehicle);
        Object[] data = vehicle.buildRowTable(row);
        this.table.appendRow(data, true);
        this.sumo.trafficDemand.setChanged(true);
    }

    @Override
    public void selectItem(Panel_GenericTable.MyEvent e, int index) {
    }

    @Override
    public void removeItemBefore(Panel_GenericTable.MyEvent e, int index) {
        Vehicle vehicle = this.sumo.trafficDemand.vehicles.list.get(index);
        if (vehicle.route != null) {
            vehicle.route.removeVehicle(vehicle);
        }
        this.sumo.trafficDemand.vehicles.list.remove(index);
        this.sumo.trafficDemand.setChanged(true);
    }

    @Override
    public void removeItemAfter(Panel_GenericTable.MyEvent e, int index) {
        this.f.pTrafficDemands.pRoutes.update();
    }

    @Override
    public void editItem(Panel_GenericTable.MyEvent e, int index) {
        Vehicle vehicle = this.sumo.trafficDemand.vehicles.list.get(index);
        DlgVehicle dlg = new DlgVehicle(this.f, this.sumo, this.title, vehicle);
        dlg.setVisible(true);
        if (!dlg.isCanceled()) {
            Object[] data = vehicle.buildRowTable(index);
            this.updateItem(index, data);
            if (dlg.routesModified()) {
                this.f.pTrafficDemands.pRoutes.update();
            }
            this.sumo.trafficDemand.setChanged(true);
        }
    }

    public void update() {
        int row = 0;
        this.table.removeAllRows();
        for (Vehicle item : this.sumo.trafficDemand.vehicles.list) {
            Object[] data = item.buildRowTable(row);
            this.table.appendRow(data, true);
            ++row;
        }
        if (this.table.getNumRows() > 0) {
            this.table.selectRow(0);
        }
    }

    @Override
    public boolean load(Panel_GenericTable.MyEvent e) {
        return true;
    }

    @Override
    public boolean save(Panel_GenericTable.MyEvent e) {
        return true;
    }
}

