/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.frontend;

import java.awt.FlowLayout;
import java.awt.event.KeyListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import util.gps.UTMCoordinates;

public class Panel_UTM
extends JPanel {
    public static final int UTMZONENUMBER = 30;
    public static final char UTMZONELETTER = 'S';
    JLabel lblX;
    JLabel lblY;
    JLabel lblZone;
    JTextField txtX;
    JTextField txtY;
    JComboBox cbZoneNumber;
    JComboBox cbZoneLetter;

    public Panel_UTM(String title, boolean enabled, boolean enabledZone, KeyListener listener) {
        int i;
        if (title != null && !title.isEmpty()) {
            TitledBorder b = new TitledBorder(title);
            this.setBorder(b);
        }
        this.setLayout(new FlowLayout(0));
        this.lblX = new JLabel("UTM Easting (x): ");
        this.txtX = new JTextField("", 10);
        this.txtX.setToolTipText("UTM x coordinate (m)");
        this.txtX.setHorizontalAlignment(4);
        if (!enabled) {
            this.txtX.setEditable(false);
        } else if (listener != null) {
            this.txtX.addKeyListener(listener);
        }
        this.lblY = new JLabel("UTM Northing (y): ");
        this.txtY = new JTextField("", 10);
        this.txtY.setToolTipText("UTM y coordinate (m)");
        this.txtY.setHorizontalAlignment(4);
        if (!enabled) {
            this.txtY.setEditable(false);
        } else if (listener != null) {
            this.txtY.addKeyListener(listener);
        }
        this.lblZone = new JLabel("UTM Zone:");
        this.cbZoneNumber = new JComboBox();
        for (i = 0; i < UTMCoordinates.ZONENUMBER.length; ++i) {
            this.cbZoneNumber.addItem("" + UTMCoordinates.ZONENUMBER[i]);
        }
        this.cbZoneNumber.setSelectedItem(30);
        if (!enabledZone) {
            this.cbZoneNumber.setEnabled(false);
        }
        this.cbZoneLetter = new JComboBox();
        for (i = 0; i < UTMCoordinates.ZONELETTER.length; ++i) {
            this.cbZoneLetter.addItem("" + UTMCoordinates.ZONELETTER[i]);
        }
        this.cbZoneLetter.setSelectedItem(Character.valueOf('S'));
        if (!enabledZone) {
            this.cbZoneLetter.setEnabled(false);
        }
        this.add(this.lblX);
        this.add(this.txtX);
        this.add(this.lblY);
        this.add(this.txtY);
        this.add(this.lblZone);
        this.add(this.cbZoneNumber);
        this.add(this.cbZoneLetter);
    }

    public void setValues(UTMCoordinates utm) {
        if (utm == null) {
            return;
        }
        this.txtX.setText(utm.getX());
        this.txtY.setText(utm.getY());
        this.cbZoneNumber.setSelectedItem("" + utm.getZoneNumber());
        this.cbZoneLetter.setSelectedItem("" + utm.getZoneLetter());
    }

    public UTMCoordinates getValues() {
        double y;
        double x;
        String value = this.txtX.getText().trim();
        value = value.replace(',', '.');
        try {
            x = Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
        value = this.txtY.getText().trim();
        value = value.replace(',', '.');
        try {
            y = Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
        int zoneNumber = this.cbZoneNumber.getSelectedIndex() + 1;
        String letter = (String)this.cbZoneLetter.getSelectedItem();
        char zoneLetter = letter.charAt(0);
        UTMCoordinates utm = new UTMCoordinates(zoneNumber, zoneLetter, x, y);
        return utm;
    }
}

