/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.frontend;

import gatcomsumo.backend.Route;
import gatcomsumo.backend.SUMO;
import gatcomsumo.backend.VehicleType;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Rectangle2D;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import util.Util;

public class Panel_TripsFilter
extends JPanel
implements ItemListener {
    private static final String[] FILTER_DIST_OP = new String[]{"<=", ">="};
    private JLabel lblFilterBBOXMargin;
    public JCheckBox chFilterDist;
    public JCheckBox chFilterBBOX;
    public JCheckBox chFilterVehicleType;
    public JComboBox cbFilterDist;
    public JComboBox cbVehicleType;
    public JTextField txtFilterDist;
    public JTextField txtFilterBBOXMargin;
    public JButton pbFilterApply;

    public Panel_TripsFilter(JFrame f, SUMO sumo, ActionListener listenerButton, Panel_TripsFilter pFilter) {
        this(f, sumo, listenerButton);
        this.chFilterDist.setSelected(pFilter.filterDist());
        this.cbFilterDist.setSelectedIndex(pFilter.cbFilterDist.getSelectedIndex());
        this.txtFilterDist.setText(pFilter.txtFilterDist.getText());
        this.chFilterBBOX.setSelected(pFilter.filterBBOX());
        this.txtFilterBBOXMargin.setText(pFilter.txtFilterBBOXMargin.getText());
        this.chFilterVehicleType.setSelected(pFilter.filterVehicleType());
        this.cbVehicleType.setSelectedIndex(pFilter.cbVehicleType.getSelectedIndex());
    }

    public Panel_TripsFilter(JFrame f, SUMO sumo, ActionListener listenerButton) {
        TitledBorder b = new TitledBorder(" Filter ");
        this.setBorder(b);
        JPanel pFilter1 = new JPanel();
        this.chFilterDist = new JCheckBox("Distance (m): ", false);
        this.chFilterDist.setToolTipText("Filter routes that match this condition");
        this.chFilterDist.addItemListener(this);
        this.cbFilterDist = new JComboBox<String>(FILTER_DIST_OP);
        this.txtFilterDist = new JTextField("2000", 5);
        pFilter1.setLayout(new FlowLayout(0));
        pFilter1.add(this.chFilterDist);
        pFilter1.add(this.cbFilterDist);
        pFilter1.add(this.txtFilterDist);
        if (listenerButton != null) {
            this.pbFilterApply = new JButton("Apply");
            this.pbFilterApply.addActionListener(listenerButton);
            pFilter1.add(this.pbFilterApply);
        }
        JPanel pFilter2 = new JPanel();
        this.chFilterBBOX = new JCheckBox("Ignore routes outside the bounding box", true);
        this.chFilterBBOX.setToolTipText("Ignore routes outside the specified area when downloading the map, not the included in the network file (.net.xml)");
        this.chFilterBBOX.addItemListener(this);
        this.lblFilterBBOXMargin = new JLabel("/ Margin (m):");
        this.txtFilterBBOXMargin = new JTextField("0", 3);
        this.txtFilterBBOXMargin.setToolTipText("Extra margin around the bounding box");
        pFilter2.setLayout(new FlowLayout(0));
        pFilter2.add(this.chFilterBBOX);
        pFilter2.add(this.lblFilterBBOXMargin);
        pFilter2.add(this.txtFilterBBOXMargin);
        JPanel pFilter3 = new JPanel();
        this.chFilterVehicleType = new JCheckBox("Vehicle type", false);
        this.chFilterVehicleType.setToolTipText("Check that all the edges of each route permit the selected vehicle type (allow/disallow parameters)");
        this.chFilterVehicleType.addItemListener(this);
        this.cbVehicleType = new JComboBox<Object>(sumo.trafficDemand.vehicletypes.list.toArray());
        VehicleType defaultType = sumo.trafficDemand.vehicletypes.search("passenger");
        this.cbVehicleType.setSelectedItem(defaultType);
        pFilter3.setLayout(new FlowLayout(0));
        pFilter3.add(this.chFilterVehicleType);
        pFilter3.add(this.cbVehicleType);
        this.setLayout(new GridLayout(3, 1, 0, 0));
        this.add(pFilter1);
        this.add(pFilter2);
        this.add(pFilter3);
        this.enableComponents();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.chFilterDist) {
            this.enableComponents();
        } else if (e.getSource() == this.chFilterBBOX) {
            this.enableComponents();
        } else if (e.getSource() == this.chFilterVehicleType) {
            this.enableComponents();
        }
    }

    private void enableComponents() {
        boolean enable = this.chFilterDist.isSelected();
        this.cbFilterDist.setEnabled(enable);
        this.txtFilterDist.setEnabled(enable);
        enable = this.chFilterBBOX.isSelected();
        this.txtFilterBBOXMargin.setEnabled(enable);
        enable = this.chFilterVehicleType.isSelected();
        this.cbVehicleType.setEnabled(enable);
    }

    public boolean filterDist() {
        boolean filter = this.chFilterDist.isSelected();
        return filter;
    }

    public boolean filterDistLT() {
        boolean filter = this.chFilterDist.isSelected() && this.cbFilterDist.getSelectedIndex() == 0;
        return filter;
    }

    public boolean filterDistGT() {
        boolean filter = this.chFilterDist.isSelected() && this.cbFilterDist.getSelectedIndex() == 1;
        return filter;
    }

    public boolean filterBBOX() {
        boolean filter = this.chFilterBBOX.isSelected();
        return filter;
    }

    public boolean filterVehicleType() {
        boolean filter = this.chFilterVehicleType.isSelected();
        return filter;
    }

    public double getDist() {
        double dist = Util.parseDouble(this.txtFilterDist.getText());
        return dist;
    }

    public double getMargin() {
        double margin = Util.parseDouble(this.txtFilterBBOXMargin.getText());
        return margin;
    }

    public VehicleType getVehicleType() {
        VehicleType type = (VehicleType)this.cbVehicleType.getSelectedItem();
        return type;
    }

    public boolean checkRoute(Route route, Rectangle2D.Double bbox_margin) {
        boolean lt = this.filterDistLT();
        boolean gt = this.filterDistGT();
        boolean fbbox = this.filterBBOX();
        boolean fvType = this.filterVehicleType();
        double dist = this.getDist();
        VehicleType vehicleType = this.getVehicleType();
        if (!(lt || gt || fbbox || fvType)) {
            return true;
        }
        if (lt && !(route.length() <= dist)) {
            return false;
        }
        if (gt && !(route.length() >= dist)) {
            return false;
        }
        if (fbbox && !route.insideBBOX(bbox_margin)) {
            return false;
        }
        return !fvType || route.allowVehicleType(vehicleType);
    }
}

