/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.frontend;

import gatcomsumo.backend.Edge;
import gatcomsumo.backend.Route;
import gatcomsumo.backend.SUMO;
import gatcomsumo.backend.TrafficDemand;
import gatcomsumo.backend.Trip;
import gatcomsumo.backend.VehicleType;
import gatcomsumo.frontend.DlgSelect;
import gatcomsumo.frontend.DlgTrips;
import gatcomsumo.frontend.DlgTripsVehicles;
import gatcomsumo.frontend.MyFrame;
import gatcomsumo.frontend.Panel_TripsFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import util.Colors;
import util.Util;

public class Panel_Trips
extends JPanel
implements ActionListener,
ItemListener {
    private static final String FILENAME_TRIPS = "mytrip.xml";
    private static final String FILENAME_ROUTE = "myroute.xml";
    private MyFrame f;
    private SUMO sumo;
    private TrafficDemand trafficDemand;
    private Route route;
    private ArrayList<Route> routes;
    JLabel lblNumTrips;
    JLabel lblID;
    JLabel lblID_n;
    JLabel lblEdgeFrom;
    JLabel lblEdgeTo;
    JLabel lblEdgeInterm;
    JLabel lblRoute;
    JLabel lblColor;
    JTextField txtNumTrips;
    JTextField txtID;
    JTextField txtID_n;
    JTextField txtEdgeFrom;
    JTextField txtEdgeTo;
    JTextField txtEdgeInterm;
    JComboBox cbColor;
    JCheckBox chFromRandom;
    JCheckBox chToRandom;
    JButton pbEdgeFrom;
    JButton pbEdgeTo;
    JButton pbEdgeInterm;
    JButton pbGenerateRoutes;
    JButton pbAddVehicles;
    Panel_TripsFilter pFilter;

    public Panel_Trips(MyFrame f, String title, SUMO sumo) {
        this.f = f;
        this.sumo = sumo;
        TitledBorder b = new TitledBorder("Trips");
        this.setBorder(b);
        JPanel pCentro = new JPanel();
        JPanel pCentroCentro = new JPanel();
        JPanel pCentro1 = new JPanel();
        this.lblNumTrips = new JLabel("Number of trips to generate:");
        this.txtNumTrips = new JTextField("10", 3);
        this.lblID = new JLabel("ID:");
        this.txtID = new JTextField("trip", 6);
        this.lblID_n = new JLabel("-");
        this.txtID_n = new JTextField("0", 3);
        this.lblColor = new JLabel("Color:");
        this.cbColor = new JComboBox<Colors>(Colors.values());
        this.cbColor.setSelectedItem((Object)Colors.MAGENTA);
        pCentro1.setLayout(new FlowLayout(0));
        pCentro1.add(this.lblNumTrips);
        pCentro1.add(this.txtNumTrips);
        pCentro1.add(this.lblID);
        pCentro1.add(this.txtID);
        pCentro1.add(this.lblID_n);
        pCentro1.add(this.txtID_n);
        pCentro1.add(this.lblColor);
        pCentro1.add(this.cbColor);
        JPanel pCentro2 = new JPanel();
        JPanel pCentro2a = new JPanel();
        this.lblEdgeFrom = new JLabel("From Edge:");
        this.txtEdgeFrom = new JTextField("", 8);
        this.pbEdgeFrom = new JButton("...");
        this.pbEdgeFrom.addActionListener(this);
        this.chFromRandom = new JCheckBox("Random", true);
        this.chFromRandom.addItemListener(this);
        pCentro2a.setLayout(new FlowLayout(0));
        pCentro2a.add(this.lblEdgeFrom);
        pCentro2a.add(this.txtEdgeFrom);
        pCentro2a.add(this.pbEdgeFrom);
        pCentro2a.add(this.chFromRandom);
        JPanel pCentro2b = new JPanel();
        this.lblEdgeTo = new JLabel("To  Edge:");
        this.txtEdgeTo = new JTextField("", 8);
        this.pbEdgeTo = new JButton("...");
        this.pbEdgeTo.addActionListener(this);
        this.chToRandom = new JCheckBox("Random", true);
        this.chToRandom.addItemListener(this);
        pCentro2b.setLayout(new FlowLayout(0));
        pCentro2b.add(this.lblEdgeTo);
        pCentro2b.add(this.txtEdgeTo);
        pCentro2b.add(this.pbEdgeTo);
        pCentro2b.add(this.chToRandom);
        pCentro2.setLayout(new GridLayout(1, 2));
        pCentro2.add(pCentro2a);
        pCentro2.add(pCentro2b);
        JPanel pCentro3 = new JPanel();
        this.lblEdgeInterm = new JLabel("Intermediate Edges:");
        this.txtEdgeInterm = new JTextField("", 40);
        this.pbEdgeInterm = new JButton("...");
        this.pbEdgeInterm.addActionListener(this);
        pCentro3.setLayout(new BorderLayout());
        pCentro3.add((Component)this.lblEdgeInterm, "West");
        pCentro3.add((Component)this.txtEdgeInterm, "Center");
        pCentro3.add((Component)this.pbEdgeInterm, "East");
        pCentroCentro.setLayout(new FlowLayout(0));
        pCentroCentro.add(pCentro1);
        pCentroCentro.add(pCentro2);
        pCentroCentro.add(pCentro3);
        this.pFilter = new Panel_TripsFilter(f, sumo, null);
        pCentro.setLayout(new BorderLayout());
        pCentro.add((Component)pCentroCentro, "Center");
        pCentro.add((Component)this.pFilter, "South");
        JPanel pBotones = new JPanel();
        this.pbGenerateRoutes = new JButton("Generate trips");
        this.pbGenerateRoutes.setToolTipText("Generate one or more trip files and transform them to route files with the 'duarouter' tool");
        this.pbGenerateRoutes.addActionListener(this);
        this.pbAddVehicles = new JButton("Add vehicles ...");
        this.pbAddVehicles.setToolTipText("Create vehicles or flows and assign a route to each one (routes previously added!)");
        this.pbAddVehicles.addActionListener(this);
        pBotones.setLayout(new FlowLayout());
        pBotones.add(this.pbGenerateRoutes);
        pBotones.add(this.pbAddVehicles);
        this.setLayout(new BorderLayout());
        this.add((Component)pCentro, "Center");
        this.add((Component)pBotones, "South");
        this.enableComponents();
        this.trafficDemand = new TrafficDemand(sumo);
        this.route = null;
        this.routes = new ArrayList();
    }

    public void update() {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.pbEdgeFrom) {
            DlgSelect dlg = this.f.pNetwork.dlgSelectEdge;
            dlg.setTitle("Start Edge");
            dlg.setVisible(true);
            Edge edge = (Edge)dlg.getObject();
            if (edge != null) {
                this.txtEdgeFrom.setText(edge.id);
            }
        } else if (e.getSource() == this.pbEdgeTo) {
            DlgSelect dlg = this.f.pNetwork.dlgSelectEdge;
            dlg.setTitle("Final Edge");
            dlg.setVisible(true);
            Edge edge = (Edge)dlg.getObject();
            if (edge != null) {
                this.txtEdgeTo.setText(edge.id);
            }
        } else if (e.getSource() == this.pbEdgeInterm) {
            DlgSelect dlg = this.f.pNetwork.dlgSelectEdge;
            dlg.setTitle("Intermediate Edge");
            dlg.setVisible(true);
            Edge edge = (Edge)dlg.getObject();
            if (edge != null) {
                String intermEdges = this.txtEdgeInterm.getText().trim() + " " + edge.id;
                this.txtEdgeInterm.setText(intermEdges);
            }
        } else if (e.getSource() == this.pbGenerateRoutes) {
            int n = Util.parseInt(this.txtNumTrips.getText().trim());
            if (!this.sumo.network.loaded()) {
                JOptionPane.showMessageDialog(this.f, "The network has not been loaded", "Trips", 0);
                return;
            }
            Util.setCursorEsperas(this);
            int nOk = this.generateRoutes(n);
            Util.setCursorNormal(this);
            if (nOk == 0 || this.routes.size() == 0) {
                JOptionPane.showMessageDialog(this.f, "None route(s) have been created!", "Trips", 0);
                return;
            }
            Object[] options = new Object[]{"Cancel", "Select", "Add all"};
            int reply = JOptionPane.showOptionDialog(this.f, "Route(s) created succesfully! (" + nOk + "/" + n + ")\nDo you want to add all of them to the routes table, select routes, or cancel process?", "Trips", 0, 3, null, options, options[2]);
            switch (reply) {
                case 2: {
                    for (Route route : this.routes) {
                        this.sumo.trafficDemand.routes.list.add(route);
                    }
                    JOptionPane.showMessageDialog(this.f, "Route(s) added succesfully! (" + this.routes.size() + ")\nNow you can create vehicles automatically.", "Trips", 1);
                    break;
                }
                case 1: {
                    DlgTrips dlgTrips = new DlgTrips(this.f, this.sumo, "Select routes", this.routes);
                    dlgTrips.setVisible(true);
                    boolean canceled = dlgTrips.canceled;
                    dlgTrips.dispose();
                    if (!canceled) break;
                    return;
                }
                case 0: {
                    return;
                }
            }
            this.f.pTrafficDemands.pRoutes.update();
            this.sumo.trafficDemand.setChanged(true);
        } else if (e.getSource() == this.pbAddVehicles) {
            if (this.sumo.trafficDemand.routes.list.size() > 0) {
                DlgTripsVehicles dlgTripsVehicles = new DlgTripsVehicles(this.f, this.sumo, "Generate vehicles/flows");
                dlgTripsVehicles.setVisible(true);
                boolean canceled = dlgTripsVehicles.canceled;
                dlgTripsVehicles.dispose();
                if (!canceled) {
                    this.f.pTrafficDemands.pRoutes.update();
                    this.sumo.trafficDemand.setChanged(true);
                }
            } else {
                JOptionPane.showMessageDialog(this.f, "There are any route previously added", "Trips", 0);
            }
        }
    }

    public String buildCommand_duarouter() {
        String cmd = "";
        cmd = cmd + "duarouter --trip-files mytrip.xml";
        cmd = cmd + " --net-file " + this.f.pNetwork.getNetworkFilename();
        cmd = cmd + " --output-file myroute.xml";
        return cmd;
    }

    public Route generateRoute(String id, Edge edgeFrom, Edge edgeTo, String intermEdges, double depart, Colors color) {
        this.trafficDemand.init();
        this.trafficDemand.trips.init();
        Trip trip = new Trip(id, edgeFrom, edgeTo, depart, color);
        this.trafficDemand.trips.list.add(trip);
        if (!intermEdges.isEmpty()) {
            String[] ids = intermEdges.split("\\s");
            for (int i = 0; i < ids.length; ++i) {
                Edge edgeInterm;
                if (ids[i].trim().isEmpty() || (edgeInterm = this.sumo.network.edges.searchBinary(ids[i])) == null) continue;
                trip.addIntermediateEdge(edgeInterm);
            }
        }
        this.trafficDemand.trips.saveXML(FILENAME_TRIPS);
        String command = this.buildCommand_duarouter();
        boolean ok = this.f.pNetwork.execCommandSUMO(command, "Creating route to 'myroute.xml' file ...", true);
        if (!ok) {
            return null;
        }
        ok = this.trafficDemand.loadXML(FILENAME_ROUTE);
        String msg = this.trafficDemand.getLoadErrorMessage();
        if (!ok) {
            JOptionPane.showMessageDialog(this.f, "Error loading routes file:\n" + msg, "Trips", 0);
            return null;
        }
        if (this.trafficDemand.routes.list.isEmpty()) {
            JOptionPane.showMessageDialog(this.f, "Routes file is empty", "Trips", 0);
            return null;
        }
        this.route = this.trafficDemand.routes.list.get(0);
        this.route.vehicles.clear();
        this.route.flows.clear();
        return this.route;
    }

    private int generateRoutes(int n) {
        String idEdge;
        Edge edgeFrom = null;
        Edge edgeTo = null;
        double depart = 0.0;
        VehicleType vehicleType = null;
        String routeIDPrefix = this.txtID.getText().trim();
        int routeIDBaseIndex = Util.parseInt(this.txtID_n.getText());
        Colors color = (Colors)((Object)this.cbColor.getSelectedItem());
        boolean randomFrom = this.chFromRandom.isSelected();
        boolean randomTo = this.chToRandom.isSelected();
        if (!randomFrom && (edgeFrom = this.sumo.network.edges.searchBinary(idEdge = this.txtEdgeFrom.getText().trim())) == null) {
            JOptionPane.showMessageDialog(this.f, "Start edge does not exist in the current network.", "Trips", 0);
            return 0;
        }
        if (!randomTo && (edgeTo = this.sumo.network.edges.searchBinary(idEdge = this.txtEdgeTo.getText().trim())) == null) {
            JOptionPane.showMessageDialog(this.f, "Final edge does not exist in the current network.", "Trips", 0);
            return 0;
        }
        String intermEdges = this.txtEdgeInterm.getText().trim();
        if (this.pFilter.filterVehicleType()) {
            vehicleType = this.pFilter.getVehicleType();
            if (!randomFrom && !edgeFrom.allowVehicleType(vehicleType.id)) {
                JOptionPane.showMessageDialog(this.f, "Start edge '" + edgeFrom + "' does not allow the vehicle type: " + vehicleType.toString(), "Trips", 0);
                return 0;
            }
            if (!randomTo && !edgeTo.allowVehicleType(vehicleType.id)) {
                JOptionPane.showMessageDialog(this.f, "Final edge '" + edgeTo + "' does not allow the vehicle type: " + vehicleType.toString(), "Trips", 0);
                return 0;
            }
        }
        Rectangle2D.Double bbox_rect = this.sumo.network.buildBBOX_margin(this.sumo, this.pFilter.getMargin());
        this.routes.clear();
        int nOk = 0;
        int nTrys = 0;
        for (int r = 0; r < n && nTrys < n * 4; ++r) {
            ++nTrys;
            String id = routeIDPrefix + "-" + (routeIDBaseIndex + r);
            if (randomFrom && ((edgeFrom = this.sumo.network.edges.random()) == null || vehicleType != null && !edgeFrom.allowVehicleType(vehicleType.id))) {
                --r;
                continue;
            }
            if (randomTo && ((edgeTo = this.sumo.network.edges.random()) == null || vehicleType != null && !edgeTo.allowVehicleType(vehicleType.id))) {
                --r;
                continue;
            }
            boolean ok = false;
            this.route = this.generateRoute(id, edgeFrom, edgeTo, intermEdges, depart, color);
            if (this.route != null && (ok = this.pFilter.checkRoute(this.route, bbox_rect))) {
                ++nOk;
                this.routes.add(this.route);
            }
            if (ok) continue;
            --r;
        }
        return nOk;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.chFromRandom) {
            this.enableComponents();
        } else if (e.getSource() == this.chToRandom) {
            this.enableComponents();
        }
    }

    private void enableComponents() {
        boolean random = this.chFromRandom.isSelected();
        this.txtEdgeFrom.setEnabled(!random);
        this.pbEdgeFrom.setEnabled(!random);
        random = this.chToRandom.isSelected();
        this.txtEdgeTo.setEnabled(!random);
        this.pbEdgeTo.setEnabled(!random);
    }
}

