/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.frontend;

import gatcomsumo.backend.SUMO;
import gatcomsumo.frontend.MyFrame;
import gatcomsumo.frontend.Panel_Flows;
import gatcomsumo.frontend.Panel_Routes;
import gatcomsumo.frontend.Panel_Trips;
import gatcomsumo.frontend.Panel_VehicleTypes;
import gatcomsumo.frontend.Panel_Vehicles;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import util.Util;

public class Panel_TrafficDemand
extends JPanel
implements ActionListener {
    private MyFrame f;
    private SUMO sumo;
    public Panel_VehicleTypes pVehicleTypes;
    public Panel_Vehicles pVehicles;
    public Panel_Flows pFlows;
    public Panel_Routes pRoutes;
    public Panel_Trips pTrips;
    private JLabel lblRouteFile;
    private JLabel lblRouteExt;
    private JTextField txtRouteFile;
    private JButton bLoad;
    private JButton bSave;
    private JCheckBox chOrder;
    private JTabbedPane tabpane;

    public Panel_TrafficDemand(MyFrame f, SUMO sumo) {
        this.f = f;
        this.sumo = sumo;
        JPanel pNorte = new JPanel();
        TitledBorder b = new TitledBorder("Traffic Demand");
        pNorte.setBorder(b);
        JPanel pRouteFile1 = new JPanel();
        this.lblRouteFile = new JLabel("Routes file:");
        this.txtRouteFile = new JTextField("elche", 20);
        this.txtRouteFile.setToolTipText("Traffic demands file");
        this.lblRouteExt = new JLabel(".rou.xml");
        this.bLoad = new JButton("Load");
        this.bLoad.setToolTipText("Load traffic demand: vehicle types, vehicles, flows and routes");
        this.bLoad.addActionListener(this);
        this.bSave = new JButton("Save");
        this.bSave.setToolTipText("Save traffic demand: vehicle types, vehicles, flows and routes");
        this.bSave.addActionListener(this);
        JPanel p1aux = new JPanel();
        p1aux.setLayout(new FlowLayout());
        p1aux.add(this.lblRouteExt);
        p1aux.add(this.bLoad);
        p1aux.add(this.bSave);
        pRouteFile1.setLayout(new BorderLayout());
        pRouteFile1.add((Component)this.lblRouteFile, "West");
        pRouteFile1.add((Component)this.txtRouteFile, "Center");
        pRouteFile1.add((Component)p1aux, "East");
        JPanel pRouteFile2 = new JPanel();
        pRouteFile2.setLayout(new FlowLayout());
        this.chOrder = new JCheckBox("Save route file sorted by departure time of the vehicles/flows", true);
        this.chOrder.setToolTipText("Check it for avoid warnings like: \"Route file should be sorted by departure time, ignoring 'Car_1'!\"");
        pRouteFile2.add(this.chOrder);
        pNorte.setLayout(new GridLayout(2, 1));
        pNorte.add(pRouteFile1);
        pNorte.add(pRouteFile2);
        this.tabpane = new JTabbedPane();
        this.pVehicleTypes = new Panel_VehicleTypes(f, "Vehicle Types", sumo);
        this.tabpane.addTab("Vehicle Types", this.pVehicleTypes);
        this.pVehicles = new Panel_Vehicles(f, "Vehicles", sumo);
        this.tabpane.addTab("Vehicles", this.pVehicles);
        this.pFlows = new Panel_Flows(f, "Flows", sumo);
        this.tabpane.addTab("Flows", this.pFlows);
        this.pRoutes = new Panel_Routes(f, "Routes", sumo);
        this.tabpane.addTab("Routes", this.pRoutes);
        this.pTrips = new Panel_Trips(f, "Trips", sumo);
        this.tabpane.addTab("Trips", this.pTrips);
        this.setLayout(new BorderLayout());
        this.add((Component)pNorte, "North");
        this.add((Component)this.tabpane, "Center");
    }

    public String getRoutesFilename() {
        String s = this.txtRouteFile.getText().trim() + ".rou.xml";
        return s;
    }

    public void setNetworkName(String name) {
        this.txtRouteFile.setText(name);
    }

    public void update() {
        this.pVehicleTypes.update();
        this.pVehicles.update();
        this.pFlows.update();
        this.pRoutes.update();
        this.pTrips.update();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bLoad) {
            this.load();
        } else if (e.getSource() == this.bSave) {
            this.save();
        }
    }

    public boolean load() {
        String filename_xml = this.getRoutesFilename();
        boolean ok = this.sumo.trafficDemand.loadXML(filename_xml);
        String msg = this.sumo.trafficDemand.getLoadErrorMessage();
        if (ok) {
            if (!msg.isEmpty()) {
                JOptionPane.showMessageDialog(this.f, msg, "Load traffic demand", 2);
            }
            this.f.update();
        } else {
            JOptionPane.showMessageDialog(this.f, msg, "Load traffic demand", 0);
        }
        return ok;
    }

    public boolean save() {
        boolean ok;
        String filename_xml = this.getRoutesFilename();
        if (!Util.overwriteFile(this.f, filename_xml)) {
            return false;
        }
        if (this.chOrder.isSelected()) {
            this.sumo.trafficDemand.routes.sortByDepartTime();
        }
        if (ok = this.sumo.trafficDemand.saveXML(filename_xml)) {
            this.sumo.trafficDemand.setChanged(false);
        }
        return ok;
    }
}

