/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.frontend;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import util.Util;
import wireless.PHY_FSPL;
import wireless.Units_Distance;
import wireless.Units_Frequency;

public class Panel_Tools_TwoRay
extends JPanel
implements ActionListener {
    private static final DecimalFormat f7dec = new DecimalFormat("#,##0.0000000");
    private JLabel lblDistance;
    private JLabel lblFrequency;
    private JLabel lblGtx;
    private JLabel lblGrx;
    private JLabel lblFSPL;
    private JTextField txtDistance;
    private JTextField txtFrequency;
    private JTextField txtGtx;
    private JTextField txtGrx;
    private JTextField txtFSPL;
    private JComboBox cbDistanceUnits;
    private JComboBox cbFrequencyUnits;
    private JButton pbCalculate;

    public Panel_Tools_TwoRay(String title) {
        TitledBorder b = new TitledBorder(title);
        this.setBorder(b);
        this.lblDistance = new JLabel("Distance:");
        this.txtDistance = new JTextField("508", 10);
        this.txtDistance.setToolTipText("Distance between transmitter and receiver");
        this.cbDistanceUnits = new JComboBox();
        Units_Distance.fill(this.cbDistanceUnits);
        this.cbDistanceUnits.setSelectedIndex(0);
        this.lblFrequency = new JLabel("Frequency:");
        this.txtFrequency = new JTextField("5.890", 10);
        this.txtFrequency.setToolTipText("Frequency band of the carrier in MHz (e.g. 2.4 GHz is 2400 MHz)");
        this.cbFrequencyUnits = new JComboBox();
        Units_Frequency.fill(this.cbFrequencyUnits);
        this.cbFrequencyUnits.setSelectedIndex(3);
        this.lblGtx = new JLabel("Tx antenna gain (dBi):");
        this.txtGtx = new JTextField("0", 10);
        this.txtGtx.setToolTipText("Transmitter antenna gain");
        this.lblGrx = new JLabel("Rx antenna gain (dBi):");
        this.txtGrx = new JTextField("0", 10);
        this.txtGtx.setToolTipText("Receiver antenna gain");
        this.lblFSPL = new JLabel("Path loss (dB):");
        this.txtFSPL = new JTextField("", 10);
        this.txtFSPL.setToolTipText("The calculated path-loss with the free-space propagation model");
        this.txtFSPL.setEditable(false);
        JPanel pCentro = new JPanel();
        pCentro.setLayout(new GridLayout(5, 2));
        pCentro.add(this.lblDistance);
        pCentro.add(this.txtDistance);
        pCentro.add(this.lblFrequency);
        pCentro.add(this.txtFrequency);
        pCentro.add(this.lblGtx);
        pCentro.add(this.txtGtx);
        pCentro.add(this.lblGrx);
        pCentro.add(this.txtGrx);
        pCentro.add(this.lblFSPL);
        pCentro.add(this.txtFSPL);
        JPanel pEste = new JPanel();
        pEste.setLayout(new GridLayout(5, 1));
        pEste.add(this.cbDistanceUnits);
        pEste.add(this.cbFrequencyUnits);
        JPanel pSur = new JPanel();
        pSur.setLayout(new FlowLayout());
        this.pbCalculate = new JButton("Calculate");
        this.pbCalculate.addActionListener(this);
        pSur.add(this.pbCalculate);
        this.setLayout(new BorderLayout());
        this.add((Component)pCentro, "Center");
        this.add((Component)pSur, "South");
        this.add((Component)pEste, "East");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.pbCalculate) {
            double d = Util.parseDouble(this.txtDistance.getText());
            double f = Util.parseDouble(this.txtFrequency.getText());
            double gtx = Util.parseDouble(this.txtGtx.getText());
            double grx = Util.parseDouble(this.txtGrx.getText());
            Units_Distance d_units = (Units_Distance)((Object)this.cbDistanceUnits.getSelectedItem());
            Units_Frequency f_units = (Units_Frequency)((Object)this.cbFrequencyUnits.getSelectedItem());
            double pathloss_db = PHY_FSPL.pathLoss_dB(d, f, gtx, grx, d_units, f_units);
            this.txtFSPL.setText(f7dec.format(pathloss_db));
        }
    }
}

