/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.frontend;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import util.Conv;
import util.Util;
import wireless.PHY_FSPL;
import wireless.PHY_TwoRay;
import wireless.Units_Distance;
import wireless.Units_Frequency;

public class Panel_Tools_PathLoss
extends JPanel
implements ActionListener {
    private static final DecimalFormat f7dec = new DecimalFormat("#,##0.0000000");
    private JLabel lblDistance;
    private JLabel lblFrequency;
    private JLabel lblGtx;
    private JLabel lblGrx;
    private JLabel lblHtx;
    private JLabel lblHrx;
    private JLabel lblFSPL;
    private JTextField txtDistance;
    private JTextField txtFrequency;
    private JTextField txtGtx;
    private JTextField txtGrx;
    private JTextField txtHtx;
    private JTextField txtHrx;
    private JTextField txtFSPL;
    private JComboBox cbDistanceUnits;
    private JComboBox cbFrequencyUnits;
    private JButton pbCalculate;
    private JComboBox cbModel;

    public Panel_Tools_PathLoss(JComboBox cbModel) {
        this.cbModel = cbModel;
        TitledBorder b = new TitledBorder("Path loss calculator");
        this.setBorder(b);
        this.lblDistance = new JLabel("Distance:");
        this.txtDistance = new JTextField("508", 10);
        this.txtDistance.setToolTipText("Distance between transmitter and receiver");
        this.cbDistanceUnits = new JComboBox();
        Units_Distance.fill(this.cbDistanceUnits);
        this.cbDistanceUnits.setSelectedIndex(0);
        this.lblFrequency = new JLabel("Frequency:");
        this.txtFrequency = new JTextField("5.890", 10);
        this.txtFrequency.setToolTipText("Frequency band of the carrier in MHz (e.g. 2.4 GHz is 2400 MHz)");
        this.cbFrequencyUnits = new JComboBox();
        Units_Frequency.fill(this.cbFrequencyUnits);
        this.cbFrequencyUnits.setSelectedIndex(3);
        this.lblGtx = new JLabel("Tx antenna gain (dBi):");
        this.txtGtx = new JTextField("0", 10);
        this.txtGtx.setToolTipText("Transmitter antenna gain");
        this.lblGrx = new JLabel("Rx antenna gain (dBi):");
        this.txtGrx = new JTextField("0", 10);
        this.txtGtx.setToolTipText("Receiver antenna gain");
        this.lblFSPL = new JLabel("Path loss (dB):");
        this.lblHtx = new JLabel("Tx antenna height (m):");
        this.txtHtx = new JTextField("1", 10);
        this.txtHtx.setToolTipText("Transmitter antenna height (m); only for Two-ray ground reflection model");
        this.lblHrx = new JLabel("Rx antenna height (m):");
        this.txtHrx = new JTextField("1", 10);
        this.txtHrx.setToolTipText("Receiver antenna height (m); only for Two-ray ground reflection model");
        this.txtFSPL = new JTextField("", 10);
        this.txtFSPL.setToolTipText("The calculated path-loss with the free-space propagation model");
        this.txtFSPL.setEditable(false);
        JPanel pCentro = new JPanel();
        pCentro.setLayout(new GridLayout(7, 2));
        pCentro.add(this.lblDistance);
        pCentro.add(this.txtDistance);
        pCentro.add(this.lblFrequency);
        pCentro.add(this.txtFrequency);
        pCentro.add(this.lblGtx);
        pCentro.add(this.txtGtx);
        pCentro.add(this.lblGrx);
        pCentro.add(this.txtGrx);
        pCentro.add(this.lblHtx);
        pCentro.add(this.txtHtx);
        pCentro.add(this.lblHrx);
        pCentro.add(this.txtHrx);
        pCentro.add(this.lblFSPL);
        pCentro.add(this.txtFSPL);
        JPanel pEste = new JPanel();
        pEste.setLayout(new GridLayout(7, 1));
        pEste.add(this.cbDistanceUnits);
        pEste.add(this.cbFrequencyUnits);
        JPanel pSur = new JPanel();
        pSur.setLayout(new FlowLayout());
        this.pbCalculate = new JButton("Calculate");
        this.pbCalculate.addActionListener(this);
        pSur.add(this.pbCalculate);
        this.setLayout(new BorderLayout());
        this.add((Component)pCentro, "Center");
        this.add((Component)pSur, "South");
        this.add((Component)pEste, "East");
    }

    public void setModel() {
        boolean tworay = this.cbModel.getSelectedIndex() == 1;
        this.txtHtx.setEnabled(tworay);
        this.txtHrx.setEnabled(tworay);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean tworay;
        boolean bl = tworay = this.cbModel.getSelectedIndex() == 1;
        if (e.getSource() == this.pbCalculate) {
            double pathloss_db;
            double d = Util.parseDouble(this.txtDistance.getText());
            double f = Util.parseDouble(this.txtFrequency.getText());
            double gtx_dbi = Util.parseDouble(this.txtGtx.getText());
            double grx_dbi = Util.parseDouble(this.txtGrx.getText());
            double gtx = Conv.dBi_to_absolute(gtx_dbi);
            double grx = Conv.dBi_to_absolute(grx_dbi);
            Units_Distance d_units = (Units_Distance)((Object)this.cbDistanceUnits.getSelectedItem());
            Units_Frequency f_units = (Units_Frequency)((Object)this.cbFrequencyUnits.getSelectedItem());
            if (!tworay) {
                pathloss_db = PHY_FSPL.pathLoss_dB(d, f, gtx, grx, d_units, f_units);
            } else {
                double htx = Util.parseDouble(this.txtHtx.getText());
                double hrx = Util.parseDouble(this.txtHrx.getText());
                pathloss_db = PHY_TwoRay.pathLoss_dB(d, gtx, grx, htx, hrx, d_units);
            }
            this.txtFSPL.setText(f7dec.format(pathloss_db));
        }
    }
}

