/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.frontend;

import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.DecimalFormat;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import util.Conv;
import util.Util;

public class Panel_Tools_ConvdBmWatt
extends JPanel
implements KeyListener,
ItemListener {
    private static final double WATTS_1DBM = 0.001258925;
    private static final double DBM_1W = 30.0;
    private static final DecimalFormat f7dec = new DecimalFormat("#,##0.0000000");
    private static final String[] UNITS = new String[]{"dBm", "W", "mW"};
    private JTextField[] txtValue;
    private JComboBox[] cbUnits;

    public Panel_Tools_ConvdBmWatt() {
        int i;
        TitledBorder b = new TitledBorder("Converter: dBm-Watts");
        this.setBorder(b);
        this.setLayout(new GridLayout(2, 2));
        this.txtValue = new JTextField[2];
        this.cbUnits = new JComboBox[2];
        for (i = 0; i < 2; ++i) {
            this.txtValue[i] = new JTextField("", 10);
            this.txtValue[i].addKeyListener(this);
            if (i == 0) {
                this.txtValue[i].setText("20");
            } else {
                this.txtValue[i].setEnabled(false);
            }
            this.cbUnits[i] = new JComboBox<String>(UNITS);
            this.cbUnits[i].addItemListener(this);
        }
        for (i = 0; i < 2; ++i) {
            this.add(this.txtValue[i]);
        }
        for (i = 0; i < 2; ++i) {
            this.add(this.cbUnits[i]);
        }
        this.cbUnits[0].setSelectedIndex(0);
        this.cbUnits[1].setSelectedIndex(1);
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.calculate(0, 1);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.calculate(0, 1);
    }

    private void calculate(int src, int dst) {
        double valueDst;
        int unitsDst;
        double valueSrc = Util.parseDouble(this.txtValue[src].getText());
        int unitsSrc = this.cbUnits[src].getSelectedIndex();
        if (unitsSrc == (unitsDst = this.cbUnits[dst].getSelectedIndex())) {
            valueDst = valueSrc;
        } else if (unitsSrc == 0 && unitsDst == 1) {
            valueDst = Conv.dBm_to_watts(valueSrc);
        } else if (unitsSrc == 1 && unitsDst == 0) {
            valueDst = Conv.watts_to_dBm(valueSrc);
        } else if (unitsSrc == 0 && unitsDst == 2) {
            valueDst = Conv.dBm_to_watts(valueSrc) * 1000.0;
        } else if (unitsSrc == 2 && unitsDst == 0) {
            valueDst = Conv.watts_to_dBm(valueSrc / 1000.0);
        } else if (unitsSrc == 1 && unitsDst == 2) {
            valueDst = valueSrc * 1000.0;
        } else if (unitsSrc == 2 && unitsDst == 1) {
            valueDst = valueSrc / 1000.0;
        } else {
            return;
        }
        this.txtValue[dst].setText(f7dec.format(valueDst));
    }
}

