/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.frontend;

import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.DecimalFormat;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import util.Conv;
import util.Util;

public class Panel_Tools_ConvVelocity
extends JPanel
implements KeyListener,
ItemListener {
    private static final DecimalFormat f4dec = new DecimalFormat("#,##0.0000");
    private static final String[] UNITS = new String[]{"m/s", "Km/h"};
    private JTextField[] txtValue;
    private JComboBox[] cbUnits;

    public Panel_Tools_ConvVelocity() {
        int i;
        TitledBorder b = new TitledBorder("Converter: Velocity");
        this.setBorder(b);
        this.setLayout(new GridLayout(2, 2));
        this.txtValue = new JTextField[2];
        this.cbUnits = new JComboBox[2];
        for (i = 0; i < 2; ++i) {
            this.txtValue[i] = new JTextField("", 10);
            this.txtValue[i].addKeyListener(this);
            if (i == 0) {
                this.txtValue[i].setText("20");
            } else {
                this.txtValue[i].setEnabled(false);
            }
            this.cbUnits[i] = new JComboBox<String>(UNITS);
            this.cbUnits[i].addItemListener(this);
        }
        for (i = 0; i < 2; ++i) {
            this.add(this.txtValue[i]);
        }
        for (i = 0; i < 2; ++i) {
            this.add(this.cbUnits[i]);
        }
        this.cbUnits[0].setSelectedIndex(1);
        this.cbUnits[1].setSelectedIndex(0);
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.calculate(0, 1);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.calculate(0, 1);
    }

    private void calculate(int src, int dst) {
        double valueDst;
        int unitsDst;
        double valueSrc = Util.parseDouble(this.txtValue[src].getText());
        int unitsSrc = this.cbUnits[src].getSelectedIndex();
        if (unitsSrc == (unitsDst = this.cbUnits[dst].getSelectedIndex())) {
            valueDst = valueSrc;
        } else if (unitsSrc == 0 && unitsDst == 1) {
            valueDst = Conv.ms_to_kh(valueSrc);
        } else if (unitsSrc == 1 && unitsDst == 0) {
            valueDst = Conv.kh_to_ms(valueSrc);
        } else {
            return;
        }
        this.txtValue[dst].setText(f4dec.format(valueDst));
    }
}

