/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.frontend;

import gatcomsumo.backend.Network;
import gatcomsumo.frontend.Panel_LatLong;
import gatcomsumo.frontend.Panel_UTM;
import gatcomsumo.frontend.Panel_XY;
import gatcomsumo.frontend.SubpanelCoord;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import util.gps.GeodeticCoordinates;
import util.gps.LatLongUTM;
import util.gps.UTMCoordinates;

public class Panel_Tools_ConvCoord
extends JPanel
implements ActionListener {
    private Network network;
    private SubpanelCoord pFrom;
    private SubpanelCoord pTo;
    private JButton pConv;

    public Panel_Tools_ConvCoord(Network network) {
        this.network = network;
        TitledBorder b = new TitledBorder("Coordinates conversion tool");
        this.setBorder(b);
        JPanel pCentro = new JPanel();
        this.pFrom = new SubpanelCoord(this, " From ", 0, true, true);
        this.pTo = new SubpanelCoord(this, " To ", 1, false, false);
        pCentro.setLayout(new GridLayout(2, 1));
        pCentro.add(this.pFrom);
        pCentro.add(this.pTo);
        this.pConv = new JButton("Convert");
        this.pConv.addActionListener(this);
        this.setLayout(new BorderLayout());
        this.add((Component)pCentro, "Center");
        this.add((Component)this.pConv, "South");
    }

    private void convert() {
        int src = this.pFrom.cbCoord.getSelectedIndex();
        int dst = this.pTo.cbCoord.getSelectedIndex();
        Point2D.Double from = new Point2D.Double(0.0, 0.0);
        Point2D.Double to = new Point2D.Double(0.0, 0.0);
        Point2D.Double toSUMO = new Point2D.Double(0.0, 0.0);
        Point2D.Double toOMNET = new Point2D.Double(0.0, 0.0);
        block0 : switch (src) {
            case 0: {
                Panel_UTM pFromUTM = (Panel_UTM)this.pFrom.pPanels[0];
                UTMCoordinates fromUTM = pFromUTM.getValues();
                if (fromUTM == null) {
                    return;
                }
                from.setLocation(fromUTM.x, fromUTM.y);
                switch (dst) {
                    case 0: {
                        UTMCoordinates toUTM = fromUTM;
                        Panel_UTM pToUTM = (Panel_UTM)this.pTo.pPanels[0];
                        pToUTM.setValues(toUTM);
                        break block0;
                    }
                    case 1: {
                        GeodeticCoordinates toGeo = this.network.utm2lonlat(fromUTM, to);
                        Panel_LatLong pToGeo = (Panel_LatLong)this.pTo.pPanels[1];
                        pToGeo.setValues(toGeo);
                        break block0;
                    }
                    case 2: {
                        this.network.utm2sumo(from, toSUMO);
                        Panel_XY pToXY_SUMO = (Panel_XY)this.pTo.pPanels[2];
                        pToXY_SUMO.setValues(toSUMO);
                        break block0;
                    }
                    case 3: {
                        this.network.utm2sumo(from, toSUMO);
                        this.network.sumo2omnet(toSUMO, toOMNET);
                        Panel_XY pToXY_OMNET = (Panel_XY)this.pTo.pPanels[3];
                        pToXY_OMNET.setValues(toOMNET);
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                Panel_LatLong pFromGeo = (Panel_LatLong)this.pFrom.pPanels[1];
                GeodeticCoordinates fromGeo = pFromGeo.getValues();
                if (fromGeo == null) {
                    return;
                }
                from.setLocation(fromGeo.longitude, fromGeo.latitude);
                switch (dst) {
                    case 0: {
                        UTMCoordinates toUTM = LatLongUTM.LLtoUTM(23, fromGeo);
                        Panel_UTM pToUTM = (Panel_UTM)this.pTo.pPanels[0];
                        pToUTM.setValues(toUTM);
                        break block0;
                    }
                    case 1: {
                        GeodeticCoordinates toGeo = fromGeo;
                        Panel_LatLong pToGeo = (Panel_LatLong)this.pTo.pPanels[1];
                        pToGeo.setValues(toGeo);
                        break block0;
                    }
                    case 2: {
                        this.network.lonlat2sumo(from, toSUMO);
                        Panel_XY pToXY_SUMO = (Panel_XY)this.pTo.pPanels[2];
                        pToXY_SUMO.setValues(toSUMO);
                        break block0;
                    }
                    case 3: {
                        this.network.lonlat2sumo(from, toSUMO);
                        this.network.sumo2omnet(toSUMO, toOMNET);
                        Panel_XY pToXY_OMNET = (Panel_XY)this.pTo.pPanels[3];
                        pToXY_OMNET.setValues(toOMNET);
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                Panel_XY pFromXY_SUMO = (Panel_XY)this.pFrom.pPanels[2];
                from = pFromXY_SUMO.getValues();
                if (from == null) {
                    return;
                }
                switch (dst) {
                    case 0: {
                        UTMCoordinates toUTM = this.network.sumo2utm(from, to);
                        Panel_UTM pToUTM = (Panel_UTM)this.pTo.pPanels[0];
                        pToUTM.setValues(toUTM);
                        break block0;
                    }
                    case 1: {
                        GeodeticCoordinates toGeo = this.network.sumo2lonlat(from, to);
                        Panel_LatLong pToGeo = (Panel_LatLong)this.pTo.pPanels[1];
                        pToGeo.setValues(toGeo);
                        break block0;
                    }
                    case 2: {
                        toSUMO = from;
                        Panel_XY pToXY_SUMO = (Panel_XY)this.pTo.pPanels[2];
                        pToXY_SUMO.setValues(toSUMO);
                        break block0;
                    }
                    case 3: {
                        this.network.sumo2omnet(from, toOMNET);
                        Panel_XY pToXY_OMNET = (Panel_XY)this.pTo.pPanels[3];
                        pToXY_OMNET.setValues(toOMNET);
                        break block0;
                    }
                }
                break;
            }
            case 3: {
                Panel_XY pFromXYomnet = (Panel_XY)this.pFrom.pPanels[3];
                from = pFromXYomnet.getValues();
                if (from == null) {
                    return;
                }
                switch (dst) {
                    case 0: {
                        this.network.omnet2sumo(from, toSUMO);
                        UTMCoordinates toUTM = this.network.sumo2utm(toSUMO, to);
                        Panel_UTM pToUTM = (Panel_UTM)this.pTo.pPanels[0];
                        pToUTM.setValues(toUTM);
                        break block0;
                    }
                    case 1: {
                        this.network.omnet2sumo(from, toSUMO);
                        GeodeticCoordinates toGeo = this.network.sumo2lonlat(toSUMO, to);
                        Panel_LatLong pToGeo = (Panel_LatLong)this.pTo.pPanels[1];
                        pToGeo.setValues(toGeo);
                        break block0;
                    }
                    case 2: {
                        this.network.omnet2sumo(from, toSUMO);
                        Panel_XY pToXY_SUMO = (Panel_XY)this.pTo.pPanels[2];
                        pToXY_SUMO.setValues(toSUMO);
                        break block0;
                    }
                    case 3: {
                        toOMNET = from;
                        Panel_XY pToXY_OMNET = (Panel_XY)this.pTo.pPanels[3];
                        pToXY_OMNET.setValues(toOMNET);
                        break block0;
                    }
                }
                break;
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.convert();
    }
}

