/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.frontend;

import gatcomsumo.backend.SUMO;
import gatcomsumo.frontend.DlgCommRange;
import gatcomsumo.frontend.DlgThermalNoise;
import gatcomsumo.frontend.MyFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.DecimalFormat;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import util.Conv;
import util.Util;
import wireless.PHY_FSPL;
import wireless.PHY_TwoRay;
import wireless.Units_Distance;
import wireless.Units_Frequency;

public class Panel_Tools_CommRange
extends JPanel
implements ActionListener,
KeyListener {
    private static final DecimalFormat f7dec = new DecimalFormat("#,##0.0000000");
    private static final DecimalFormat f2dec = new DecimalFormat("#,##0.00");
    private JLabel lblPtx;
    private JLabel lblPrx;
    private JLabel lblGtx;
    private JLabel lblGrx;
    private JLabel lblHtx;
    private JLabel lblHrx;
    private JLabel lblFrequency;
    private JLabel lblDistance;
    private JLabel lblPtx_mW;
    private JTextField txtPtx;
    private JTextField txtPrx;
    private JTextField txtGtx;
    private JTextField txtGrx;
    private JTextField txtHtx;
    private JTextField txtHrx;
    private JTextField txtFrequency;
    private JTextField txtDistance;
    private JComboBox cbDistanceUnits;
    private JComboBox cbFrequencyUnits;
    private JButton pbCalculateRange;
    private JButton pbCalculateParameters;
    private JButton pbCalculateThermalNoise;
    private MyFrame f;
    private SUMO sumo;
    private JComboBox cbPropModel;

    public Panel_Tools_CommRange(MyFrame f, SUMO sumo, JComboBox cbPropModel) {
        this.f = f;
        this.sumo = sumo;
        this.cbPropModel = cbPropModel;
        TitledBorder b = new TitledBorder("Communication range calculator");
        this.setBorder(b);
        this.lblPtx = new JLabel("Tx transmission power (dBm):");
        this.txtPtx = new JTextField("13,0103000", 10);
        this.txtPtx.setToolTipText("Transmit power of the sending node");
        this.txtPtx.addKeyListener(this);
        this.lblPtx_mW = new JLabel("");
        this.lblPrx = new JLabel("Rx reception power threshold (dBm):");
        this.txtPrx = new JTextField("-89", 10);
        this.txtPrx.setToolTipText("Received power threshold (receiver sensitivity) value of the receiving node in dBm");
        this.lblGtx = new JLabel("Tx antenna gain (dBi):");
        this.txtGtx = new JTextField("0", 10);
        this.txtGtx.setToolTipText("Transmitter antenna gain");
        this.lblGrx = new JLabel("Rx antenna gain (dBi):");
        this.txtGrx = new JTextField("0", 10);
        this.txtGrx.setToolTipText("Receiver antenna gain");
        this.lblHtx = new JLabel("Tx antenna height (m):");
        this.txtHtx = new JTextField("1", 10);
        this.txtHtx.setToolTipText("Transmitter antenna height (m); only for Two-ray ground reflection model");
        this.lblHrx = new JLabel("Rx antenna height (m):");
        this.txtHrx = new JTextField("1", 10);
        this.txtHrx.setToolTipText("Receiver antenna height (m); only for Two-ray ground reflection model");
        this.lblFrequency = new JLabel("Frequency:");
        this.txtFrequency = new JTextField("5.890", 10);
        this.txtFrequency.setToolTipText("Frequency band of the carrier in MHz (e.g. 2.4 GHz is 2400 MHz)");
        this.cbFrequencyUnits = new JComboBox();
        Units_Frequency.fill(this.cbFrequencyUnits);
        this.cbFrequencyUnits.setSelectedIndex(3);
        this.lblDistance = new JLabel("Distance:");
        this.txtDistance = new JTextField("", 10);
        this.txtDistance.setToolTipText("Maximum distance between transmitter and receiver");
        this.txtDistance.setEditable(false);
        this.cbDistanceUnits = new JComboBox();
        Units_Distance.fill(this.cbDistanceUnits);
        this.cbDistanceUnits.setSelectedIndex(0);
        JPanel pCentro = new JPanel();
        pCentro.setLayout(new GridLayout(8, 2));
        pCentro.add(this.lblPtx);
        pCentro.add(this.txtPtx);
        pCentro.add(this.lblPrx);
        pCentro.add(this.txtPrx);
        pCentro.add(this.lblGtx);
        pCentro.add(this.txtGtx);
        pCentro.add(this.lblGrx);
        pCentro.add(this.txtGrx);
        pCentro.add(this.lblHtx);
        pCentro.add(this.txtHtx);
        pCentro.add(this.lblHrx);
        pCentro.add(this.txtHrx);
        pCentro.add(this.lblFrequency);
        pCentro.add(this.txtFrequency);
        pCentro.add(this.lblDistance);
        pCentro.add(this.txtDistance);
        JPanel pEste = new JPanel();
        pEste.setLayout(new GridLayout(8, 1));
        pEste.add(this.lblPtx_mW);
        pEste.add(new JLabel(""));
        pEste.add(new JLabel(""));
        pEste.add(new JLabel(""));
        pEste.add(new JLabel(""));
        pEste.add(new JLabel(""));
        pEste.add(this.cbFrequencyUnits);
        pEste.add(this.cbDistanceUnits);
        JPanel pSur = new JPanel();
        pSur.setLayout(new FlowLayout());
        this.pbCalculateRange = new JButton("Calculate Distance");
        this.pbCalculateRange.setToolTipText("Calculate the distance from the parameters");
        this.pbCalculateRange.addActionListener(this);
        this.pbCalculateParameters = new JButton("Calculate Parameters ...");
        this.pbCalculateParameters.setToolTipText("Calculate the parameters (Ptx, Prx) from the distance");
        this.pbCalculateParameters.addActionListener(this);
        this.pbCalculateThermalNoise = new JButton("Calculate Thermal Noise ...");
        this.pbCalculateThermalNoise.setToolTipText("Calculate the Thermal Noise");
        this.pbCalculateThermalNoise.addActionListener(this);
        pSur.add(this.pbCalculateRange);
        pSur.add(this.pbCalculateParameters);
        pSur.add(this.pbCalculateThermalNoise);
        this.setLayout(new BorderLayout());
        this.add((Component)pCentro, "Center");
        this.add((Component)pSur, "South");
        this.add((Component)pEste, "East");
        this.convert_dBm_mW();
    }

    public void setModel() {
        boolean tworay = this.cbPropModel.getSelectedIndex() == 1;
        this.txtHtx.setEnabled(tworay);
        this.txtHrx.setEnabled(tworay);
    }

    private void convert_dBm_mW() {
        double dBm = Util.parseDouble(this.txtPtx.getText());
        double mW = Conv.dBm_to_watts(dBm) * 1000.0;
        this.lblPtx_mW.setText("  " + f2dec.format(mW) + " mW");
    }

    @Override
    public void keyTyped(KeyEvent e) {
        this.convert_dBm_mW();
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        double htx = 0.0;
        double hrx = 0.0;
        boolean tworay = this.cbPropModel.getSelectedIndex() == 1;
        double ptx = Util.parseDouble(this.txtPtx.getText());
        double prx = Util.parseDouble(this.txtPrx.getText());
        double gtx_dbi = Util.parseDouble(this.txtGtx.getText());
        double grx_dbi = Util.parseDouble(this.txtGrx.getText());
        double gtx = Conv.dBi_to_absolute(gtx_dbi);
        double grx = Conv.dBi_to_absolute(grx_dbi);
        double f = Util.parseDouble(this.txtFrequency.getText());
        if (tworay) {
            htx = Util.parseDouble(this.txtHtx.getText());
            hrx = Util.parseDouble(this.txtHrx.getText());
        }
        Units_Distance d_units = (Units_Distance)((Object)this.cbDistanceUnits.getSelectedItem());
        Units_Frequency f_units = (Units_Frequency)((Object)this.cbFrequencyUnits.getSelectedItem());
        if (e.getSource() == this.pbCalculateRange) {
            double cr1 = !tworay ? PHY_FSPL.communicationRange_dB1(ptx, prx, gtx, grx, f, d_units, f_units) : PHY_TwoRay.communicationRange_dB1(ptx, prx, gtx, grx, htx, hrx, d_units);
            this.txtDistance.setText(f7dec.format(cr1));
        } else if (e.getSource() == this.pbCalculateParameters) {
            String distance = this.txtDistance.getText();
            int pos = distance.indexOf(" /");
            if (pos >= 0) {
                distance = distance.substring(0, pos);
            }
            double d = Util.parseDouble(distance);
            DlgCommRange dlg = new DlgCommRange(this.f, this.cbPropModel, ptx, prx, gtx, grx, htx, hrx, d, f, d_units, f_units);
            dlg.setVisible(true);
        } else if (e.getSource() == this.pbCalculateThermalNoise) {
            DlgThermalNoise dlg = new DlgThermalNoise(this.f, f, f_units);
            dlg.setVisible(true);
        }
    }
}

