/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.frontend;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DecimalFormat;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class Panel_Time
extends JPanel
implements ItemListener {
    private JComboBox cbHH;
    private JComboBox cbMM;
    private JComboBox cbSS;
    private JComboBox cbTS;
    private JLabel lblSS;
    static final DecimalFormat f00 = new DecimalFormat("00");
    static final DecimalFormat f0_0 = new DecimalFormat("#,##0.0");

    public Panel_Time() {
        int s;
        FlowLayout layout = new FlowLayout(0);
        layout.setHgap(1);
        this.setLayout(layout);
        this.cbHH = new JComboBox();
        this.cbHH.setToolTipText("Hours");
        this.cbHH.addItemListener(this);
        this.cbMM = new JComboBox();
        this.cbMM.setToolTipText("Minutes");
        this.cbMM.addItemListener(this);
        this.cbSS = new JComboBox();
        this.cbSS.setToolTipText("Seconds");
        this.cbSS.addItemListener(this);
        this.cbTS = new JComboBox();
        this.cbTS.setToolTipText("Tenths of second");
        this.cbTS.addItemListener(this);
        this.add(this.cbHH);
        this.add(new JLabel(":"));
        this.add(this.cbMM);
        this.add(new JLabel(":"));
        this.add(this.cbSS);
        this.add(new JLabel(":"));
        this.add(this.cbTS);
        this.lblSS = new JLabel("(0 s.)");
        this.lblSS.setPreferredSize(new Dimension(75, 10));
        this.add(this.lblSS);
        for (int h = 0; h < 24; ++h) {
            this.cbHH.addItem(f00.format(h));
        }
        for (int m = 0; m < 60; ++m) {
            this.cbMM.addItem(f00.format(m));
        }
        for (s = 0; s < 60; ++s) {
            this.cbSS.addItem(f00.format(s));
        }
        for (s = 0; s < 10; ++s) {
            this.cbTS.addItem(s);
        }
    }

    public void setSeconds(double seconds) {
        double fhh = seconds / 3600.0;
        int ihh = (int)fhh;
        double fmm = (fhh - (double)ihh) * 60.0;
        int imm = (int)fmm;
        double fss = (fmm - (double)imm) * 60.0;
        int iss = (int)fss;
        double fts = (fss - (double)iss) * 10.0;
        int its = (int)Math.round(fts);
        this.cbHH.setSelectedIndex(ihh);
        this.cbMM.setSelectedIndex(imm);
        this.cbSS.setSelectedIndex(iss);
        this.cbTS.setSelectedIndex(its);
    }

    public double getSeconds() {
        int ihh = this.cbHH.getSelectedIndex();
        int imm = this.cbMM.getSelectedIndex();
        int iss = this.cbSS.getSelectedIndex();
        int its = this.cbTS.getSelectedIndex();
        double seconds = Panel_Time.hhmmss2sec(ihh, imm, iss, its);
        return seconds;
    }

    private static double hhmmss2sec(int hh, int mm, int ss, int ts) {
        double sec = (float)(hh * 3600 + mm * 60 + ss) + (float)ts / 10.0f;
        return sec;
    }

    @Override
    public String toString() {
        String s = "";
        int ihh = this.cbHH.getSelectedIndex();
        int imm = this.cbMM.getSelectedIndex();
        int iss = this.cbSS.getSelectedIndex();
        s = f00.format(ihh) + ":" + f00.format(imm) + ":" + f00.format(iss);
        return s;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        double seconds = this.getSeconds();
        this.lblSS.setText(f0_0.format(seconds) + " s.");
    }
}

