/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.frontend;

import gatcomsumo.backend.Route;
import gatcomsumo.backend.SUMO;
import gatcomsumo.frontend.DlgRoute;
import gatcomsumo.frontend.MyFrame;
import gatcomsumo.frontend.Panel_GenericTable;

public class Panel_Routes
extends Panel_GenericTable
implements Panel_GenericTable.MyListener {
    public Panel_Routes(MyFrame f, String title, SUMO sumo) {
        super(f, title, sumo, Route.HEADERS, Route.NONEDITABLECOLS, true, true, true, false, false);
        this.addListener(this);
    }

    @Override
    public void addItem(Panel_GenericTable.MyEvent e) {
        int nrows;
        int row = nrows = this.table.getNumRows();
        String prefix = this.sumo.trafficDemand.routes.getLastPrefix();
        int index = this.sumo.trafficDemand.routes.getLastIndex(prefix) + 1;
        String id = prefix + "-" + index;
        Route route = new Route(id);
        this.sumo.trafficDemand.routes.list.add(route);
        Object[] data = route.buildRowTable(row);
        this.table.appendRow(data, true);
        this.f.pCanvas.updateRoutes();
        this.sumo.trafficDemand.setChanged(true);
    }

    @Override
    public void selectItem(Panel_GenericTable.MyEvent e, int index) {
    }

    @Override
    public void removeItemBefore(Panel_GenericTable.MyEvent e, int index) {
        this.sumo.trafficDemand.routes.list.remove(index);
        this.f.pCanvas.updateRoutes();
        this.sumo.trafficDemand.setChanged(true);
    }

    @Override
    public void removeItemAfter(Panel_GenericTable.MyEvent e, int index) {
    }

    @Override
    public void editItem(Panel_GenericTable.MyEvent e, int index) {
        Route route;
        try {
            route = this.sumo.trafficDemand.routes.list.get(index);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return;
        }
        if (route == null) {
            return;
        }
        DlgRoute dlg = new DlgRoute(this.f, this.sumo, "Route", route);
        dlg.setVisible(true);
        if (!dlg.isCanceled()) {
            Object[] data = route.buildRowTable(index);
            this.updateItem(index, data);
            if (dlg.vehiclesModified()) {
                this.f.pTrafficDemands.pVehicles.update();
            }
            if (dlg.flowsModified()) {
                this.f.pTrafficDemands.pFlows.update();
            }
            this.sumo.trafficDemand.setChanged(true);
        }
    }

    public void update() {
        int row = 0;
        this.table.removeAllRows();
        for (Route item : this.sumo.trafficDemand.routes.list) {
            Object[] data = item.buildRowTable(row);
            this.table.appendRow(data, true);
            ++row;
        }
        if (this.table.getNumRows() > 0) {
            this.table.selectRow(0);
        }
        this.f.pCanvas.updateRoutes();
    }

    @Override
    public boolean load(Panel_GenericTable.MyEvent e) {
        return true;
    }

    @Override
    public boolean save(Panel_GenericTable.MyEvent e) {
        return true;
    }
}

