/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.frontend;

import gatcomsumo.backend.Edge;
import gatcomsumo.backend.Route;
import gatcomsumo.backend.SUMO;
import gatcomsumo.frontend.DlgRoute;
import gatcomsumo.frontend.DlgSelect;
import gatcomsumo.frontend.MyFrame;
import gatcomsumo.frontend.Panel_GenericTable;
import gatcomsumo.frontend.Panel_Route;
import java.awt.Dimension;
import java.awt.Window;
import java.util.ArrayList;
import javax.swing.JOptionPane;

public class Panel_RouteEdges
extends Panel_GenericTable
implements Panel_GenericTable.MyListener {
    private DlgRoute dlgRoute;
    private Route route;
    private Panel_Route pRoute;
    public boolean edgesMod;

    public Panel_RouteEdges(MyFrame f, DlgRoute dlgRoute, String title, SUMO sumo, Route route, Panel_Route pRoute) {
        super(f, title, sumo, Edge.HEADERS, Edge.NONEDITABLECOLS, true, true, false, false, false);
        this.addListener(this);
        this.dlgRoute = dlgRoute;
        this.route = route;
        this.pRoute = pRoute;
        this.edgesMod = false;
        this.setPreferredSize(new Dimension(400, 200));
    }

    public void object2components() {
        this.route.fill(this.table);
        int numRows = this.table.getNumRows();
        if (numRows > 0) {
            this.table.selectRow(numRows - 1);
        }
    }

    public void components2object() {
        this.route.edges.clear();
        int numRows = this.table.getNumRows();
        for (int i = 0; i < numRows; ++i) {
            String id = this.table.getDataString(i, 1);
            Edge edge = this.sumo.network.edges.searchBinary(id);
            if (edge == null) continue;
            this.route.edges.add(edge);
        }
    }

    @Override
    public void addItem(Panel_GenericTable.MyEvent e) {
        DlgSelect dlg;
        Edge lastEdge = this.getLastEdge();
        if (lastEdge == null) {
            dlg = new DlgSelect((Window)this.dlgRoute, "Edge", null, this.sumo.network.edges.list);
            dlg.setTitle("Edge");
        } else {
            ArrayList<Edge> edges = new ArrayList<Edge>();
            lastEdge.getAdjacents(edges);
            dlg = new DlgSelect((Window)this.dlgRoute, "Edge", lastEdge, edges);
        }
        dlg.setVisible(true);
        Edge edge = (Edge)dlg.getObject();
        if (edge != null) {
            this.edgesMod = true;
            int numRows = this.table.getNumRows();
            Object[] data = edge.buildRowTable(numRows, lastEdge);
            this.table.appendRow(data, true);
            numRows = this.table.getNumRows();
            this.table.selectRow(numRows - 1);
            this.pRoute.updateRouteData();
        }
    }

    @Override
    public void removeItemBefore(Panel_GenericTable.MyEvent e, int index) {
        int numRows = this.table.getNumRows();
        if (index < numRows - 1) {
            for (int row = numRows - 1; row > index; --row) {
                this.table.removeRow(row);
            }
            JOptionPane.showMessageDialog(this.f, "The rows " + (index + 2) + " to " + numRows + " are also going to be removed\nin order to avoid unconnected routes!", "Warning", 2);
        }
    }

    @Override
    public void removeItemAfter(Panel_GenericTable.MyEvent e, int index) {
        this.edgesMod = true;
        this.pRoute.updateRouteData();
    }

    @Override
    public void editItem(Panel_GenericTable.MyEvent e, int index) {
    }

    @Override
    public void selectItem(Panel_GenericTable.MyEvent e, int index) {
    }

    @Override
    public boolean load(Panel_GenericTable.MyEvent e) {
        return false;
    }

    @Override
    public boolean save(Panel_GenericTable.MyEvent e) {
        return false;
    }

    public int getNumRows() {
        return this.table.getNumRows();
    }

    public Edge getLastEdge() {
        Edge edge;
        int numRows = this.table.getNumRows();
        if (numRows == 0) {
            edge = null;
        } else {
            String id = this.table.getDataString(numRows - 1, 1);
            edge = this.sumo.network.edges.searchBinary(id);
        }
        return edge;
    }

    public double computeLength() {
        double length = 0.0;
        int numRows = this.table.getNumRows();
        for (int i = 0; i < numRows; ++i) {
            String id = this.table.getDataString(i, 1);
            Edge edge = this.sumo.network.edges.searchBinary(id);
            length += edge.length();
        }
        return length;
    }
}

