/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.frontend;

import gatcomsumo.backend.Flow;
import gatcomsumo.backend.Route;
import gatcomsumo.backend.SUMO;
import gatcomsumo.backend.Vehicle;
import gatcomsumo.frontend.DlgRoute;
import gatcomsumo.frontend.DlgSelect;
import gatcomsumo.frontend.MyFrame;
import gatcomsumo.frontend.Panel_GenericList;
import gatcomsumo.frontend.Panel_RouteEdges;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DecimalFormat;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import util.Colors;

public class Panel_Route
extends JPanel
implements ItemListener,
Panel_GenericList.MyListener {
    private MyFrame f;
    private DlgRoute dlgRoute;
    private SUMO sumo;
    private Route route;
    private JLabel lblID;
    private JLabel lblColor;
    private JLabel lblDistance;
    public JTextField txtID;
    public JTextField txtDistance;
    public JComboBox cbColor;
    public Panel_GenericList pVehicles;
    public Panel_GenericList pFlows;
    public Panel_RouteEdges pEdges;
    private JPanel pNorte;
    private JPanel pSur;
    public boolean edgesMod;
    public boolean vehiclesMod;
    public boolean flowsMod;
    private static final DecimalFormat f2 = new DecimalFormat("##0.00");

    public Panel_Route(MyFrame f, DlgRoute dlgRoute, SUMO sumo, Route route) {
        this.f = f;
        this.dlgRoute = dlgRoute;
        this.sumo = sumo;
        this.route = route;
        this.pNorte = new JPanel();
        this.pNorte.setLayout(new FlowLayout());
        this.pEdges = new Panel_RouteEdges(f, dlgRoute, "Edges", sumo, route, this);
        this.pVehicles = new Panel_GenericList(f, "Vehicles", sumo, true, true, false, false, false);
        this.pFlows = new Panel_GenericList(f, "Flows", sumo, true, true, false, false, false);
        this.pVehicles.addListener(this);
        this.pFlows.addListener(this);
        this.pSur = new JPanel();
        this.pSur.setLayout(new GridLayout(1, 2));
        this.pSur.add(this.pVehicles);
        this.pSur.add(this.pFlows);
        this.setLayout(new BorderLayout());
        this.add((Component)this.pNorte, "North");
        this.add((Component)this.pEdges, "Center");
        this.add((Component)this.pSur, "South");
        this.lblID = new JLabel("ID:");
        this.txtID = new JTextField("", 7);
        this.lblColor = new JLabel("Color:");
        this.cbColor = new JComboBox<Colors>(Colors.values());
        this.cbColor.setSelectedItem((Object)Colors.GREEN);
        this.cbColor.addItemListener(this);
        this.lblDistance = new JLabel("Dist. (m):");
        this.txtDistance = new JTextField("", 5);
        this.txtDistance.setEnabled(false);
        this.pNorte.add(this.lblID);
        this.pNorte.add(this.txtID);
        this.pNorte.add(this.lblColor);
        this.pNorte.add(this.cbColor);
        this.pNorte.add(this.lblDistance);
        this.pNorte.add(this.txtDistance);
        this.flowsMod = false;
        this.vehiclesMod = false;
        this.edgesMod = false;
    }

    public void object2components() {
        this.txtID.setText(this.route.id);
        if (this.route.color != null) {
            this.cbColor.setSelectedItem((Object)this.route.color);
        }
        this.pEdges.object2components();
        this.pVehicles.list.removeAll();
        if (this.route.vehicles.size() > 0) {
            for (Vehicle vehicle : this.route.vehicles) {
                this.pVehicles.list.add(vehicle.id);
            }
            this.pVehicles.list.select(0);
        }
        this.pFlows.list.removeAll();
        if (this.route.flows.size() > 0) {
            for (Flow flow : this.route.flows) {
                this.pFlows.list.add(flow.id);
            }
            this.pFlows.list.select(0);
        }
        this.updateRouteData();
    }

    public void components2object() {
        String id;
        this.route.id = this.txtID.getText();
        this.route.color = (Colors)((Object)this.cbColor.getSelectedItem());
        if (this.edgesMod) {
            this.pEdges.components2object();
        }
        if (this.vehiclesMod) {
            for (Vehicle vehicle : this.route.vehicles) {
                vehicle.route = null;
            }
            this.route.vehicles.clear();
            for (int i = 0; i < this.pVehicles.list.getItemCount(); ++i) {
                id = this.pVehicles.list.getItem(i);
                Vehicle vehicle = this.sumo.trafficDemand.vehicles.search(id);
                if (vehicle == null) continue;
                vehicle.setRoute(this.route);
            }
        }
        if (this.flowsMod) {
            for (Flow flow : this.route.flows) {
                flow.route = null;
            }
            this.route.flows.clear();
            for (int i = 0; i < this.pFlows.list.getItemCount(); ++i) {
                id = this.pFlows.list.getItem(i);
                Flow flow = this.sumo.trafficDemand.flows.search(id);
                if (flow == null) continue;
                flow.setRoute(this.route);
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.cbColor) {
            Colors colors = (Colors)((Object)this.cbColor.getSelectedItem());
        }
    }

    public void updateRouteData() {
        double length = this.pEdges.computeLength();
        this.txtDistance.setText(f2.format(length));
        this.pEdges.setTitle(" Edges (" + this.pEdges.getNumRows() + ") ");
        this.edgesMod = this.pEdges.edgesMod;
        this.pVehicles.setTitle(" Vehicles (" + this.pVehicles.list.getItemCount() + ") ");
        this.pFlows.setTitle(" Flows (" + this.pFlows.list.getItemCount() + ") ");
    }

    @Override
    public void addItem(Panel_GenericList.MyEvent e) {
        if (e.getSource() == this.pVehicles) {
            DlgSelect dlg = new DlgSelect((Window)this.dlgRoute, "Vehicles", null, this.sumo.trafficDemand.vehicles.list);
            dlg.setVisible(true);
            Vehicle vehicle = (Vehicle)dlg.getObject();
            if (vehicle != null) {
                this.vehiclesMod = true;
                this.pVehicles.list.add(vehicle.id);
            }
        } else if (e.getSource() == this.pFlows) {
            DlgSelect dlg = new DlgSelect((Window)this.dlgRoute, "Flows", null, this.sumo.trafficDemand.flows.list);
            dlg.setVisible(true);
            Flow flow = (Flow)dlg.getObject();
            if (flow != null) {
                this.flowsMod = true;
                this.pFlows.list.add(flow.id);
            }
        }
        this.updateRouteData();
    }

    @Override
    public void selectItem(Panel_GenericList.MyEvent e, int index) {
    }

    @Override
    public void removeItem(Panel_GenericList.MyEvent e, int index) {
        if (e.getSource() == this.pVehicles) {
            this.vehiclesMod = true;
        } else if (e.getSource() == this.pFlows) {
            this.flowsMod = true;
        }
        this.updateRouteData();
    }

    @Override
    public void editItem(Panel_GenericList.MyEvent e, int index) {
    }

    @Override
    public boolean load(Panel_GenericList.MyEvent e) {
        return false;
    }

    @Override
    public boolean save(Panel_GenericList.MyEvent e) {
        return false;
    }
}

