/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.frontend;

import gatcomsumo.backend.NetworkType;
import gatcomsumo.backend.SUMO;
import gatcomsumo.frontend.MyFrame;
import gatcomsumo.frontend.Panel_Tools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import util.Util;
import util.gui.MyTextAreaScrollable;

public class Panel_Omnet
extends JPanel
implements ActionListener {
    private MyFrame f;
    private SUMO sumo;
    private JLabel lblScenario;
    private JLabel lblAutoStart;
    private JLabel lblPropModel;
    private JLabel lblObstacles;
    private JLabel lblModuleType;
    private JLabel lblModuleName;
    private JLabel lblMargin;
    private JTextField txtScenario;
    private JTextField txtModuleType;
    private JTextField txtModuleName;
    private JTextField txtMargin;
    private JComboBox cbAutoStart;
    private JComboBox cbPropModel;
    private JComboBox cbObstacles;
    MyTextAreaScrollable txtFile1;
    MyTextAreaScrollable txtFile2;
    MyTextAreaScrollable txtFile3;
    MyTextAreaScrollable txtFile4;
    private JButton generate;

    public Panel_Omnet(MyFrame f, SUMO sumo) {
        this.f = f;
        this.sumo = sumo;
        TitledBorder b = new TitledBorder("OMNeT++ files");
        this.setBorder(b);
        this.lblScenario = new JLabel("Scenario:");
        this.txtScenario = new JTextField("elche", 20);
        this.lblAutoStart = new JLabel("Press the [Start] button of sumo-gui?");
        this.cbAutoStart = new JComboBox();
        this.cbAutoStart.addItem("No");
        this.cbAutoStart.addItem("Yes");
        this.cbAutoStart.setSelectedIndex(0);
        this.lblPropModel = new JLabel("Radio propagation model:");
        this.cbPropModel = new JComboBox<String>(Panel_Tools.MODELS_DESCR);
        this.cbPropModel.setSelectedIndex(0);
        this.lblObstacles = new JLabel("Use Obstacles?");
        this.cbObstacles = new JComboBox();
        this.cbObstacles.addItem("No");
        this.cbObstacles.addItem("Yes");
        this.cbObstacles.addItem("Selected by user");
        this.cbObstacles.setSelectedIndex(2);
        this.lblModuleType = new JLabel("Module Type:");
        this.txtModuleType = new JTextField("org.car2x.veins.nodes.Car", 20);
        this.lblModuleName = new JLabel("Module Name:");
        this.txtModuleName = new JTextField("node", 10);
        this.lblMargin = new JLabel("Margin:");
        this.txtMargin = new JTextField("25", 5);
        this.generate = new JButton("Generate files");
        this.generate.addActionListener(this);
        JPanel p1 = new JPanel();
        p1.setLayout(new FlowLayout(0));
        p1.add(this.lblScenario);
        p1.add(this.txtScenario);
        p1.add(this.lblAutoStart);
        p1.add(this.cbAutoStart);
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout(0));
        p2.add(this.lblPropModel);
        p2.add(this.cbPropModel);
        p2.add(this.lblObstacles);
        p2.add(this.cbObstacles);
        JPanel p3 = new JPanel();
        p3.setLayout(new FlowLayout(0));
        p3.add(this.lblModuleType);
        p3.add(this.txtModuleType);
        p3.add(this.lblModuleName);
        p3.add(this.txtModuleName);
        p3.add(this.lblMargin);
        p3.add(this.txtMargin);
        JPanel pNorte = new JPanel();
        pNorte.setLayout(new GridLayout(3, 1));
        pNorte.add(p1);
        pNorte.add(p2);
        pNorte.add(p3);
        JPanel pCentro = new JPanel();
        JPanel pCentro1 = new JPanel();
        pCentro1.setLayout(new GridLayout(1, 1));
        TitledBorder b1 = new TitledBorder(" File: xxx.sumo.cfg ");
        pCentro1.setBorder(b1);
        this.txtFile1 = new MyTextAreaScrollable();
        this.txtFile1.setEditable(false);
        pCentro1.add(this.txtFile1);
        JPanel pCentro2 = new JPanel();
        pCentro2.setLayout(new GridLayout(1, 1));
        TitledBorder b2 = new TitledBorder(" File: xxx.launchd.xml ");
        pCentro2.setBorder(b2);
        this.txtFile2 = new MyTextAreaScrollable();
        this.txtFile2.setEditable(false);
        pCentro2.add(this.txtFile2);
        JPanel pCentro3 = new JPanel();
        pCentro3.setLayout(new GridLayout(1, 1));
        TitledBorder b3 = new TitledBorder(" File: config.xml ");
        pCentro3.setBorder(b3);
        this.txtFile3 = new MyTextAreaScrollable();
        this.txtFile3.setEditable(false);
        pCentro3.add(this.txtFile3);
        JPanel pCentro4 = new JPanel();
        pCentro4.setLayout(new GridLayout(1, 1));
        TitledBorder b4 = new TitledBorder(" File: omnetpp.ini ");
        pCentro4.setBorder(b4);
        this.txtFile4 = new MyTextAreaScrollable();
        this.txtFile4.setEditable(false);
        pCentro4.add(this.txtFile4);
        pCentro.setLayout(new GridLayout(2, 2));
        pCentro.add(pCentro1);
        pCentro.add(pCentro2);
        pCentro.add(pCentro3);
        pCentro.add(pCentro4);
        JPanel pSur = new JPanel();
        pSur.setLayout(new FlowLayout());
        pSur.add(this.generate);
        this.setLayout(new BorderLayout());
        this.add((Component)pNorte, "North");
        this.add((Component)pCentro, "Center");
        this.add((Component)pSur, "South");
        this.txtScenario.setText(f.pNetwork.getProjectName());
    }

    public void setNetworkName(String name) {
        this.txtScenario.setText(name);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.generate) {
            String scenario = this.txtScenario.getText().trim();
            boolean tworay = this.cbPropModel.getSelectedIndex() == 1;
            int obstacles = this.cbObstacles.getSelectedIndex();
            boolean autostart = this.cbAutoStart.getSelectedIndex() == 0;
            String moduleType = this.txtModuleType.getText().trim();
            String moduleName = this.txtModuleName.getText().trim();
            int margin = Util.parseInt(this.txtMargin.getText());
            String[] filenames = new String[]{scenario + ".sumo.cfg", null, scenario + ".launchd.xml", scenario + ".ned", "config.xml", "omnetpp.ini", "run.sh"};
            switch (obstacles) {
                case 0: {
                    filenames[0] = scenario + ".sumo.cfg";
                    filenames[1] = null;
                    break;
                }
                case 1: {
                    filenames[0] = null;
                    filenames[1] = scenario + ".sumo.cfg";
                    break;
                }
                case 2: {
                    filenames[0] = scenario + "_without_obstacles.sumo.cfg";
                    filenames[1] = scenario + "_with_obstacles.sumo.cfg";
                }
            }
            String message = "The following files are going to be generated:\n\n";
            for (String filename : filenames) {
                if (filename == null) continue;
                File file = new File(filename);
                message = message + "- " + filename + (!file.exists() ? "" : " (!!)") + "\n";
            }
            int reply = JOptionPane.showConfirmDialog(this, message = message + "\nDo you want to continue?", "INFORMATION", 0);
            if (reply == 0) {
                if (obstacles < 2) {
                    this.generateFileSumoCfg(filenames[obstacles], scenario, obstacles, autostart);
                } else {
                    this.generateFileSumoCfg(filenames[0], scenario, 0, autostart);
                    this.generateFileSumoCfg(filenames[1], scenario, 1, autostart);
                }
                this.generateFileLaunchd(filenames[2], filenames[0], filenames[1], scenario, obstacles);
                this.generateFileScenario(filenames[3], scenario);
                this.generateFileAnalogModel(filenames[4], scenario, obstacles, tworay);
                this.generateFileOmnetpp(filenames[5], scenario, obstacles, moduleType, moduleName, margin);
                this.generateFileScript(filenames[6], scenario);
            }
        }
    }

    private boolean generateFileSumoCfg(String filename, String scenario, int obstacles, boolean autostart) {
        boolean ok = true;
        StringBuilder text = new StringBuilder();
        text.append("<!-- " + filename + " -->\n\n");
        text.append("<configuration> \n");
        text.append("    <input> \n");
        text.append("    <net-file value=\"" + scenario + ".net.xml\"/> \n");
        text.append("    <route-files value=\"" + scenario + ".rou.xml\"/>\n");
        if (obstacles > 0) {
            text.append("    <additional-files value=\"" + scenario + ".poly.xml\"/>\n");
        }
        text.append("</input> \n");
        text.append("<time>\n");
        text.append("    <begin value=\"0\"/>\n");
        text.append("    <end value=\"10000\"/>\n");
        text.append("    <step-length value=\"0.1\"/>\n");
        text.append("</time>\n");
        text.append("<processing>\n");
        text.append("    <time-to-teleport value=\"-1\"/>\n");
        text.append("</processing>\n");
        text.append("<gui_only>\n");
        text.append("    <start value=\"" + (autostart ? "true" : "false") + "\"/>\n");
        text.append("</gui_only>\n");
        text.append("</configuration>\n\n");
        this.txtFile1.setText(text.toString());
        ok = Util.writeTextFile(filename, text.toString());
        return ok;
    }

    private boolean generateFileLaunchd(String filename, String filename_cfg0, String filename_cfg1, String scenario, int obstacles) {
        boolean ok = true;
        String filename_net = scenario + ".net.xml";
        String filename_rou = scenario + ".rou.xml";
        String filename_poly = scenario + ".poly.xml";
        StringBuilder text = new StringBuilder();
        text.append("<?xml version=\"1.0\"?>\n");
        text.append("<!-- " + filename + " -->\n\n");
        if (obstacles == 2) {
            text.append("<root>\n");
            text.append("    <launch id=\"without-obstacles\">\n");
            text.append("        <copy file=\"" + filename_net + "\" />\n");
            text.append("        <copy file=\"" + filename_rou + "\" />\n");
            text.append("        <copy file=\"" + filename_cfg0 + "\" type=\"config\" />\n");
            text.append("    </launch>\n");
            text.append("    <launch id=\"with-obstacles\">\n");
            text.append("        <copy file=\"" + filename_net + "\" />\n");
            text.append("        <copy file=\"" + filename_rou + "\" />\n");
            text.append("        <copy file=\"" + filename_poly + "\" />\n");
            text.append("        <copy file=\"" + filename_cfg1 + "\" type=\"config\" />\n");
            text.append("    </launch>\n");
            text.append("</root>\n\n");
        } else {
            text.append("<launch>\n");
            text.append("    <copy file=\"" + filename_net + "\" />\n");
            text.append("    <copy file=\"" + filename_rou + "\" />\n");
            if (obstacles == 0) {
                text.append("    <copy file=\"" + filename_cfg0 + "\" type=\"config\" />\n");
            } else {
                text.append("    <copy file=\"" + filename_poly + "\" />\n");
                text.append("    <copy file=\"" + filename_cfg1 + "\" type=\"config\" />\n");
            }
            text.append("</launch>\n");
        }
        this.txtFile2.setText(text.toString());
        ok = Util.writeTextFile(filename, text.toString());
        return ok;
    }

    private boolean generateFileAnalogModel(String filename, String scenario, int obstacles, boolean tworay) {
        boolean ok = true;
        StringBuilder text = new StringBuilder();
        String alpha = "2.0";
        String frecuency = "5.890e+9";
        String propModel = tworay ? "TwoRayInterferenceModel" : "SimplePathlossModel";
        text.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        text.append("<!-- " + filename + " -->\n\n");
        text.append("<root>\n");
        text.append("   <AnalogueModels>\n");
        text.append("      <AnalogueModel type=\"" + propModel + "\">\n");
        text.append("          <parameter name=\"alpha\" type=\"double\" value=\"" + alpha + "\"/>\n");
        text.append("          <parameter name=\"carrierFrequency\" type=\"double\" value=\"" + frecuency + "\"/>\n");
        text.append("      </AnalogueModel>\n");
        if (obstacles > 0) {
            ArrayList<String> types;
            text.append("      <AnalogueModel type=\"SimpleObstacleShadowing\">\n");
            text.append("          <parameter name=\"carrierFrequency\" type=\"double\" value=\"" + frecuency + "\"/>\n");
            text.append("          <obstacles>\n");
            if (!this.sumo.getProjectName().equals(scenario)) {
                this.sumo.init(scenario, NetworkType.UNKNOWN);
            }
            if ((types = this.sumo.getPolyTypes()) != null && types.size() > 0) {
                for (String typeid : types) {
                    text.append("              <type id=\"" + typeid + "\" db-per-cut=\"9\" db-per-meter=\"0.4\" />\n");
                }
            } else {
                text.append("              <type id=\"building\" db-per-cut=\"9\" db-per-meter=\"0.4\" />\n");
            }
            text.append("          </obstacles>\n");
            text.append("      </AnalogueModel>\n");
        }
        text.append("   </AnalogueModels>\n");
        text.append("   <Decider type=\"Decider80211p\">\n");
        text.append("      <!-- The center frequency on which the phy listens -->\n");
        text.append("      <parameter name=\"centerFrequency\" type=\"double\" value=\"" + frecuency + "\"/>\n");
        text.append("   </Decider>\n");
        text.append("</root>\n");
        text.append("\n");
        this.txtFile3.setText(text.toString());
        ok = Util.writeTextFile(filename, text.toString());
        return ok;
    }

    private boolean generateFileOmnetpp(String filename, String scenario, int obstacles, String moduleType, String moduleName, int margin) {
        boolean ok = true;
        StringBuilder text = new StringBuilder();
        text.append("##########################################################\n");
        text.append("# File: " + filename + "\n");
        text.append("##########################################################\n");
        text.append("\n");
        text.append("[General]\n");
        text.append("cmdenv-express-mode = true\n");
        text.append("cmdenv-autoflush = true\n");
        text.append("cmdenv-status-frequency = 10000000s\n");
        text.append("\n");
        text.append("ned-path = .\n");
        text.append("\n");
        text.append("network = " + scenario + "\n");
        text.append("\n");
        text.append("##########################################################\n");
        text.append("#            Simulation parameters                       #\n");
        text.append("##########################################################\n");
        text.append("debug-on-errors = true\n");
        text.append("print-undisposed = false\n");
        text.append("\n");
        text.append("sim-time-limit = 6000s\n");
        text.append("\n");
        text.append("**.scalar-recording = true\n");
        text.append("**.vector-recording = true\n");
        text.append("\n");
        text.append("**.debug = false\n");
        text.append("**.coreDebug = false\n");
        text.append("\n");
        text.append("*.playgroundSizeX = " + (Math.round(this.sumo.network.location.bbox_conv_xmax) + 1L) + "m\n");
        text.append("*.playgroundSizeY = " + (Math.round(this.sumo.network.location.bbox_conv_ymax) + 1L) + "m\n");
        text.append("*.playgroundSizeZ = 50m\n");
        text.append("\n");
        if (obstacles == 2) {
            text.append("# Enable obstacles\n");
            text.append("*.withObstacles = ${withObstacles=false, true}\n");
        }
        text.append("\n");
        text.append("##########################################################\n");
        text.append("# Annotation parameters                                  #\n");
        text.append("##########################################################\n");
        if (obstacles == 0) {
            text.append("*.annotations.draw = false\n");
        } else if (obstacles == 1) {
            text.append("*.annotations.draw = true\n");
        } else {
            text.append("*.annotations.draw = ${withObstacles}\n");
        }
        text.append("\n");
        text.append("##########################################################\n");
        text.append("# Obstacle parameters                                    #\n");
        text.append("##########################################################\n");
        text.append("*.obstacles.debug = false\n");
        if (obstacles == 0) {
            text.append("#");
        }
        text.append("*.obstacles.obstacles = xmldoc(\"config.xml\", \"//AnalogueModel[@type='SimpleObstacleShadowing']/obstacles\")\n");
        text.append("\n");
        text.append("##########################################################\n");
        text.append("#            WorldUtility parameters                     #\n");
        text.append("##########################################################\n");
        text.append("*.world.useTorus = false\n");
        text.append("*.world.use2D = false\n");
        text.append("\n");
        text.append("##########################################################\n");
        text.append("#            TraCIScenarioManager parameters             #\n");
        text.append("##########################################################\n");
        text.append("*.manager.updateInterval = 0.1s\n");
        text.append("*.manager.host = \"localhost\"\n");
        text.append("*.manager.port = 9999\n");
        text.append("*.manager.moduleType = \"" + moduleType + "\"\n");
        text.append("*.manager.moduleName = \"" + moduleName + "\"\n");
        text.append("*.manager.moduleDisplayString = \"\"\n");
        text.append("*.manager.autoShutdown = true\n");
        text.append("*.manager.margin = ${marginsumo=" + margin + "}\n");
        if (obstacles == 2) {
            text.append("*.manager.launchConfig = xmldoc(\"" + scenario + ".launchd.xml\", \"/root/launch[@id='\" + (${withObstacles}==true ? \"with-obstacles\" : \"without-obstacles\") + \"']\")\n");
        } else {
            text.append("*.manager.launchConfig = xmldoc(\"" + scenario + ".launchd.xml\")\n");
        }
        text.append("\n");
        text.append("##########################################################\n");
        text.append("#                       RSU SETTINGS                     #\n");
        text.append("#                                                        #\n");
        text.append("#                                                        #\n");
        text.append("##########################################################\n");
        text.append("*.rsu[0].mobility.x = 0 + ${marginsumo}\n");
        text.append("*.rsu[0].mobility.y = 0 + ${marginsumo}\n");
        text.append("*.rsu[0].mobility.z = 50\n");
        text.append("*.rsu[*].applType = \"TraCIDemoRSU11p\"\n");
        text.append("*.rsu[*].appl.debug = false\n");
        text.append("*.rsu[*].appl.headerLength = 256 bit\n");
        text.append("*.rsu[*].appl.sendBeacons = false\n");
        text.append("*.rsu[*].appl.dataOnSch = false\n");
        text.append("*.rsu[*].appl.sendData = true\n");
        text.append("*.rsu[*].appl.beaconInterval = 1s\n");
        text.append("*.rsu[*].appl.beaconPriority = 3\n");
        text.append("*.rsu[*].appl.dataPriority = 2\n");
        text.append("*.rsu[*].appl.maxOffset = 0.005s\n");
        text.append("\n");
        text.append("##########################################################\n");
        text.append("#            11p specific parameters                     #\n");
        text.append("#                                                        #\n");
        text.append("#                    NIC-Settings                        #\n");
        text.append("##########################################################\n");
        text.append("*.connectionManager.pMax = 20mW\n");
        text.append("*.connectionManager.sat = -89dBm\n");
        text.append("*.connectionManager.alpha = 2.0\n");
        text.append("*.connectionManager.carrierFrequency = 5.890e9 Hz  # 5.89 GHz\n");
        text.append("*.connectionManager.drawMaxIntfDist = false\n");
        text.append("*.connectionManager.sendDirect = true\n");
        text.append("\n");
        text.append("*.**.nic.mac1609_4.txPower = 20mW\n");
        text.append("*.**.nic.phy80211p.sensitivity = -89dBm\n");
        text.append("*.**.nic.mac1609_4.bitrate = 18Mbps\n");
        text.append("*.**.nic.mac1609_4.useServiceChannel = false\n");
        text.append("*.**.nic.phy80211p.useThermalNoise = true\n");
        text.append("*.**.nic.phy80211p.thermalNoise = -110dBm\n");
        text.append("*.**.nic.phy80211p.decider = xmldoc(\"config.xml\", \"//Decider\")\n");
        if (obstacles == 0) {
            text.append("*.**.nic.phy80211p.analogueModels = xmldoc(\"config.xml\", \"//AnalogueModel[@type='SimplePathlossModel']\")\n");
        } else if (obstacles == 1) {
            text.append("*.**.nic.phy80211p.analogueModels = xmldoc(\"config.xml\", \"//AnalogueModel[@type='SimpleObstacleShadowing']\")\n");
        } else {
            text.append("*.**.nic.phy80211p.analogueModels = xmldoc(\"config.xml\", (${withObstacles}==true ? \"//AnalogueModel[@type='SimpleObstacleShadowing']\" : \"//AnalogueModel[@type='SimplePathlossModel']\"))\n");
        }
        text.append("*.**.nic.phy80211p.usePropagationDelay = true\n");
        text.append("\n");
        text.append("##########################################################\n");
        text.append("#                    WaveAppLayer                        #\n");
        text.append("##########################################################\n");
        text.append("*." + moduleName + "[*].applType = \"TraCIDemo11p\"\n");
        text.append("*." + moduleName + "[*].appl.debug = false\n");
        text.append("*." + moduleName + "[*].appl.headerLength = 256 bit\n");
        text.append("*." + moduleName + "[*].appl.sendBeacons = false\n");
        text.append("*." + moduleName + "[*].appl.dataOnSch = false\n");
        text.append("*." + moduleName + "[*].appl.sendData = true\n");
        text.append("*." + moduleName + "[*].appl.beaconInterval = 1s\n");
        text.append("*." + moduleName + "[*].appl.beaconPriority = 3\n");
        text.append("*." + moduleName + "[*].appl.dataPriority = 2\n");
        text.append("*." + moduleName + "[*].appl.maxOffset = 0.005s\n");
        text.append("\n");
        text.append("##########################################################\n");
        text.append("#                      Mobility                          #\n");
        text.append("##########################################################\n");
        text.append("*." + moduleName + "[*].veinsmobilityType = \"org.car2x.veins.modules.mobility.traci.TraCIMobility\"\n");
        text.append("*." + moduleName + "[*].mobilityType = \"TraCIMobility\"\n");
        text.append("*." + moduleName + "e[*].mobilityType.debug = true\n");
        text.append("*." + moduleName + "[*].veinsmobilityType.debug = true\n");
        text.append("*." + moduleName + "[*].veinsmobility.x = 0\n");
        text.append("*." + moduleName + "[*].veinsmobility.y = 0\n");
        text.append("*." + moduleName + "[*].veinsmobility.z = 1.895\n");
        text.append("*." + moduleName + "[*0].veinsmobility.accidentCount = 1\n");
        text.append("*." + moduleName + "[*0].veinsmobility.accidentStart = 75s\n");
        text.append("*." + moduleName + "[*0].veinsmobility.accidentDuration = 30s\n");
        text.append("\n");
        text.append("[Config nodebug]\n");
        text.append("description = \"default settings\"\n");
        text.append("**.debug = false\n");
        text.append("**.coreDebug = false\n");
        text.append("#*.annotations.draw = false\n");
        text.append("\n");
        text.append("[Config debug]\n");
        text.append("description = \"(very slow!) draw and print additional debug information\"\n");
        text.append("**.debug = true\n");
        text.append("**.coreDebug = true\n");
        text.append("#*.annotations.draw = true\n");
        text.append("\n");
        this.txtFile4.setText(text.toString());
        ok = Util.writeTextFile(filename, text.toString());
        return ok;
    }

    private boolean generateFileScript(String filename, String scenario) {
        boolean ok = true;
        StringBuilder text = new StringBuilder();
        text.append("#!/bin/bash\n");
        text.append("# ----------------------------------------------------------\n");
        text.append("# File: " + filename + " <config> [first-run last-run [cores]]\n");
        text.append("#\n");
        text.append("# Arguments:\n");
        text.append("#   1 - configuration name in omnetpp.ini file (mandatory)\n");
        text.append("#   2 - first run to execute; 0-based\n");
        text.append("#   3 - last run to execute\n");
        text.append("#   4 - number of cores; 2 by default\n");
        text.append("#\n");
        text.append("# NOTE: This script assumes a directory structure like this:\n");
        text.append("#    OMNET_WORKSPACE_PATH > PRJ_NAME > simulations > helloworld\n");
        text.append("#    where 'helloworld' is the working directory.\n");
        text.append("#    The directory names are got automatically, but if the\n");
        text.append("#    directory structure is different, it is necessary to modify\n");
        text.append("#    the environment variables PRJ_NAME and OMNET_WORKSPACE_PATH\n");
        text.append("#    by adding or removing some 'cd ..' below.\n");
        text.append("# ----------------------------------------------------------\n\n");
        text.append("if [ $# -eq 0 ] || [ $# -gt 4 ]; then\n");
        text.append("   echo \"Error in arguments supplied; please, specify the following arguments:\"\n");
        text.append("   echo \"  1 - configuration name in omnetpp.ini file\"\n");
        text.append("   echo \"  2 - first run to execute; 0-based\"\n");
        text.append("   echo \"  3 - last run to execute\"\n");
        text.append("   echo \"  4 - number of cores; 2 by default\"\n");
        text.append("   exit 1\n");
        text.append("fi\n\n");
        text.append("THISHOST=$(hostname -f)\n\n");
        text.append("# Executable name of the debugger\n");
        if (Util.isMac()) {
            text.append("GDB=ggdb\n\n");
        } else {
            text.append("GDB=gdb\n\n");
        }
        text.append("# Simulation name\n");
        text.append("SIM_NAME=${PWD##*/}\n");
        text.append("# Project name\n");
        text.append("PRJ_NAME=$(basename \"$(dirname `cd .. && pwd`)\")\n");
        text.append("# Workspace\n");
        text.append("OMNET_WORKSPACE_PATH=$(dirname `cd .. && cd .. && pwd`)\n");
        text.append("# Other paths\n");
        text.append("PATH_PRJ=$OMNET_WORKSPACE_PATH/$PRJ_NAME\n");
        text.append("PATH_PRJ_SRC=$PATH_PRJ/src\n");
        text.append("PATH_PRJ_SIMS=$PATH_PRJ/simulations\n");
        text.append("PATH_PRJ_SIM=$PATH_PRJ_SIMS/$SIM_NAME\n");
        text.append("PATH_PRJ_SIM_RESULTS=$PATH_PRJ_SIM/results\n");
        text.append("PATH_PRJ_VEINS=$OMNET_WORKSPACE_PATH/veins/src/veins\n\n");
        text.append("EXE=$PATH_PRJ_SRC/$PRJ_NAME\n");
        text.append("EXE_LN=$PATH_PRJ_SIM/$PRJ_NAME\n\n");
        text.append("# -------------------------------------\n");
        text.append("# Show paths before running the simulations\n");
        text.append("# -------------------------------------\n");
        text.append("function show_paths() {\n");
        text.append("   NUMRUNS=$(($LASTRUN - $FIRSTRUN + 1))\n");
        text.append("   echo \"---------------------------\"\n");
        text.append("   echo \"Workspace    : $OMNET_WORKSPACE_PATH\"\n");
        text.append("   echo \"Veins source : $PATH_PRJ_VEINS\"\n");
        text.append("   echo \"Project path : $PATH_PRJ\"\n");
        text.append("   echo \"Results path : $PATH_PRJ_SIM_RESULTS\"\n");
        text.append("   echo \"Project name : $PRJ_NAME\"\n");
        text.append("   echo \"Simulation   : $SIM_NAME\"\n");
        text.append("   echo \"Configuration: $CONFIG\"\n");
        text.append("   echo \"Executable   : $EXE\"\n");
        text.append("   if [ $NUMRUNS -gt 0 ]; then\n");
        text.append("      echo \"Runs         : $FIRSTRUN..$LASTRUN --> total $NUMRUNS\"\n");
        text.append("   fi\n");
        text.append("   echo \"Cores        : $NUM_CORES\"\n");
        text.append("   echo \"---------------------------\"\n");
        text.append("   echo \"\"\n");
        text.append("}\n\n");
        text.append("# -------------------------------------\n");
        text.append("# Ask confirmation to launch the simulations\n");
        text.append("# -------------------------------------\n");
        text.append("function confirm() {\n");
        text.append("   read -n1 -r -p \"Press space to continue; any other key to abort ...\" key\n");
        text.append("   if [ \"$key\" = '' ]; then\n");
        text.append("      # Space pressed; echo [$key] is empty when SPACE is pressed\n");
        text.append("      echo \"Ok\"\n");
        text.append("   else\n");
        text.append("      # Anything else pressed; echo [$key] not empty\n");
        text.append("      echo \"Aborted by user!\"\n");
        text.append("      exit 1\n");
        text.append("   fi\n");
        text.append("}\n\n");
        text.append("# -------------------------------------\n");
        text.append("# Make a symbolic links (it it does not exists)\n");
        text.append("# -------------------------------------\n");
        text.append("function make_link_exe() {\n");
        text.append("   # Check if the executable file exists\n");
        text.append("   if [ ! -f $EXE ]; then\n");
        text.append("      echo \"ERROR: Executable file $EXE does not exist!\"\n");
        text.append("      exit 1\n");
        text.append("   fi\n");
        text.append("   # Remove the symbolic link to avoid problems when changing the host\n");
        text.append("   rm $EXE_LN\n");
        text.append("   # Creates the symbolic link to the executable\n");
        text.append("   if [ ! -f $EXE_LN ]; then\n");
        text.append("      ln -s $EXE $EXE_LN\n");
        text.append("   fi\n");
        text.append("}\n\n");
        text.append("# -------------------------------------\n");
        text.append("# Checks the number of executions fo the configuration\n");
        text.append("# Example:\n");
        text.append("# ../xxx -u Cmdenv -f ../omnetpp.ini -x exp1 -g \n");
        text.append("# -------------------------------------\n");
        text.append("function query_runs() {\n");
        text.append("   echo \"Runs of configuration $CONFIG ...\"\n");
        text.append("   (cd $PATH_PRJ_SRC && $EXE_LN -u Cmdenv -f $PATH_PRJ_SIM/omnetpp.ini -x $CONFIG -g)\n");
        text.append("   echo \"\"\n");
        text.append("}\n\n");
        text.append("# -------------------------------------\n");
        text.append("# Delete previous results\n");
        text.append("# Example:\n");
        text.append("# rm ../results/static0/*.vec ../results/static0/*.sca 2>/dev/null\n");
        text.append("# -------------------------------------\n");
        text.append("function delete_results() {\n");
        text.append("   echo \"Deleting previous results ...\"\n");
        text.append("   rm $PATH_PRJ_SIM_RESULTS/$CONFIG-*.sca 2>/dev/null\n");
        text.append("   rm $PATH_PRJ_SIM_RESULTS/$CONFIG-*.vci 2>/dev/null\n");
        text.append("   rm $PATH_PRJ_SIM_RESULTS/$CONFIG-*.vec 2>/dev/null\n");
        text.append("   echo \"\"\n");
        text.append("}\n\n");
        text.append("# -------------------------------------\n");
        text.append("# Run the simulations depending on the number of cores:\n");
        text.append("# - Secuentially:\n");
        text.append("#   xxx -u Cmdenv -f omnetpp.ini -c exp1 -r 0..2\n");
        text.append("# - In parallel:\n");
        text.append("#   opp_runall -j2 xxx -u Cmdenv -f omnetpp.ini -c exp1 -r 0..2\n");
        text.append("# -------------------------------------\n");
        text.append("function run_simulations() {\n");
        text.append("   # NEDPATH environment variable to find the .ned files\n");
        text.append("   export NEDPATH=$PATH_PRJ_VEINS:$PATH_PRJ_SRC:$PATH_PRJ_SIMS\n");
        text.append("   #echo \"NEDPATH = $NEDPATH\"\n\n");
        text.append("   COMMAND_RUN=\"$PRJ_NAME -u Cmdenv -f omnetpp.ini -c $CONFIG -r $FIRSTRUN..$LASTRUN\"\n\n");
        text.append("   # Set the working path to the parent directory and run\n");
        text.append("   if [ $NUM_CORES -le 1 ]; then\n");
        text.append("      echo \"Sequentially ...\"\n");
        text.append("      $COMMAND_RUN\n");
        text.append("   else\n");
        text.append("      echo \"In parallel ($NUM_CORES cores) ...\"\n");
        text.append("      # opp_runall -j1 ppp_qos -u Cmdenv -f omnetpp.ini -c exp1 -r 0..4\n");
        text.append("      opp_runall -j$NUM_CORES $COMMAND_RUN\n");
        text.append("   fi\n");
        text.append("}\n\n");
        text.append("# -------------------------------------\n");
        text.append("# For debugging (first run specified).\n");
        text.append("# NOTE: in the omnetpp.ini file we should write:\n");
        text.append("#    debug-on-errors = true\n");
        text.append("# When the gdb opens type 'run':\n");
        text.append("#    (gdb) run\n");
        text.append("# Alternative to avoid typying 'run':\n");
        text.append("#    ggdb -ex=run --args ...\n");
        text.append("# For quit from gdb type 'quit':\n");
        text.append("#    (gdb) quit\n");
        text.append("# -------------------------------------\n");
        text.append("function debug_simulation() {\n");
        text.append("   # Configuramos la variable de entorno NEDPATH para que encuentre archivos .ned\n");
        text.append("   export NEDPATH=$PATH_PRJ_VEINS:$PATH_PRJ_SRC:$PATH_PRJ_SIMS\n");
        text.append("   echo \"VEINS=$PATH_PRJ_VEINS\"\n");
        text.append("   echo \"NEDPATH=$NEDPATH\"\n\n");
        text.append("   (cd .. && $GDB -ex=run --args $PRJ_NAME -u Cmdenv -f omnetpp.ini -c $CONFIG -r $FIRSTRUN)\n");
        text.append("}\n\n");
        text.append("# -------------------------------------\n\n");
        text.append("# Arguments\n");
        text.append("CONFIG=$1\n");
        text.append("FIRSTRUN=$2\n");
        text.append("LASTRUN=$3\n");
        text.append("if [ $# -eq 4 ]; then\n");
        text.append("   NUM_CORES=$4\n");
        text.append("else\n");
        text.append("   NUM_CORES=2\n");
        text.append("fi\n\n");
        text.append("# Show paths\n");
        text.append("show_paths\n");
        text.append("# Makes link to the executable file\n");
        text.append("make_link_exe\n");
        text.append("# Show runs\n");
        text.append("query_runs\n\n");
        text.append("# Exit if only the configuration name was specified\n");
        text.append("if [ $# -lt 3 ]; then\n");
        text.append("   exit 0\n");
        text.append("fi\n\n");
        text.append("if [ $FIRSTRUN -gt $LASTRUN ]; then\n");
        text.append("   echo \"ERROR: first run $FIRSTRUN is greater than last run $LASTRUN!\"\n");
        text.append("   exit 1\n");
        text.append("fi\n\n");
        text.append("confirm\n");
        text.append("#delete_results\n\n");
        text.append("# The internal variable SECONDS is used to measure the real simulation time\n");
        text.append("SECONDS=0\n");
        text.append("#debug_simulation\n");
        text.append("run_simulations\n");
        text.append("echo \"Finished - $SECONDS seconds\"\n\n");
        ok = Util.writeTextFile(filename, text.toString());
        return ok;
    }

    private boolean generateFileScenario(String filename, String scenario) {
        boolean ok = true;
        StringBuilder text = new StringBuilder();
        text.append("// -----------------------------------------------------------------\n");
        text.append("// File: " + filename + "\n");
        text.append("//\n");
        text.append("// NOTES: it could be necessary to do the following:\n");
        text.append("// 1. To include this folder (or an upper one) in the list of\n");
        text.append("//    .ned folders from the project properties:\n");
        text.append("//        OMNeT++ > NED Source Folder.\n");
        text.append("// 2. To specify a 'package' line if there exist same package.ned\n");
        text.append("//    file in the working directory (or an upper one).\n");
        text.append("// -----------------------------------------------------------------\n");
        text.append("\n");
        text.append("package " + scenario + ".simulations." + scenario + ";\n");
        text.append("\n");
        text.append("import org.car2x.veins.nodes.RSU;\n");
        text.append("import org.car2x.veins.nodes.Scenario;\n");
        text.append("\n");
        text.append("network " + scenario + " extends Scenario\n");
        text.append("{\n");
        text.append("    parameters:\n");
        text.append("        @display(\"bgb=$playgroundSizeX,$playgroundSizeY\");\n");
        text.append("\n");
        text.append("        bool withObstacles = default(true);\n");
        text.append("\n");
        text.append("    submodules:\n");
        text.append("        rsu[1]: RSU {\n");
        text.append("            @display(\"p=150,140;b=10,10,oval\");\n");
        text.append("        }\n");
        text.append("\n");
        text.append("    connections allowunconnected:\n");
        text.append("}\n\n");
        ok = Util.writeTextFile(filename, text.toString());
        return ok;
    }
}

