/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.frontend;

import gatcomsumo.backend.NetworkType;
import gatcomsumo.backend.SUMO;
import gatcomsumo.frontend.DlgSelect;
import gatcomsumo.frontend.MyFrame;
import gatcomsumo.frontend.PanelAbstractGridNetwork;
import gatcomsumo.frontend.PanelAbstractRandomNetwork;
import gatcomsumo.frontend.PanelAbstractSpiderNetwork;
import gatcomsumo.frontend.PanelExternalOSM;
import gatcomsumo.frontend.PanelNetwork;
import gatcomsumo.frontend.Panel_NodesEdges;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import util.ExternalCommand;
import util.Util;

public class Panel_Network
extends JPanel
implements ItemListener,
KeyListener,
ActionListener {
    private MyFrame f;
    private String title;
    public SUMO sumo;
    private PanelNetwork[] panelGenerateNetwork;
    private PanelNetwork[] panelConvertNetwork;
    private Panel_NodesEdges pNodesEdges;
    private JTabbedPane tabpane;
    private CheckboxGroup cbNetworkTypeGroup;
    private Checkbox cbNetworkAbstract;
    private Checkbox cbNetworkImport;
    private JComboBox cbNetworkAbstractTypes;
    private JComboBox cbNetworkExternalFormats;
    private JLabel lblNetworkFile;
    private JLabel lblNetworkExt;
    private JLabel lblObstaclesFile;
    private JLabel lblObstaclesExt;
    private JLabel lblPath;
    public JTextField txtNetworkFile;
    public JTextField txtObstaclesFile;
    public JTextField txtPath;
    public JTextArea txtOutput;
    public JTextArea txtErrors;
    public JButton pbPath;
    public JButton pbSearch;
    public JButton pbLoadNetwork;
    public JButton pbObstacles;
    public JPanel pParams;
    public DlgSelect dlgSelectNode;
    public DlgSelect dlgSelectEdge;

    public Panel_Network(MyFrame f, String title, SUMO sumo) {
        int i;
        this.f = f;
        this.title = title;
        this.sumo = sumo;
        TitledBorder b = new TitledBorder(title);
        this.setBorder(b);
        JPanel pNorte = new JPanel();
        pNorte.setLayout(new GridLayout(5, 1));
        JPanel[] pNortes = new JPanel[5];
        for (int i2 = 0; i2 < pNortes.length; ++i2) {
            pNortes[i2] = new JPanel();
            pNortes[i2].setLayout(new BorderLayout());
            pNorte.add(pNortes[i2]);
        }
        this.lblNetworkFile = new JLabel("Network file:");
        this.txtNetworkFile = new JTextField("elche", 20);
        this.txtNetworkFile.setToolTipText("Network file (--output-file with netconvert)");
        this.txtNetworkFile.addKeyListener(this);
        this.lblNetworkExt = new JLabel(".net.xml");
        this.pbLoadNetwork = new JButton("Load Network");
        this.pbLoadNetwork.setToolTipText("Load the SUMO network file (.net.xml)");
        this.pbLoadNetwork.addActionListener(this);
        this.lblObstaclesFile = new JLabel("Obstacles file:");
        this.txtObstaclesFile = new JTextField("elche", 20);
        this.txtNetworkFile.setToolTipText("Obstacles file");
        this.lblObstaclesExt = new JLabel(".poly.xml");
        this.pbObstacles = new JButton("Create Obstacles");
        this.pbObstacles.setToolTipText("Extract obstacles from network file (polyconvert)");
        this.pbObstacles.addActionListener(this);
        this.cbNetworkTypeGroup = new CheckboxGroup();
        this.cbNetworkAbstract = new Checkbox("Abstract (netgen):", this.cbNetworkTypeGroup, true);
        this.cbNetworkAbstract.addItemListener(this);
        this.cbNetworkImport = new Checkbox("Import (netconvert):", this.cbNetworkTypeGroup, false);
        this.cbNetworkImport.addItemListener(this);
        this.lblPath = new JLabel("SUMO binaries path:");
        File path = SUMO.getPathBin();
        this.txtPath = new JTextField(path == null ? "" : "" + path.getPath(), 50);
        this.txtPath.setToolTipText("Path for SUMO tools (netgenerate, netconvert, polyconvert, ...)");
        this.txtPath.addKeyListener(this);
        this.checkSUMOPath();
        this.pbPath = new JButton("...");
        this.pbPath.setToolTipText("Select by hand the path for SUMO tools (netgenerate, netconvert, polyconvert, ...)");
        this.pbPath.addActionListener(this);
        ImageIcon icon = Util.cargarImagen("/images/", "Magnify.png");
        this.pbSearch = new JButton(icon);
        this.pbSearch.addActionListener(this);
        this.pbSearch.setToolTipText("Look for the SUMO path recursively from the PATH on the left");
        this.pParams = Util.createBorderPanel("Parameters");
        this.pParams.setLayout(new CardLayout());
        this.panelGenerateNetwork = new PanelNetwork[3];
        this.panelGenerateNetwork[0] = new PanelAbstractGridNetwork(f);
        this.panelGenerateNetwork[1] = new PanelAbstractSpiderNetwork(f);
        this.panelGenerateNetwork[2] = new PanelAbstractRandomNetwork(f);
        this.panelConvertNetwork = new PanelNetwork[1];
        this.panelConvertNetwork[0] = new PanelExternalOSM(f);
        for (i = 0; i < this.panelGenerateNetwork.length; ++i) {
            this.pParams.add((Component)this.panelGenerateNetwork[i], this.panelGenerateNetwork[i].toString());
            this.panelGenerateNetwork[i].setPreferredSize(new Dimension(200, 200));
        }
        for (i = 0; i < this.panelConvertNetwork.length; ++i) {
            this.pParams.add((Component)this.panelConvertNetwork[i], this.panelConvertNetwork[i].toString());
            this.panelConvertNetwork[i].setPreferredSize(new Dimension(200, 200));
        }
        this.cbNetworkAbstractTypes = new JComboBox<PanelNetwork>(this.panelGenerateNetwork);
        this.cbNetworkAbstractTypes.addItemListener(this);
        this.cbNetworkExternalFormats = new JComboBox<PanelNetwork>(this.panelConvertNetwork);
        this.cbNetworkExternalFormats.addItemListener(this);
        pNortes[0].add((Component)this.lblNetworkFile, "West");
        pNortes[0].add((Component)this.txtNetworkFile, "Center");
        JPanel p0aux = new JPanel();
        p0aux.setLayout(new FlowLayout());
        p0aux.add(this.lblNetworkExt);
        p0aux.add(this.pbLoadNetwork);
        pNortes[0].add((Component)p0aux, "East");
        pNortes[1].add((Component)this.lblObstaclesFile, "West");
        pNortes[1].add((Component)this.txtObstaclesFile, "Center");
        JPanel p1aux = new JPanel();
        p1aux.setLayout(new FlowLayout());
        p1aux.add(this.lblObstaclesExt);
        p1aux.add(this.pbObstacles);
        pNortes[1].add((Component)p1aux, "East");
        pNortes[2].add((Component)this.cbNetworkAbstract, "West");
        pNortes[2].add((Component)this.cbNetworkAbstractTypes, "Center");
        pNortes[3].add((Component)this.cbNetworkImport, "West");
        pNortes[3].add((Component)this.cbNetworkExternalFormats, "Center");
        pNortes[4].add((Component)this.lblPath, "West");
        pNortes[4].add((Component)this.txtPath, "Center");
        JPanel pEast = new JPanel();
        pEast.setLayout(new GridLayout(1, 2));
        pEast.add(this.pbPath);
        pEast.add(this.pbSearch);
        pNortes[4].add((Component)pEast, "East");
        Font fontCourier = new Font("Monospaced", 0, 11);
        JPanel pOutput = Util.createBorderPanel("Output");
        pOutput.setLayout(new BorderLayout());
        this.txtOutput = new JTextArea();
        this.txtOutput.setEditable(false);
        this.txtOutput.setFont(fontCourier);
        JScrollPane scrollPaneOutput = new JScrollPane(this.txtOutput);
        pOutput.add((Component)scrollPaneOutput, "Center");
        JPanel pErrors = Util.createBorderPanel("Errors");
        pErrors.setLayout(new BorderLayout());
        this.txtErrors = new JTextArea();
        this.txtErrors.setEditable(false);
        this.txtErrors.setFont(fontCourier);
        JScrollPane scrollPaneErrors = new JScrollPane(this.txtErrors);
        pErrors.add((Component)scrollPaneErrors, "Center");
        this.pNodesEdges = new Panel_NodesEdges(f, sumo);
        this.tabpane = new JTabbedPane();
        this.tabpane.setPreferredSize(new Dimension(200, 200));
        this.tabpane.addTab("Parameters", this.pParams);
        this.tabpane.addTab("Nodes & Edges", this.pNodesEdges);
        this.tabpane.addTab("Output", pOutput);
        this.tabpane.addTab("Errors", pErrors);
        this.setLayout(new BorderLayout());
        this.add((Component)pNorte, "North");
        this.add((Component)this.tabpane, "Center");
        this.cbNetworkImport.setState(true);
        this.cbNetworkExternalFormats.setSelectedIndex(0);
        this.showPanelNetwork();
    }

    public String getProjectName() {
        String s = this.txtNetworkFile.getText().trim();
        return s;
    }

    public String getNetworkFilename() {
        String s = this.txtNetworkFile.getText().trim() + ".net.xml";
        return s;
    }

    public String getObstaclesFilename() {
        String s = this.txtObstaclesFile.getText().trim() + ".poly.xml";
        return s;
    }

    public void setObstaclesFilename(String name) {
        this.txtObstaclesFile.setText(name);
    }

    private void showPanelNetwork() {
        CardLayout cl = (CardLayout)this.pParams.getLayout();
        PanelNetwork p = this.cbNetworkAbstract.getState() ? (PanelNetwork)this.cbNetworkAbstractTypes.getSelectedItem() : (PanelNetwork)this.cbNetworkExternalFormats.getSelectedItem();
        cl.show(this.pParams, p.toString());
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.cbNetworkAbstract || e.getSource() == this.cbNetworkAbstractTypes) {
            this.showPanelNetwork();
        } else if (e.getSource() == this.cbNetworkImport || e.getSource() == this.cbNetworkExternalFormats) {
            this.showPanelNetwork();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block20: {
            block21: {
                block23: {
                    String obstaclesfile;
                    block22: {
                        block19: {
                            if (e.getSource() != this.pbLoadNetwork) break block19;
                            String filename_net = this.getNetworkFilename();
                            String name = this.getProjectName();
                            File file = new File(filename_net);
                            if (file.exists() && file.isFile()) {
                                Util.setCursorEsperas(this);
                                this.f.sumo.init(name, NetworkType.UNKNOWN);
                                boolean ok = this.f.sumo.network.loadXML(filename_net);
                                Util.setCursorNormal(this);
                                if (!ok) {
                                    JOptionPane.showMessageDialog(this.f, "Error while loading the file '" + filename_net + "'!", "Load network", 0);
                                    return;
                                }
                                this.f.update();
                            } else {
                                JOptionPane.showMessageDialog(this.f, "File '" + filename_net + "' does not exist!", "Load network", 0);
                            }
                            break block20;
                        }
                        if (e.getSource() != this.pbObstacles) break block21;
                        String filename_poly = this.getObstaclesFilename();
                        if (!Util.overwriteFile(this.f, filename_poly)) {
                            return;
                        }
                        obstaclesfile = this.getObstaclesFilename();
                        if (!this.cbNetworkAbstract.getState()) break block22;
                        switch (this.cbNetworkAbstractTypes.getSelectedIndex()) {
                            case 0: {
                                int n;
                                PanelAbstractGridNetwork pGrid = (PanelAbstractGridNetwork)this.panelGenerateNetwork[0];
                                String command = pGrid.buildCommandObstacles(obstaclesfile);
                                Util.setCursorEsperas(this);
                                boolean ok = this.f.pNetwork.execCommandSUMO(command, "Creating obstacles ...", true);
                                Util.setCursorNormal(this);
                                if (ok && (n = JOptionPane.showConfirmDialog(this.f, "File '" + obstaclesfile + "' have been written.\nDo you want to append building as obstacles?", "Append building", 0)) == 0) {
                                    double offset = pGrid.offset;
                                    int margin = 10;
                                    Util.setCursorEsperas(this);
                                    pGrid.addPolygons(obstaclesfile, offset, margin);
                                    Util.setCursorNormal(this);
                                    JOptionPane.showMessageDialog(this.f, "Ok. Don't forget to remove or comment the\n<additional.../> </additional> section in the\n '" + obstaclesfile + "' file!!", "Append building", 1);
                                }
                                break block20;
                            }
                            case 1: {
                                JOptionPane.showMessageDialog(this.f, "Don't implemented", "Create obstacles file", 2);
                                return;
                            }
                            case 2: {
                                JOptionPane.showMessageDialog(this.f, "Don't implemented", "Create obstacles file", 2);
                                return;
                            }
                            default: {
                                return;
                            }
                        }
                    }
                    if (!this.cbNetworkImport.getState()) break block23;
                    switch (this.cbNetworkExternalFormats.getSelectedIndex()) {
                        case 0: {
                            PanelExternalOSM pOSM = (PanelExternalOSM)this.panelConvertNetwork[0];
                            String command = pOSM.buildCommandObstacles(obstaclesfile);
                            Util.setCursorEsperas(this);
                            boolean ok = this.f.pNetwork.execCommandSUMO(command, "Creating obstacles ...", true);
                            Util.setCursorNormal(this);
                            break block20;
                        }
                        case 1: {
                            JOptionPane.showMessageDialog(this.f, "Don't implemented", "Create obstacles file", 1);
                            return;
                        }
                        default: {
                            return;
                        }
                    }
                }
                return;
            }
            if (e.getSource() == this.pbPath) {
                this.changePath(this.f, this.txtPath, "SUMO tools path");
            } else if (e.getSource() == this.pbSearch) {
                String pathname = this.txtPath.getText();
                String filename = "sumo-gui" + (Util.isWindows() ? ".exe" : "");
                File sumoPath = Util.searchFile(filename, pathname);
                if (sumoPath != null) {
                    pathname = sumoPath.getParentFile().toString();
                    this.txtPath.setText(pathname);
                    this.checkSUMOPath();
                } else {
                    JOptionPane.showMessageDialog(this.f, "SUMO path not found from:\n" + pathname, "Warning", 2);
                }
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getSource() == this.txtNetworkFile) {
            String name = this.getProjectName();
            this.setObstaclesFilename(name);
            PanelExternalOSM pOSM = (PanelExternalOSM)this.panelConvertNetwork[0];
            pOSM.setNetworkName(name);
            this.f.pTrafficDemands.setNetworkName(name);
            this.f.pOmnet.setNetworkName(name);
            this.txtNetworkFile.setText(name);
        } else if (e.getSource() == this.txtPath) {
            this.checkSUMOPath();
        }
    }

    private boolean changePath(MyFrame frame, JTextField txt, String title) {
        File sel;
        File path = new File(txt.getText().trim());
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(title);
        chooser.setFileSelectionMode(1);
        chooser.setAcceptAllFileFilterUsed(true);
        chooser.setMultiSelectionEnabled(false);
        if (path.exists() && path.isDirectory()) {
            chooser.setCurrentDirectory(path.getParentFile());
            chooser.ensureFileIsVisible(path);
            chooser.setSelectedFile(path);
        }
        chooser.setAcceptAllFileFilterUsed(false);
        if (chooser.showOpenDialog(frame) == 0 && !(sel = chooser.getSelectedFile()).equals(path)) {
            txt.setText(sel.toString());
        }
        boolean ok = this.checkSUMOPath();
        return ok;
    }

    public boolean checkSUMOPath() {
        String pathsumo = this.txtPath.getText().trim();
        if (pathsumo.isEmpty()) {
            return true;
        }
        if (!pathsumo.endsWith(File.separator)) {
            pathsumo = pathsumo + File.separator;
        }
        String cmdfilename = pathsumo + "netconvert";
        if (Util.isWindows()) {
            cmdfilename = cmdfilename + ".exe";
        }
        File cmd = new File(cmdfilename);
        File path = new File(pathsumo);
        boolean ok = !path.exists() || !path.isDirectory() ? false : cmd.exists() && cmd.isFile();
        this.txtPath.setForeground(ok ? Color.BLACK : Color.RED);
        if (this.panelConvertNetwork != null) {
            String sumo_home_bin_str = this.txtPath.getText().trim();
            File sumo_home_bin = new File(sumo_home_bin_str);
            String sumo_home = sumo_home_bin.getParent();
            File pathTypeFile = SUMO.getFile_osmNetconvert(sumo_home);
            PanelExternalOSM pOSM = (PanelExternalOSM)this.panelConvertNetwork[0];
            pOSM.setTypeFile(pathTypeFile.getPath());
        }
        return ok;
    }

    public boolean execCommandSUMO(String cmd, String title, boolean clear) {
        String pathsumo = this.txtPath.getText().trim();
        if (!pathsumo.isEmpty()) {
            int pos;
            if (!pathsumo.endsWith(File.separator)) {
                pathsumo = pathsumo + File.separator;
            }
            cmd = (pos = pathsumo.indexOf(32)) < 0 ? pathsumo + cmd : ((pos = cmd.indexOf(32)) > 0 ? "\"" + pathsumo + cmd.substring(0, pos) + "\"" + cmd.substring(pos) : pathsumo + cmd);
        }
        File workingpath = Util.getCurrentPath();
        ExternalCommand worker = new ExternalCommand(workingpath, title, cmd, -1L, this.txtOutput, this.txtErrors, clear, false);
        worker.execute();
        boolean ok = worker.getSuccessful();
        return ok;
    }

    public void update() {
        this.dlgSelectNode = new DlgSelect((Window)this.f, "Node", null, this.sumo.network.nodes.list);
        this.dlgSelectEdge = new DlgSelect((Window)this.f, "Edge", null, this.sumo.network.edges.list);
    }
}

