/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.frontend;

import java.awt.FlowLayout;
import java.awt.event.KeyListener;
import java.text.DecimalFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import util.gps.GeodeticCoordinates;

public class Panel_LatLong
extends JPanel {
    private static final DecimalFormat F7DEC = new DecimalFormat("###0.0000000");
    private JLabel lblLat;
    private JLabel lblLon;
    private JTextField txtLat;
    private JTextField txtLon;

    public Panel_LatLong(String title, boolean enabled, KeyListener listener) {
        if (title != null && !title.isEmpty()) {
            TitledBorder b = new TitledBorder(title);
            this.setBorder(b);
        }
        this.setLayout(new FlowLayout(0));
        this.lblLat = new JLabel("Latitude: ");
        this.txtLat = new JTextField("", 15);
        this.txtLat.setToolTipText("Latitude (-90..+90)");
        this.txtLat.setHorizontalAlignment(4);
        if (!enabled) {
            this.txtLat.setEditable(false);
        } else if (listener != null) {
            this.txtLat.addKeyListener(listener);
        }
        this.lblLon = new JLabel("Longitude: ");
        this.txtLon = new JTextField("", 15);
        this.txtLon.setToolTipText("Longitude (-180..+180)");
        this.txtLon.setHorizontalAlignment(4);
        if (!enabled) {
            this.txtLon.setEditable(false);
        } else if (listener != null) {
            this.txtLon.addKeyListener(listener);
        }
        this.add(this.lblLat);
        this.add(this.txtLat);
        this.add(this.lblLon);
        this.add(this.txtLon);
    }

    public void setValues(GeodeticCoordinates geo) {
        this.txtLat.setText(geo.getLatitude());
        this.txtLon.setText(geo.getLongitude());
    }

    public GeodeticCoordinates getValues() {
        double lon;
        double lat;
        String value = this.txtLat.getText().trim();
        value = value.replace(',', '.');
        try {
            lat = Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
        value = this.txtLon.getText().trim();
        value = value.replace(',', '.');
        try {
            lon = Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
        GeodeticCoordinates geo = new GeodeticCoordinates(lat, lon);
        return geo;
    }
}

