/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.frontend;

import gatcomsumo.backend.SUMO;
import gatcomsumo.frontend.MyFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableColumn;
import util.Util;
import util.gui.MyTable;

public class Panel_GenericTable
extends JPanel
implements ActionListener,
MyTable.Listener {
    protected MyFrame f;
    protected String title;
    protected SUMO sumo;
    private JPanel pTable;
    public MyTable table;
    protected JButton bAdd;
    protected JButton bRemove;
    protected JButton bEdit;
    protected JButton bLoad;
    protected JButton bSave;
    private ArrayList<MyListener> listeners = new ArrayList();

    public Panel_GenericTable(MyFrame f, String title, SUMO sumo, String[] cabeceras, int[] nonEditableCols) {
        this(f, title, sumo, cabeceras, nonEditableCols, true, true, true, false, false);
    }

    public Panel_GenericTable(MyFrame f, String title, SUMO sumo, String[] cabeceras, int[] nonEditableCols, boolean add, boolean remove, boolean edit, boolean load, boolean save) {
        this.f = f;
        this.title = title;
        this.sumo = sumo;
        this.pTable = Util.createBorderPanel(title);
        this.table = new MyTable(null, cabeceras, this, nonEditableCols);
        this.table.addListener(this);
        JPanel pButtons = new JPanel();
        pButtons.setLayout(new FlowLayout());
        if (add) {
            this.bAdd = new JButton("Add");
            this.bAdd.addActionListener(this);
            pButtons.add(this.bAdd);
        }
        if (remove) {
            this.bRemove = new JButton("Remove");
            this.bRemove.addActionListener(this);
            pButtons.add(this.bRemove);
        }
        if (edit) {
            this.bEdit = new JButton("Edit");
            this.bEdit.addActionListener(this);
            pButtons.add(this.bEdit);
        }
        if (load) {
            this.bLoad = new JButton("Load");
            this.bLoad.addActionListener(this);
            pButtons.add(this.bLoad);
        }
        if (save) {
            this.bSave = new JButton("Save");
            this.bSave.addActionListener(this);
            pButtons.add(this.bSave);
        }
        this.pTable.setLayout(new BorderLayout());
        this.pTable.add(this.table.scrollpane);
        if (pButtons.getComponentCount() > 0) {
            this.pTable.add((Component)pButtons, "South");
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.pTable, "Center");
        TableColumn columIndex = this.table.table.getColumn("#");
        if (columIndex != null) {
            columIndex.setWidth(30);
            columIndex.setMaxWidth(40);
        }
    }

    public void setTitle(String title) {
        TitledBorder b = new TitledBorder(title);
        this.pTable.setBorder(b);
    }

    public void addItem(Object[] item) {
        this.table.appendRow(item, true);
    }

    public void removeItem(int row) {
        this.table.removeRow(row);
    }

    public void updateItem(int row, Object[] item) {
        this.table.setData(row, item);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bAdd) {
            this.fireEventAdd();
            int nrows = this.table.getNumRows();
            if (nrows > 0) {
                this.table.selectRow(nrows - 1);
                this.fireEventEdit();
            }
        } else if (e.getSource() == this.bRemove) {
            if (this.table.getNumRows() > 0) {
                this.fireEventRemoveBefore();
                int index = this.table.getSelectedRow();
                this.table.removeRow(index);
                int nrows = this.table.getNumRows();
                if (nrows > 0) {
                    int nrow = index < nrows ? index : index - 1;
                    this.table.selectRow(nrow);
                }
                this.fireEventRemoveAfter();
            }
        } else if (e.getSource() == this.bEdit) {
            if (this.table.getNumRows() > 0) {
                this.fireEventEdit();
            }
        } else if (e.getSource() == this.bLoad) {
            this.fireEventLoad();
        } else if (e.getSource() == this.bSave) {
            this.fireEventSave();
        }
    }

    @Override
    public void rowSelected(MyTable.Event evt, int previousRow, int row, int numRows) {
        this.fireEventSelect();
    }

    @Override
    public void rowInserted(MyTable.Event evt, int row) {
    }

    @Override
    public void rowDeleted(MyTable.Event evt, int row) {
    }

    @Override
    public void rowUpdated(MyTable.Event evt, int row, int col, String value) {
    }

    public synchronized void addListener(MyListener listener) {
        this.listeners.add(listener);
    }

    private synchronized void fireEventAdd() {
        MyEvent event = new MyEvent(this);
        for (MyListener listener : this.listeners) {
            listener.addItem(event);
        }
    }

    private synchronized void fireEventRemoveBefore() {
        int index = this.table.getSelectedRow();
        MyEvent event = new MyEvent(this, index);
        for (MyListener listener : this.listeners) {
            listener.removeItemBefore(event, index);
        }
    }

    private synchronized void fireEventRemoveAfter() {
        int index = this.table.getSelectedRow();
        MyEvent event = new MyEvent(this, index);
        for (MyListener listener : this.listeners) {
            listener.removeItemAfter(event, index);
        }
    }

    private synchronized void fireEventEdit() {
        int index = this.table.getSelectedRow();
        MyEvent event = new MyEvent(this, index);
        for (MyListener listener : this.listeners) {
            listener.editItem(event, index);
        }
    }

    private synchronized void fireEventSelect() {
        int index = this.table.getSelectedRow();
        MyEvent event = new MyEvent(this, index);
        for (MyListener listener : this.listeners) {
            listener.selectItem(event, index);
        }
    }

    private synchronized void fireEventLoad() {
        int index = this.table.getSelectedRow();
        MyEvent event = new MyEvent(this, index);
        for (MyListener listener : this.listeners) {
            listener.load(event);
        }
    }

    private synchronized void fireEventSave() {
        int index = this.table.getSelectedRow();
        MyEvent event = new MyEvent(this, index);
        for (MyListener listener : this.listeners) {
            listener.save(event);
        }
    }

    static interface MyListener
    extends EventListener {
        public void addItem(MyEvent var1);

        public void removeItemBefore(MyEvent var1, int var2);

        public void removeItemAfter(MyEvent var1, int var2);

        public void editItem(MyEvent var1, int var2);

        public void selectItem(MyEvent var1, int var2);

        public boolean load(MyEvent var1);

        public boolean save(MyEvent var1);
    }

    class MyEvent
    extends EventObject {
        private int index;

        public MyEvent(Object source) {
            super(source);
        }

        public MyEvent(Object source, int index) {
            super(source);
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

