/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.frontend;

import gatcomsumo.backend.SUMO;
import gatcomsumo.frontend.MyFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.List;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import util.Util;

public class Panel_GenericList
extends JPanel
implements ActionListener,
ItemListener {
    protected MyFrame f;
    protected String title;
    protected SUMO sumo;
    private JPanel pList;
    public List list;
    protected JButton bAdd;
    protected JButton bRemove;
    protected JButton bEdit;
    protected JButton bLoad;
    protected JButton bSave;
    public ArrayList<MyListener> listeners = new ArrayList();

    public Panel_GenericList(MyFrame f, String title, SUMO sumo) {
        this(f, title, sumo, true, true, true, false, false);
    }

    public Panel_GenericList(MyFrame f, String title, SUMO sumo, boolean add, boolean remove, boolean edit, boolean load, boolean save) {
        this.f = f;
        this.title = title;
        this.sumo = sumo;
        this.pList = Util.createBorderPanel(title);
        this.list = new List();
        this.list.addItemListener(this);
        JPanel pButtons = new JPanel();
        pButtons.setLayout(new FlowLayout());
        if (add) {
            this.bAdd = new JButton("Add");
            this.bAdd.addActionListener(this);
            pButtons.add(this.bAdd);
        }
        if (remove) {
            this.bRemove = new JButton("Remove");
            this.bRemove.addActionListener(this);
            pButtons.add(this.bRemove);
        }
        if (edit) {
            this.bEdit = new JButton("Edit");
            this.bEdit.addActionListener(this);
            pButtons.add(this.bEdit);
        }
        if (load) {
            this.bLoad = new JButton("Load");
            this.bLoad.addActionListener(this);
            pButtons.add(this.bLoad);
        }
        if (save) {
            this.bSave = new JButton("Save");
            this.bSave.addActionListener(this);
            pButtons.add(this.bSave);
        }
        this.pList.setLayout(new BorderLayout());
        this.pList.add(this.list);
        if (pButtons.getComponentCount() > 0) {
            this.pList.add((Component)pButtons, "South");
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.pList, "Center");
    }

    public void setTitle(String title) {
        TitledBorder b = new TitledBorder(title);
        this.pList.setBorder(b);
    }

    public void addItem(String item) {
        this.list.add(item);
    }

    public void removeItem(String item) {
        this.list.remove(item);
    }

    public void removeItem(int index) {
        this.list.remove(index);
    }

    public void updateItem(int index, String item) {
        this.list.replaceItem(item, index);
        this.list.select(index);
    }

    public boolean selectAll() {
        if (!this.list.isMultipleMode()) {
            return false;
        }
        int n = this.list.getItemCount();
        for (int i = 0; i < n; ++i) {
            this.list.select(i);
        }
        return true;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.list) {
            this.fireEventSelect();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bAdd) {
            this.fireEventAdd();
            int nrows = this.list.getItemCount();
            if (nrows > 0) {
                this.list.select(nrows - 1);
                this.fireEventEdit();
            }
        } else if (e.getSource() == this.bRemove) {
            if (this.list.getItemCount() > 0) {
                int index = this.list.getSelectedIndex();
                this.list.remove(index);
                int nrows = this.list.getItemCount();
                if (nrows > 0) {
                    int nrow = index < nrows ? index : index - 1;
                    this.list.select(nrow);
                }
                this.fireEventRemoveBefore();
            }
        } else if (e.getSource() == this.bEdit) {
            if (this.list.getItemCount() > 0) {
                this.fireEventEdit();
            }
        } else if (e.getSource() == this.bLoad) {
            this.fireEventLoad();
        } else if (e.getSource() == this.bSave) {
            this.fireEventSave();
        }
    }

    public synchronized void addListener(MyListener listener) {
        this.listeners.add(listener);
    }

    private synchronized void fireEventAdd() {
        MyEvent event = new MyEvent(this);
        for (MyListener listener : this.listeners) {
            listener.addItem(event);
        }
    }

    private synchronized void fireEventRemoveBefore() {
        int index = this.list.getSelectedIndex();
        MyEvent event = new MyEvent(this, index);
        for (MyListener listener : this.listeners) {
            listener.removeItem(event, index);
        }
    }

    private synchronized void fireEventEdit() {
        int index = this.list.getSelectedIndex();
        MyEvent event = new MyEvent(this, index);
        for (MyListener listener : this.listeners) {
            listener.editItem(event, index);
        }
    }

    private synchronized void fireEventSelect() {
        int index = this.list.getSelectedIndex();
        MyEvent event = new MyEvent(this, index);
        for (MyListener listener : this.listeners) {
            listener.selectItem(event, index);
        }
    }

    private synchronized void fireEventLoad() {
        MyEvent event = new MyEvent(this, this.list.getSelectedIndex());
        for (MyListener listener : this.listeners) {
            listener.load(event);
        }
    }

    private synchronized void fireEventSave() {
        MyEvent event = new MyEvent(this, this.list.getSelectedIndex());
        for (MyListener listener : this.listeners) {
            listener.save(event);
        }
    }

    static interface MyListener
    extends EventListener {
        public void addItem(MyEvent var1);

        public void removeItem(MyEvent var1, int var2);

        public void editItem(MyEvent var1, int var2);

        public void selectItem(MyEvent var1, int var2);

        public boolean load(MyEvent var1);

        public boolean save(MyEvent var1);
    }

    class MyEvent
    extends EventObject {
        private int index;

        public MyEvent(Object source) {
            super(source);
        }

        public MyEvent(Object source, int index) {
            super(source);
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

