/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.frontend;

import gatcomsumo.backend.Flow;
import gatcomsumo.backend.SUMO;
import gatcomsumo.backend.VehicleType;
import gatcomsumo.frontend.DlgFlow;
import gatcomsumo.frontend.MyFrame;
import gatcomsumo.frontend.Panel_GenericTable;

public class Panel_Flows
extends Panel_GenericTable
implements Panel_GenericTable.MyListener {
    public Panel_Flows(MyFrame f, String title, SUMO sumo) {
        super(f, title, sumo, Flow.HEADERS, Flow.NONEDITABLECOLS, true, true, true, false, false);
        this.addListener(this);
    }

    @Override
    public void addItem(Panel_GenericTable.MyEvent e) {
        VehicleType type;
        int nrows;
        int row = nrows = this.table.getNumRows();
        int nFlows = this.sumo.trafficDemand.flows.list.size();
        int nVehicleTypes = this.sumo.trafficDemand.vehicletypes.list.size();
        if (nFlows == 0) {
            if (this.sumo.trafficDemand.vehicletypes.list.size() == 0) {
                type = new VehicleType(row + 1 + "");
                this.sumo.trafficDemand.vehicletypes.list.add(type);
            }
            type = this.sumo.trafficDemand.vehicletypes.list.get(0);
        } else {
            Flow flow = this.sumo.trafficDemand.flows.list.get(nFlows - 1);
            type = flow.type;
        }
        String prefix = this.sumo.trafficDemand.flows.getLastPrefix();
        int index = this.sumo.trafficDemand.flows.getLastIndex(prefix) + 1;
        String id = prefix + "-" + index;
        Flow flow = new Flow(id, type);
        this.sumo.trafficDemand.flows.list.add(flow);
        String item = flow.toString();
        Object[] data = flow.buildRowTable(row);
        this.table.appendRow(data, true);
        this.sumo.trafficDemand.setChanged(true);
    }

    @Override
    public void selectItem(Panel_GenericTable.MyEvent e, int index) {
    }

    @Override
    public void removeItemBefore(Panel_GenericTable.MyEvent e, int index) {
        Flow flow = this.sumo.trafficDemand.flows.list.get(index);
        if (flow.route != null) {
            flow.route.removeFlow(flow);
        }
        this.sumo.trafficDemand.flows.list.remove(index);
        this.sumo.trafficDemand.setChanged(true);
    }

    @Override
    public void removeItemAfter(Panel_GenericTable.MyEvent e, int index) {
        this.f.pTrafficDemands.pRoutes.update();
    }

    @Override
    public void editItem(Panel_GenericTable.MyEvent e, int index) {
        Flow flow = this.sumo.trafficDemand.flows.list.get(index);
        DlgFlow dlg = new DlgFlow(this.f, this.sumo, this.title, flow);
        dlg.setVisible(true);
        if (!dlg.isCanceled()) {
            Object[] data = flow.buildRowTable(index);
            this.updateItem(index, data);
            if (dlg.routesModified()) {
                this.f.pTrafficDemands.pRoutes.update();
            }
            this.sumo.trafficDemand.setChanged(true);
        }
    }

    public void update() {
        int row = 0;
        this.table.removeAllRows();
        for (Flow item : this.sumo.trafficDemand.flows.list) {
            Object[] data = item.buildRowTable(row);
            this.table.appendRow(data, true);
            ++row;
        }
        if (this.table.getNumRows() > 0) {
            this.table.selectRow(0);
        }
    }

    @Override
    public boolean load(Panel_GenericTable.MyEvent e) {
        return true;
    }

    @Override
    public boolean save(Panel_GenericTable.MyEvent e) {
        return true;
    }
}

