/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.frontend;

import gatcomsumo.backend.Flow;
import gatcomsumo.backend.Route;
import gatcomsumo.backend.Routes;
import gatcomsumo.backend.SUMO;
import gatcomsumo.backend.VehicleType;
import gatcomsumo.frontend.MyFrame;
import gatcomsumo.frontend.Panel_Time;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import util.Colors;

class Panel_Flow
extends JPanel
implements ItemListener {
    private MyFrame f;
    private SUMO sumo;
    private JLabel lblID;
    private JLabel lblType;
    private JLabel lblColor;
    private JLabel lblRoute;
    private JLabel lblVehicles;
    private JLabel lblNumber;
    private JLabel lblFrecuency;
    private JLabel lblBegin;
    private JLabel lblEnd;
    JTextField txtID;
    JTextField txtNumber;
    JTextField txtFrecuency;
    JTextArea txtRouteEdges;
    JComboBox cbType;
    JComboBox cbColor;
    JComboBox cbRoute;
    JComboBox cbFrecuency;
    Panel_Time pBegin;
    Panel_Time pEnd;
    private JPanel pIzq;
    private JPanel pCentro;
    private JPanel pVehicles;
    public boolean routesMod;

    public Panel_Flow(MyFrame f, SUMO sumo) {
        this.f = f;
        this.sumo = sumo;
        this.setLayout(new BorderLayout());
        this.pIzq = new JPanel();
        this.pIzq.setLayout(new GridLayout(8, 1));
        this.pCentro = new JPanel();
        this.pCentro.setLayout(new GridLayout(8, 1));
        this.add((Component)this.pIzq, "West");
        this.add((Component)this.pCentro, "Center");
        this.lblID = new JLabel("ID:");
        this.txtID = new JTextField("", 10);
        this.pIzq.add(this.lblID);
        this.pCentro.add(this.txtID);
        this.lblType = new JLabel("Type:");
        this.cbType = new JComboBox<Object>(sumo.trafficDemand.vehicletypes.list.toArray());
        VehicleType defaultType = sumo.trafficDemand.vehicletypes.search("passenger");
        this.cbType.setSelectedItem(defaultType);
        this.pIzq.add(this.lblType);
        this.pCentro.add(this.cbType);
        this.lblColor = new JLabel("Color:");
        this.cbColor = new JComboBox<Colors>(Colors.values());
        this.cbColor.setSelectedItem((Object)Colors.YELLOW);
        this.pIzq.add(this.lblColor);
        this.pCentro.add(this.cbColor);
        this.lblRoute = new JLabel("Route:");
        this.cbRoute = new JComboBox<Object>(sumo.trafficDemand.routes.list.toArray());
        this.cbRoute.insertItemAt(Routes.routeNull, 0);
        this.cbRoute.addItemListener(this);
        this.txtRouteEdges = new JTextArea(1, 30);
        this.txtRouteEdges.setLineWrap(true);
        this.txtRouteEdges.setWrapStyleWord(true);
        this.txtRouteEdges.setEditable(false);
        this.txtRouteEdges.setPreferredSize(new Dimension(150, 1));
        this.pIzq.add(this.lblRoute);
        this.pCentro.add(this.cbRoute);
        this.pIzq.add(new JLabel(""));
        this.pCentro.add(this.txtRouteEdges);
        this.lblBegin = new JLabel("Begin:");
        this.pBegin = new Panel_Time();
        this.lblEnd = new JLabel("End:");
        this.pEnd = new Panel_Time();
        this.pIzq.add(this.lblBegin);
        this.pIzq.add(this.lblEnd);
        this.pCentro.add(this.pBegin);
        this.pCentro.add(this.pEnd);
        this.lblVehicles = new JLabel("Vehicles:");
        this.pVehicles = new JPanel();
        this.pVehicles.setLayout(new FlowLayout(0));
        this.lblNumber = new JLabel("Number:");
        this.txtNumber = new JTextField("1", 3);
        this.txtNumber.setToolTipText("Total number of vehicles of the flow");
        this.lblFrecuency = new JLabel("Frecuency:");
        this.cbFrecuency = new JComboBox<String>(Flow.FREQUENCY_FORMS);
        this.cbFrecuency.setToolTipText("Number of vehicles per hour vs. Period for inserting vs. Probability for emitting a vehicle each second; if used, the end parameter will be ignored.");
        this.txtFrecuency = new JTextField("0", 3);
        this.txtFrecuency.setToolTipText("Parameter for frecuency selected; if used, the end parameter will be ignored.");
        this.pVehicles.add(this.lblNumber);
        this.pVehicles.add(this.txtNumber);
        this.pVehicles.add(this.lblFrecuency);
        this.pVehicles.add(this.cbFrecuency);
        this.pVehicles.add(this.txtFrecuency);
        this.pIzq.add(this.lblVehicles);
        this.pCentro.add(this.pVehicles);
        this.routesMod = false;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.cbRoute) {
            this.routesMod = true;
            this.updateRoute();
        }
    }

    private void updateRoute() {
        Route route = (Route)this.cbRoute.getSelectedItem();
        if (route != null) {
            this.txtRouteEdges.setText(route.getEdges());
        }
    }
}

