/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.frontend;

import gatcomsumo.backend.NetworkBBox;
import gatcomsumo.frontend.Panel_LatLong;
import gatcomsumo.frontend.Panel_UTM;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.geom.Rectangle2D;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import util.Util;
import util.gps.GeodeticCoordinates;
import util.gps.LatLongUTM;
import util.gps.UTMCoordinates;

public class Panel_BBox
extends JPanel
implements ItemListener,
KeyListener {
    public static final NetworkBBox[] EXAMPLES = new NetworkBBox[]{new NetworkBBox("Elche", null, 38.26615f, -0.69742f, 38.2831f, -0.67708f), new NetworkBBox("Kiev", null, 50.42609405517578, 30.4928035736084, 50.45496368408203, 30.544841766357422)};
    private JPanel pBoundingBox;
    private JPanel pUTM;
    private JPanel pLatLon;
    public Panel_UTM pUTM_SW;
    public Panel_UTM pUTM_NE;
    public Panel_LatLong pLatLon_SW;
    public Panel_LatLong pLatLon_NE;
    private JLabel lblCoord;
    private JLabel lblExamples;
    private JLabel lblWidth;
    private JLabel lblHeight;
    public JTextField txtWidth;
    public JTextField txtHeight;
    public JComboBox cbFormat;
    public JComboBox cbCoord;
    public JComboBox cbExamples;

    public Panel_BBox() {
        this(null, null);
    }

    public Panel_BBox(NetworkBBox bbox1, NetworkBBox bbox2) {
        JPanel pExamples = Util.createBorderPanel(" Predefined Bounding Boxes ");
        pExamples.setLayout(new FlowLayout(0));
        this.lblExamples = new JLabel("Bounding Box:");
        this.cbExamples = new JComboBox<NetworkBBox>(EXAMPLES);
        if (bbox1 != null) {
            this.cbExamples.addItem(bbox1);
        }
        if (bbox2 != null) {
            this.cbExamples.addItem(bbox2);
        }
        this.cbExamples.setSelectedIndex(0);
        this.cbExamples.addItemListener(this);
        this.lblCoord = new JLabel("Coordinates:");
        this.cbCoord = new JComboBox();
        this.cbCoord.addItem("UTM");
        this.cbCoord.addItem("Latitude-Longitude");
        this.cbCoord.addItemListener(this);
        pExamples.add(this.lblExamples);
        pExamples.add(this.cbExamples);
        pExamples.add(this.lblCoord);
        pExamples.add(this.cbCoord);
        JPanel pSize = Util.createBorderPanel(" Playground size ");
        pSize.setLayout(new FlowLayout(0));
        this.lblWidth = new JLabel("Width (m):");
        this.txtWidth = new JTextField("", 15);
        this.txtWidth.setHorizontalAlignment(4);
        this.txtWidth.setEnabled(false);
        this.lblHeight = new JLabel("Height (m):");
        this.txtHeight = new JTextField("", 15);
        this.txtHeight.setHorizontalAlignment(4);
        this.txtHeight.setEnabled(false);
        pSize.add(this.lblWidth);
        pSize.add(this.txtWidth);
        pSize.add(this.lblHeight);
        pSize.add(this.txtHeight);
        this.pBoundingBox = new JPanel();
        this.pUTM = new JPanel();
        this.pUTM_SW = new Panel_UTM(" South-West ", true, false, this);
        this.pUTM_NE = new Panel_UTM(" North-East ", true, false, this);
        this.pUTM.setLayout(new GridLayout(2, 1));
        this.pUTM.add(this.pUTM_SW);
        this.pUTM.add(this.pUTM_NE);
        this.pLatLon = new JPanel();
        this.pLatLon_SW = new Panel_LatLong(" South-West ", true, this);
        this.pLatLon_NE = new Panel_LatLong(" North-East ", true, this);
        this.pLatLon.setLayout(new GridLayout(2, 1));
        this.pLatLon.add(this.pLatLon_SW);
        this.pLatLon.add(this.pLatLon_NE);
        this.pBoundingBox.setLayout(new CardLayout());
        this.pBoundingBox.add((Component)this.pUTM, (String)this.cbCoord.getItemAt(0));
        this.pBoundingBox.add((Component)this.pLatLon, (String)this.cbCoord.getItemAt(1));
        this.setLayout(new BorderLayout());
        this.add((Component)pExamples, "North");
        this.add((Component)this.pBoundingBox, "Center");
        this.add((Component)pSize, "South");
        this.updateExample();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.cbCoord) {
            CardLayout cl = (CardLayout)this.pBoundingBox.getLayout();
            cl.show(this.pBoundingBox, this.cbCoord.getSelectedItem().toString());
        } else if (e.getSource() == this.cbExamples) {
            this.updateExample();
        }
    }

    public void computePlaygroundSize() {
        UTMCoordinates p1_utm = this.pUTM_NE.getValues();
        UTMCoordinates p2_utm = this.pUTM_SW.getValues();
        double width = Math.abs(p2_utm.x - p1_utm.x);
        double height = Math.abs(p2_utm.y - p1_utm.y);
        this.txtWidth.setText(String.format("%.2f", width));
        this.txtHeight.setText(String.format("%.2f", height));
    }

    private void updateExample() {
        NetworkBBox bbox = (NetworkBBox)this.cbExamples.getSelectedItem();
        this.pUTM_SW.setValues(bbox.utm_sw);
        this.pUTM_NE.setValues(bbox.utm_ne);
        this.pLatLon_SW.setValues(bbox.geo_sw);
        this.pLatLon_NE.setValues(bbox.geo_ne);
        this.computePlaygroundSize();
    }

    public void setBBox(UTMCoordinates utm_sw, UTMCoordinates utm_ne) {
        if (utm_sw == null || utm_ne == null) {
            return;
        }
        this.pUTM_SW.setValues(utm_sw);
        this.pUTM_NE.setValues(utm_ne);
        GeodeticCoordinates geo_sw = LatLongUTM.UTMtoLL(23, utm_sw);
        GeodeticCoordinates geo_ne = LatLongUTM.UTMtoLL(23, utm_ne);
        this.pLatLon_SW.setValues(geo_sw);
        this.pLatLon_NE.setValues(geo_ne);
        this.computePlaygroundSize();
    }

    public void setBBox(GeodeticCoordinates geo_sw, GeodeticCoordinates geo_ne) {
        if (geo_sw == null || geo_ne == null) {
            return;
        }
        this.pLatLon_SW.setValues(geo_sw);
        this.pLatLon_NE.setValues(geo_ne);
        UTMCoordinates utm_sw = LatLongUTM.LLtoUTM(23, geo_sw);
        UTMCoordinates utm_ne = LatLongUTM.LLtoUTM(23, geo_ne);
        this.pUTM_SW.setValues(utm_sw);
        this.pUTM_NE.setValues(utm_ne);
        this.computePlaygroundSize();
    }

    public UTMCoordinates getBBox_utm_sw() {
        UTMCoordinates utm_sw;
        int coord = this.cbCoord.getSelectedIndex();
        if (coord == 0) {
            utm_sw = this.pUTM_SW.getValues();
        } else {
            GeodeticCoordinates geo_sw = this.pLatLon_SW.getValues();
            utm_sw = LatLongUTM.LLtoUTM(23, geo_sw);
        }
        return utm_sw;
    }

    public UTMCoordinates getBBox_utm_ne() {
        UTMCoordinates utm_ne;
        int coord = this.cbCoord.getSelectedIndex();
        if (coord == 0) {
            utm_ne = this.pUTM_NE.getValues();
        } else {
            GeodeticCoordinates geo_ne = this.pLatLon_NE.getValues();
            utm_ne = LatLongUTM.LLtoUTM(23, geo_ne);
        }
        return utm_ne;
    }

    public Rectangle2D.Double getBBox(double margin) {
        UTMCoordinates utm_ne;
        UTMCoordinates utm_sw;
        int coord = this.cbCoord.getSelectedIndex();
        if (coord == 0) {
            utm_sw = this.pUTM_SW.getValues();
            utm_ne = this.pUTM_NE.getValues();
        } else {
            GeodeticCoordinates geo_sw = this.pLatLon_SW.getValues();
            GeodeticCoordinates geo_ne = this.pLatLon_NE.getValues();
            utm_sw = LatLongUTM.LLtoUTM(23, geo_sw);
            utm_ne = LatLongUTM.LLtoUTM(23, geo_ne);
        }
        Rectangle2D.Double bbox = this.computeBBox(utm_sw, utm_ne, margin);
        return bbox;
    }

    private Rectangle2D.Double computeBBox(UTMCoordinates utm_sw, UTMCoordinates utm_ne, double margin) {
        Rectangle2D.Double bbox = new Rectangle2D.Double();
        bbox.x = Math.min(utm_sw.x, utm_ne.x) - margin;
        bbox.y = Math.min(utm_sw.y, utm_ne.y) - margin;
        bbox.width = Math.abs(utm_sw.x - utm_ne.x) + margin * 2.0;
        bbox.height = Math.abs(utm_sw.y - utm_ne.y) + margin * 2.0;
        return bbox;
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.computePlaygroundSize();
    }
}

