/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.frontend;

import gatcomsumo.backend.Edge;
import gatcomsumo.backend.Node;
import gatcomsumo.backend.Route;
import gatcomsumo.backend.SUMO;
import gatcomsumo.frontend.MiCanvas;
import gatcomsumo.frontend.MyFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

class PanelSearch
extends JPanel
implements ItemListener {
    MyFrame f;
    SUMO sumo;
    MiCanvas canvas;
    JComboBox cbSearchNode;
    JComboBox cbSearchEdge;
    JComboBox cbSearchRoute;
    JCheckBox cbVisibleNodes;
    JCheckBox cbVisibleEdges;
    JCheckBox cbVisibleRoutes;

    public PanelSearch(MyFrame f, SUMO sumo, MiCanvas canvas) {
        this.f = f;
        this.sumo = sumo;
        this.canvas = canvas;
        TitledBorder b = new TitledBorder(" Search objects ");
        this.setBorder(b);
        JPanel pNodes = new JPanel();
        pNodes.setLayout(new BorderLayout());
        this.cbSearchNode = new JComboBox();
        this.cbVisibleNodes = new JCheckBox("Nodes:", true);
        this.cbSearchNode.addItemListener(this);
        this.cbVisibleNodes.addItemListener(this);
        pNodes.add((Component)this.cbVisibleNodes, "West");
        pNodes.add((Component)this.cbSearchNode, "Center");
        JPanel pEdges = new JPanel();
        pEdges.setLayout(new BorderLayout());
        this.cbSearchEdge = new JComboBox();
        this.cbVisibleEdges = new JCheckBox("Edges:", true);
        this.cbSearchEdge.addItemListener(this);
        this.cbVisibleEdges.addItemListener(this);
        pEdges.add((Component)this.cbVisibleEdges, "West");
        pEdges.add((Component)this.cbSearchEdge, "Center");
        JPanel pRoutes = new JPanel();
        pRoutes.setLayout(new BorderLayout());
        this.cbSearchRoute = new JComboBox();
        this.cbVisibleRoutes = new JCheckBox("Routes:", true);
        this.cbSearchRoute.addItemListener(this);
        this.cbVisibleRoutes.addItemListener(this);
        pRoutes.add((Component)this.cbVisibleRoutes, "West");
        pRoutes.add((Component)this.cbSearchRoute, "Center");
        this.setLayout(new GridLayout(1, 3));
        this.add(pNodes);
        this.add(pEdges);
        this.add(pRoutes);
        canvas.setShowNodes(this.cbVisibleNodes.isSelected());
        canvas.setShowEdges(this.cbVisibleEdges.isSelected());
        canvas.setShowRoutes(this.cbVisibleRoutes.isSelected());
        canvas.setShowSelected(null, null, null);
    }

    public void updateNetwork() {
        this.sumo.network.nodes.fill(this.cbSearchNode);
        this.sumo.network.edges.fill(this.cbSearchEdge);
        this.canvas.setShowSelected(null, null, null);
    }

    public void updateRoutes() {
        this.sumo.trafficDemand.routes.fill(this.cbSearchRoute);
        this.canvas.setShowSelected(null, null, null);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.cbSearchNode || e.getSource() == this.cbVisibleNodes) {
            boolean selected = this.cbVisibleNodes.isSelected();
            Node node = (Node)this.cbSearchNode.getSelectedItem();
            this.canvas.setShowNodes(selected);
            this.canvas.setShowSelected(selected ? node : null, null, null);
        } else if (e.getSource() == this.cbSearchEdge || e.getSource() == this.cbVisibleEdges) {
            boolean selected = this.cbVisibleEdges.isSelected();
            Edge edge = (Edge)this.cbSearchEdge.getSelectedItem();
            this.canvas.setShowEdges(selected);
            this.canvas.setShowSelected(null, selected ? edge : null, null);
        } else if (e.getSource() == this.cbSearchRoute || e.getSource() == this.cbVisibleRoutes) {
            boolean selected = this.cbVisibleRoutes.isSelected();
            Route route = (Route)this.cbSearchRoute.getSelectedItem();
            this.canvas.setShowRoutes(selected);
            this.canvas.setShowSelected(null, null, selected ? route : null);
        }
    }
}

