/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.frontend;

import gatcomsumo.backend.NetworkType;
import gatcomsumo.frontend.MyFrame;
import gatcomsumo.frontend.PanelNetwork;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import util.Util;

class PanelNativeSUMONetwork
extends PanelNetwork
implements ActionListener {
    private MyFrame f;
    private JLabel lblInputNodeFiles;
    private JLabel lblInputEdgeFiles;
    private JLabel lblInputConnectionFiles;
    private JLabel lblInputTypeFile;
    private JLabel lblOptions;
    private JTextField txtInputNodeFiles;
    private JTextField txtInputEdgeFiles;
    private JTextField txtInputConnectionFiles;
    private JTextField txtInputTypeFile;
    private JTextField txtOptions;
    private JButton pbNetwork;
    String name;

    public PanelNativeSUMONetwork(MyFrame f) {
        this.f = f;
        this.setLayout(new BorderLayout());
        this.lblInputNodeFiles = new JLabel("TO-DO");
        Font font = new Font("TimesRoman", 1, 25);
        this.lblInputNodeFiles.setFont(font);
        this.lblInputNodeFiles.setForeground(Color.red);
        this.add((Component)this.lblInputNodeFiles, "Center");
        JPanel pSur = new JPanel();
        this.pbNetwork = new JButton("Create Network");
        this.pbNetwork.setToolTipText("Generate a SUMO network file (.net.xml) and load it");
        this.pbNetwork.addActionListener(this);
        pSur.setLayout(new FlowLayout(2));
        pSur.add(this.pbNetwork);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.pbNetwork) {
            String name = this.f.pNetwork.getProjectName();
            String filename_net = "native.net.xml";
            if (!Util.overwriteFile(this.f, filename_net)) {
                return;
            }
            String command = this.buildCommand(filename_net);
            boolean ok = this.f.pNetwork.execCommandSUMO(command, "Creating network ...", true);
            if (ok) {
                this.f.sumo.init(name, NetworkType.NATIVE_SUMO);
                this.f.pNetwork.sumo.network.loadXML(filename_net);
                this.f.update();
            }
        }
    }

    @Override
    public String buildCommand(String filename_net) {
        String cmd = "netconvert";
        cmd = cmd + " --output-file " + filename_net;
        return cmd;
    }

    @Override
    public String toString() {
        return "SUMO Native";
    }
}

