/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.frontend;

import gatcomsumo.backend.SUMO;
import gatcomsumo.frontend.DlgOSMDownload;
import gatcomsumo.frontend.MyFrame;
import gatcomsumo.frontend.PanelNetwork;
import gatcomsumo.osm.OpenStreetMap;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import util.Util;

class PanelExternalOSM
extends PanelNetwork
implements ActionListener,
ItemListener,
KeyListener {
    private MyFrame f;
    private OpenStreetMap osm;
    private JLabel lblOSMFile;
    private JLabel lblOSMExt;
    private JLabel lblPathTypeFiles;
    private JLabel lblOptions;
    private JTextField txtOSMFile;
    private JTextField txtPathTypeFiles;
    private JTextField txtOptions;
    private JTextField txtIgnoreEdges;
    private JButton pbDownload;
    private JButton pbConvert;
    private JCheckBox cbIgnoreEdges;
    String sOSMFile;
    String sNetworkFile;
    String sPathTypeFiles;
    String sOptions;
    String sIgnoreEdges;

    public PanelExternalOSM(MyFrame f) {
        this.f = f;
        this.osm = new OpenStreetMap();
        JPanel pLeft = new JPanel();
        pLeft.setLayout(new GridLayout(5, 1));
        this.lblOSMFile = new JLabel("OSM file:");
        this.lblPathTypeFiles = new JLabel("Path Type file(s):");
        this.lblOptions = new JLabel("Additional options:");
        this.cbIgnoreEdges = new JCheckBox("Ignore edges:", true);
        this.cbIgnoreEdges.addItemListener(this);
        JPanel pCenter = new JPanel();
        pCenter.setLayout(new GridLayout(5, 1));
        this.txtOSMFile = new JTextField("elche", 20);
        this.txtOSMFile.setToolTipText("Input Network File (--osm-files)");
        this.lblOSMExt = new JLabel(".osm.xml");
        this.pbDownload = new JButton("Download ...");
        this.pbDownload.setToolTipText("Download map from OpenStreetMap and save it to a .osm.xml file");
        this.pbDownload.addActionListener(this);
        this.pbConvert = new JButton("Convert");
        this.pbConvert.setToolTipText("Convert OSM file (.osm.xml) to SUMO network file (.net.xml)");
        this.pbConvert.addActionListener(this);
        File pathTypeFile = SUMO.getFile_osmNetconvert();
        this.txtPathTypeFiles = new JTextField(pathTypeFile.getPath());
        this.txtPathTypeFiles.setToolTipText("Read XML-type defs from FILE (--type-files)");
        this.txtPathTypeFiles.addKeyListener(this);
        this.txtOptions = new JTextField("--geometry.remove --roundabouts.guess --ramps.guess --junctions.join --tls.guess-signals --tls.discard-simple --tls.join --no-internal-links");
        this.txtOptions.setToolTipText("Additional options passed to \"netconvert\"");
        this.txtIgnoreEdges = new JTextField("--remove-edges.by-type rail,rail_urban,rail_electric,railway.tram,railway.subway --remove-edges.by-vclass rail,rail_electric,bicycle,pedestrian");
        this.txtIgnoreEdges.setToolTipText("Additional options passed to \"netconvert\" related to edges to be removed");
        JPanel pCenterOSM = new JPanel();
        pCenterOSM.setLayout(new BorderLayout());
        pCenterOSM.add((Component)this.txtOSMFile, "Center");
        JPanel pOSMaux = new JPanel();
        pOSMaux.setLayout(new FlowLayout());
        pOSMaux.add(this.lblOSMExt);
        pOSMaux.add(this.pbDownload);
        pOSMaux.add(this.pbConvert);
        pCenterOSM.add((Component)pOSMaux, "East");
        pLeft.add(this.lblOSMFile);
        pLeft.add(this.lblPathTypeFiles);
        pLeft.add(this.lblOptions);
        pLeft.add(this.cbIgnoreEdges);
        pCenter.add(pCenterOSM);
        pCenter.add(this.txtPathTypeFiles);
        pCenter.add(this.txtOptions);
        pCenter.add(this.txtIgnoreEdges);
        this.checkOSMFileExists();
        this.checkFileTypeExists();
        this.setLayout(new BorderLayout());
        this.add((Component)pLeft, "West");
        this.add((Component)pCenter, "Center");
        this.setPreferredSize(new Dimension(200, 200));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.pbDownload) {
            String filename_osm = this.getOSMFilename();
            if (!Util.overwriteFile(this.f, filename_osm)) {
                return;
            }
            String name = this.getOSMName();
            DlgOSMDownload dlg = new DlgOSMDownload(this.f, this.osm, name);
            dlg.setVisible(true);
            if (!dlg.isCanceled()) {
                name = dlg.getNetworkName();
                this.setNetworkName(name);
            }
            dlg.dispose();
        } else if (e.getSource() == this.pbConvert) {
            String filename_osm = this.getOSMFilename();
            File file = new File(filename_osm);
            if (file.exists() && file.isFile()) {
                String filename_net = this.f.pNetwork.getNetworkFilename();
                if (!Util.overwriteFile(this.f, filename_net)) {
                    return;
                }
                String command = this.buildCommand(filename_net);
                Util.setCursorEsperas(this);
                boolean ok = this.f.pNetwork.execCommandSUMO(command, "Creating network ...", true);
                Util.setCursorNormal(this);
                if (ok) {
                    String name = this.getOSMName();
                    command = this.buildCommandExtractInfo(name);
                    Util.setCursorEsperas(this);
                    ok = this.f.pNetwork.execCommandSUMO(command, "Extracting network information ...", false);
                    Util.setCursorNormal(this);
                } else {
                    JOptionPane.showMessageDialog(this.f, "Error converting network.\nCheck 'Output' and 'Errors' tabs for more information", "Convert network", 0);
                }
            } else {
                JOptionPane.showMessageDialog(this.f, "Error converting network.\nThe network file '" + filename_osm + "' does not exists!", "Convert network", 0);
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.cbIgnoreEdges) {
            this.txtIgnoreEdges.setEnabled(this.cbIgnoreEdges.isSelected());
        }
    }

    @Override
    public String buildCommand(String filename_net) {
        String cmd = "";
        this.sOSMFile = this.getOSMFilename();
        this.sNetworkFile = filename_net;
        this.sPathTypeFiles = this.txtPathTypeFiles.getText().trim();
        this.sOptions = this.txtOptions.getText().trim();
        this.sIgnoreEdges = this.txtIgnoreEdges.getText().trim();
        cmd = cmd + "netconvert";
        cmd = cmd + " --osm-files " + this.sOSMFile;
        cmd = cmd + " --output-file " + filename_net;
        if (!this.sPathTypeFiles.isEmpty()) {
            cmd = cmd + " --type-files " + this.sPathTypeFiles;
        }
        if (!this.sOptions.isEmpty()) {
            cmd = cmd + " " + this.sOptions;
        }
        if (this.cbIgnoreEdges.isSelected()) {
            cmd = cmd + " " + this.sIgnoreEdges;
        }
        return cmd;
    }

    public String buildCommandObstacles(String obstaclesfile) {
        String cmd = "";
        String osmfile = this.getOSMFilename();
        String netfile = this.f.pNetwork.getNetworkFilename();
        cmd = cmd + "polyconvert";
        cmd = cmd + " --osm-files " + osmfile;
        cmd = cmd + " --net-file " + netfile;
        cmd = cmd + " --output-file " + obstaclesfile;
        return cmd;
    }

    public String buildCommandExtractInfo(String name) {
        String cmd = "";
        cmd = cmd + "netconvert";
        cmd = cmd + " --sumo-net-file " + name + ".net.xml --plain-output-prefix " + name;
        return cmd;
    }

    @Override
    public String toString() {
        return "OpenStreetMap";
    }

    private String getOSMName() {
        String s = this.txtOSMFile.getText().trim();
        return s;
    }

    private String getOSMFilename() {
        String s = this.txtOSMFile.getText().trim() + ".osm.xml";
        return s;
    }

    private void checkOSMFileExists() {
        String filename = this.getOSMFilename();
        File file = new File(filename);
        boolean ok = file.exists() && file.isFile();
        this.txtOSMFile.setForeground(ok ? Color.BLACK : Color.RED);
    }

    private void checkFileTypeExists() {
        String filename = this.txtPathTypeFiles.getText().trim();
        File file = new File(filename);
        boolean ok = file.exists() && file.isFile();
        this.txtPathTypeFiles.setForeground(ok ? Color.BLACK : Color.RED);
    }

    public void setNetworkName(String name) {
        this.txtOSMFile.setText(name);
        this.checkOSMFileExists();
    }

    public void setTypeFile(String filename) {
        this.txtPathTypeFiles.setText(filename);
        this.checkFileTypeExists();
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getSource() == this.txtPathTypeFiles) {
            this.checkFileTypeExists();
        }
    }
}

