/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.frontend;

import gatcomsumo.backend.NetworkType;
import gatcomsumo.frontend.MyFrame;
import gatcomsumo.frontend.PanelNetwork;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import util.Util;

class PanelAbstractSpiderNetwork
extends PanelNetwork
implements ActionListener {
    private MyFrame f;
    private JLabel lblArmNumber;
    private JLabel lblCircleNumber;
    private JLabel lblSpaceRadius;
    private JLabel lblOmitCenter;
    private JTextField txtArmNumber;
    private JTextField txtCircleNumber;
    private JTextField txtSpaceRadius;
    private JComboBox cbOmitCenter;
    private JButton pbNetwork;
    int armNumber;
    int circleNumber;
    double spaceRadius;
    boolean omitCenter;

    public PanelAbstractSpiderNetwork(MyFrame f) {
        this.f = f;
        JPanel pLeft = new JPanel();
        pLeft.setLayout(new GridLayout(4, 1));
        this.lblArmNumber = new JLabel("Number of axes:");
        this.lblCircleNumber = new JLabel("Number of circles:");
        this.lblSpaceRadius = new JLabel("Distances between the circles:");
        this.lblOmitCenter = new JLabel("Omit the central node:");
        pLeft.add(this.lblArmNumber);
        pLeft.add(this.lblCircleNumber);
        pLeft.add(this.lblSpaceRadius);
        pLeft.add(this.lblOmitCenter);
        JPanel pCenter = new JPanel();
        pCenter.setLayout(new GridLayout(4, 1));
        this.txtArmNumber = new JTextField("13");
        this.txtArmNumber.setToolTipText("The number of axes within the net; default: 13 (--spider.arm-number)");
        this.txtCircleNumber = new JTextField("20");
        this.txtCircleNumber.setToolTipText("The number of circles of the net; default: 20 (--spider.circle-number)");
        this.txtSpaceRadius = new JTextField("100.0");
        this.txtSpaceRadius.setToolTipText("The distances between the circles; default: 100 (--spider.space-radius)");
        this.cbOmitCenter = new JComboBox();
        this.cbOmitCenter.setToolTipText("Omit the central node of the network; default: false (--spider.omit-center)");
        this.cbOmitCenter.addItem("No");
        this.cbOmitCenter.addItem("Yes");
        this.cbOmitCenter.setSelectedIndex(0);
        pCenter.add(this.txtArmNumber);
        pCenter.add(this.txtCircleNumber);
        pCenter.add(this.txtSpaceRadius);
        pCenter.add(this.cbOmitCenter);
        JPanel pSur = new JPanel();
        this.pbNetwork = new JButton("Create Network");
        this.pbNetwork.setToolTipText("Generate a SUMO network file (.net.xml) and load it");
        this.pbNetwork.addActionListener(this);
        pSur.setLayout(new FlowLayout(2));
        pSur.add(this.pbNetwork);
        this.setLayout(new BorderLayout());
        this.add((Component)pLeft, "West");
        this.add((Component)pCenter, "Center");
        this.add((Component)pSur, "South");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.pbNetwork) {
            String name = this.f.pNetwork.getProjectName();
            String filename_net = this.f.pNetwork.getNetworkFilename();
            if (!Util.overwriteFile(this.f, filename_net)) {
                return;
            }
            String command = this.buildCommand(filename_net);
            boolean ok = this.f.pNetwork.execCommandSUMO(command, "Creating network ...", true);
            if (ok) {
                this.f.sumo.init(name, NetworkType.ABSTRACT_SPIDER);
                this.f.pNetwork.sumo.network.loadXML(filename_net);
                this.f.update();
            }
        }
    }

    @Override
    public String buildCommand(String filename_net) {
        String cmd = "";
        this.armNumber = Util.parseInt(this.txtArmNumber.getText());
        this.circleNumber = Util.parseInt(this.txtCircleNumber.getText());
        this.spaceRadius = Util.parseDouble(this.txtSpaceRadius.getText());
        this.omitCenter = this.cbOmitCenter.getSelectedIndex() == 1;
        cmd = cmd + "netgenerate --spider true";
        cmd = cmd + " --spider.arm-number " + this.armNumber;
        cmd = cmd + " --spider.circle-number " + this.circleNumber;
        cmd = cmd + " --spider.space-radius " + this.spaceRadius;
        cmd = cmd + " --spider.omit-center " + this.omitCenter;
        cmd = cmd + " --output-file " + filename_net;
        return cmd;
    }

    @Override
    public String toString() {
        return "Spider Network";
    }
}

