/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.frontend;

import gatcomsumo.backend.NetworkType;
import gatcomsumo.frontend.MyFrame;
import gatcomsumo.frontend.PanelNetwork;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import util.Util;

class PanelAbstractRandomNetwork
extends PanelNetwork
implements ActionListener {
    private MyFrame f;
    private static final double[] NEIGHBOR_PROBABILITY = new double[]{0.0, 0.0, 10.0, 10.0, 2.0, 1.0};
    private static final int NUM_NEIGHBOR_PROBABILITY = NEIGHBOR_PROBABILITY.length;
    private JLabel lblIterations;
    private JLabel lblBidiProbability;
    private JLabel lblMaxDistance;
    private JLabel lblMinDistance;
    private JLabel lblMinAngle;
    private JLabel lblNumTries;
    private JLabel lblConnectivity;
    private JLabel lblNeighborDist;
    private JTextField txtIterations;
    private JTextField txtBidiProbability;
    private JTextField txtMaxDistance;
    private JTextField txtMinDistance;
    private JTextField txtMinAngle;
    private JTextField txtNumTries;
    private JTextField txtConnectivity;
    private JTextField[] txtNeighborDist;
    private JButton pbNetwork;
    int iterations;
    int numTries;
    double bidiProbability;
    double maxDistance;
    double minDistance;
    double minAngle;
    double connectivity;
    double[] neighborDist;

    public PanelAbstractRandomNetwork(MyFrame f) {
        this.f = f;
        JPanel pLeft = new JPanel();
        pLeft.setLayout(new GridLayout(8, 1));
        this.lblIterations = new JLabel("Iterations:");
        this.lblBidiProbability = new JLabel("Probability of reverse edge:");
        this.lblMaxDistance = new JLabel("Maximum distance for each edge:");
        this.lblMinDistance = new JLabel("Minimum distance for each edge:");
        this.lblMinAngle = new JLabel("Minimum angle between roads:");
        this.lblNumTries = new JLabel("Number of tries for each node:");
        this.lblConnectivity = new JLabel("Probability for roads to continue:");
        this.lblNeighborDist = new JLabel("Probability for having N neighbors:");
        pLeft.add(this.lblIterations);
        pLeft.add(this.lblBidiProbability);
        pLeft.add(this.lblMaxDistance);
        pLeft.add(this.lblMinDistance);
        pLeft.add(this.lblMinAngle);
        pLeft.add(this.lblNumTries);
        pLeft.add(this.lblConnectivity);
        pLeft.add(this.lblNeighborDist);
        JPanel pCenter = new JPanel();
        pCenter.setLayout(new GridLayout(8, 1));
        this.txtIterations = new JTextField("2000");
        this.txtIterations.setToolTipText("Describes how many times an edge shall be added to the net; default: 2000 (--rand.iterations)");
        this.txtBidiProbability = new JTextField("1");
        this.txtBidiProbability.setToolTipText("Defines the probability to build a reverse edge; default: 1 (--rand.bidi-probability)");
        this.txtMaxDistance = new JTextField("250");
        this.txtMaxDistance.setToolTipText("The maximum distance for each edge; default: 250 (--rand.max-distance)");
        this.txtMinDistance = new JTextField("100");
        this.txtMinDistance.setToolTipText("The minimum distance for each edge; default: 100 (--rand.min-distance)");
        this.txtMinAngle = new JTextField("0.785398");
        this.txtMinAngle.setToolTipText("The minimum angle for each pair of (bidirectional) roads; default: 0.785398 (--rand.min-angle)");
        this.txtNumTries = new JTextField("50");
        this.txtNumTries.setToolTipText("The number of tries for creating each node; default: 50 (--rand.num-tries)");
        this.txtConnectivity = new JTextField("0.95");
        this.txtConnectivity.setToolTipText("Probability for roads to continue at each node; default: 0.95 (--rand.connectivity)");
        JPanel pNeighborProb = new JPanel();
        pNeighborProb.setLayout(new GridLayout(1, NUM_NEIGHBOR_PROBABILITY));
        this.txtNeighborDist = new JTextField[NUM_NEIGHBOR_PROBABILITY];
        for (int i = 0; i < NUM_NEIGHBOR_PROBABILITY; ++i) {
            this.txtNeighborDist[i] = new JTextField("" + NEIGHBOR_PROBABILITY[i]);
            this.txtNeighborDist[i].setToolTipText("Probability for a node having exactly " + (i + 1) + " neighbors; default: " + NEIGHBOR_PROBABILITY[i] + " (--rand.neighbor-dist" + (i + 1) + ")");
            pNeighborProb.add(this.txtNeighborDist[i]);
        }
        pCenter.add(this.txtIterations);
        pCenter.add(this.txtBidiProbability);
        pCenter.add(this.txtMaxDistance);
        pCenter.add(this.txtMinDistance);
        pCenter.add(this.txtMinAngle);
        pCenter.add(this.txtNumTries);
        pCenter.add(this.txtConnectivity);
        pCenter.add(pNeighborProb);
        JPanel pSur = new JPanel();
        this.pbNetwork = new JButton("Create Network");
        this.pbNetwork.setToolTipText("Generate a SUMO network file (.net.xml) and load it");
        this.pbNetwork.addActionListener(this);
        pSur.setLayout(new FlowLayout(2));
        pSur.add(this.pbNetwork);
        this.setLayout(new BorderLayout());
        this.add((Component)pLeft, "West");
        this.add((Component)pCenter, "Center");
        this.add((Component)pSur, "South");
        this.neighborDist = new double[NUM_NEIGHBOR_PROBABILITY];
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.pbNetwork) {
            String name = this.f.pNetwork.getProjectName();
            String filename_net = this.f.pNetwork.getNetworkFilename();
            if (!Util.overwriteFile(this.f, filename_net)) {
                return;
            }
            String command = this.buildCommand(filename_net);
            boolean ok = this.f.pNetwork.execCommandSUMO(command, "Creating network ...", true);
            if (ok) {
                this.f.sumo.init(name, NetworkType.ABSTRACT_RANDOM);
                this.f.pNetwork.sumo.network.loadXML(filename_net);
                this.f.update();
            }
        }
    }

    @Override
    public String buildCommand(String filename_net) {
        int i;
        String cmd = "";
        this.iterations = Util.parseInt(this.txtIterations.getText());
        this.bidiProbability = Util.parseDouble(this.txtBidiProbability.getText());
        this.maxDistance = Util.parseDouble(this.txtMaxDistance.getText());
        this.minDistance = Util.parseDouble(this.txtMinDistance.getText());
        this.minAngle = Util.parseDouble(this.txtMinAngle.getText());
        this.numTries = Util.parseInt(this.txtNumTries.getText());
        this.connectivity = Util.parseDouble(this.txtConnectivity.getText());
        for (i = 0; i < NUM_NEIGHBOR_PROBABILITY; ++i) {
            this.neighborDist[i] = Util.parseDouble(this.txtNeighborDist[i].getText());
        }
        cmd = cmd + "netgenerate --rand true";
        cmd = cmd + " --rand.iterations " + this.iterations;
        cmd = cmd + " --rand.bidi-probability " + this.bidiProbability;
        cmd = cmd + " --rand.max-distance " + this.maxDistance;
        cmd = cmd + " --rand.min-distance " + this.minDistance;
        cmd = cmd + " --rand.min-angle " + this.minAngle;
        cmd = cmd + " --rand.num-tries " + this.numTries;
        cmd = cmd + " --rand.connectivity " + this.connectivity;
        for (i = 0; i < NUM_NEIGHBOR_PROBABILITY; ++i) {
            cmd = cmd + " --rand.neighbor-dist" + (i + 1) + " " + this.neighborDist[i];
        }
        cmd = cmd + " --output-file " + filename_net;
        return cmd;
    }

    @Override
    public String toString() {
        return "Random Network";
    }
}

