/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.frontend;

import gatcomsumo.backend.NetworkType;
import gatcomsumo.frontend.MyFrame;
import gatcomsumo.frontend.PanelNetwork;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import util.Util;

class PanelAbstractGridNetwork
extends PanelNetwork
implements ActionListener {
    private MyFrame f;
    private JLabel lblGridXNumber;
    private JLabel lblGridYNumber;
    private JLabel lblGridXLength;
    private JLabel lblGridYLength;
    private JLabel lblAttachLength;
    private JLabel lblOffset;
    private JLabel lblUseLetters;
    private JTextField txtGridXNumber;
    private JTextField txtGridYNumber;
    private JTextField txtGridXLength;
    private JTextField txtGridYLength;
    private JTextField txtAttachLength;
    private JTextField txtOffset;
    private JComboBox cbUseLetters;
    private JButton pbNetwork;
    int number;
    int numberX;
    int numberY;
    double length;
    double lengthX;
    double lengthY;
    double attachLength;
    double offset;
    boolean useLetters;

    public PanelAbstractGridNetwork(MyFrame f) {
        this.f = f;
        JPanel pLeft = new JPanel();
        pLeft.setLayout(new GridLayout(7, 1));
        this.lblGridXNumber = new JLabel("Number of junctions in x-dir:");
        this.lblGridYNumber = new JLabel("Number of junctions in y-dir:");
        this.lblGridXLength = new JLabel("Length of horizontal streets:");
        this.lblGridYLength = new JLabel("Length of vertical streets:");
        this.lblOffset = new JLabel("Offset for the net coordinates (RECOMMENDED):");
        this.lblAttachLength = new JLabel("Length of streets attached at the boundary:");
        this.lblUseLetters = new JLabel("Use letters:");
        pLeft.add(this.lblGridXNumber);
        pLeft.add(this.lblGridYNumber);
        pLeft.add(this.lblGridXLength);
        pLeft.add(this.lblGridYLength);
        pLeft.add(this.lblOffset);
        pLeft.add(this.lblAttachLength);
        pLeft.add(this.lblUseLetters);
        JPanel pCenter = new JPanel();
        pCenter.setLayout(new GridLayout(7, 1));
        this.txtGridXNumber = new JTextField("5");
        this.txtGridXNumber.setToolTipText("The number of junctions in x-dir; default: 5 (--grid-number or --grid.x-number)");
        this.txtGridYNumber = new JTextField("5");
        this.txtGridYNumber.setToolTipText("The number of junctions in y-dir; default: 5 (--grid-number or --grid.y-number)");
        this.txtGridXLength = new JTextField("100.0");
        this.txtGridXLength.setToolTipText("The length of horizontal streets; default: 100 (--grid-length or --grid.x-length)");
        this.txtGridYLength = new JTextField("100.0");
        this.txtGridYLength.setToolTipText("The length of vertical streets; default: 100 (--grid-length or --grid.y-length)");
        this.txtOffset = new JTextField("50");
        this.txtOffset.setToolTipText("Adds offset to net x-positions/y-positions (--offset.x and --offset.y)");
        this.txtAttachLength = new JTextField("0.0");
        this.txtAttachLength.setToolTipText("The length of streets attached at the boundary; 0 means no streets are attached; default: 0 (--grid.attach-length)");
        this.cbUseLetters = new JComboBox();
        this.cbUseLetters.setToolTipText("The IDs of generated nodes use letters for the X axis; default: false (--grid.alphanumerical-ids)");
        this.cbUseLetters.addItem("No");
        this.cbUseLetters.addItem("Yes");
        this.cbUseLetters.setSelectedIndex(0);
        pCenter.add(this.txtGridXNumber);
        pCenter.add(this.txtGridYNumber);
        pCenter.add(this.txtGridXLength);
        pCenter.add(this.txtGridYLength);
        pCenter.add(this.txtOffset);
        pCenter.add(this.txtAttachLength);
        pCenter.add(this.cbUseLetters);
        JPanel pSur = new JPanel();
        this.pbNetwork = new JButton("Create Network");
        this.pbNetwork.setToolTipText("Generate a SUMO network file (.net.xml) and load it");
        this.pbNetwork.addActionListener(this);
        pSur.setLayout(new FlowLayout(2));
        pSur.add(this.pbNetwork);
        this.setLayout(new BorderLayout());
        this.add((Component)pLeft, "West");
        this.add((Component)pCenter, "Center");
        this.add((Component)pSur, "South");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.pbNetwork) {
            String name = this.f.pNetwork.getProjectName();
            String filename_net = this.f.pNetwork.getNetworkFilename();
            if (!Util.overwriteFile(this.f, filename_net)) {
                return;
            }
            String command = this.buildCommand(filename_net);
            boolean ok = this.f.pNetwork.execCommandSUMO(command, "Creating network ...", true);
            if (ok) {
                this.f.sumo.init(name, NetworkType.ABSTRACT_GRID);
                this.f.pNetwork.sumo.network.loadXML(filename_net);
                this.f.update();
            }
        }
    }

    @Override
    public String buildCommand(String filename_net) {
        String cmd = "";
        this.numberX = Util.parseInt(this.txtGridXNumber.getText());
        this.numberY = Util.parseInt(this.txtGridYNumber.getText());
        this.lengthX = Util.parseDouble(this.txtGridXLength.getText());
        this.lengthY = Util.parseDouble(this.txtGridYLength.getText());
        this.offset = Util.parseDouble(this.txtOffset.getText());
        this.attachLength = Util.parseDouble(this.txtAttachLength.getText());
        this.useLetters = this.cbUseLetters.getSelectedIndex() == 1;
        cmd = cmd + "netgenerate --grid true";
        if (this.numberX == this.numberY) {
            cmd = cmd + " --grid.number " + this.numberX;
        } else {
            cmd = cmd + " --grid.x-number " + this.numberX;
            cmd = cmd + " --grid.y-number " + this.numberY;
        }
        if (this.lengthX == this.lengthY) {
            cmd = cmd + " --grid.length " + this.lengthX;
        } else {
            cmd = cmd + " --grid.x-length " + this.lengthX;
            cmd = cmd + " --grid.y-length " + this.lengthY;
        }
        cmd = cmd + " --grid.attach-length " + this.attachLength;
        cmd = cmd + " --offset.x " + this.offset;
        cmd = cmd + " --offset.y " + this.offset;
        cmd = cmd + " --output-file " + filename_net;
        return cmd;
    }

    public String buildCommandObstacles(String obstaclesfile) {
        String cmd = "";
        String netfile = this.f.pNetwork.getNetworkFilename();
        cmd = cmd + "polyconvert";
        cmd = cmd + " --net-file " + netfile;
        cmd = cmd + " --output-file " + obstaclesfile;
        return cmd;
    }

    public void addPolygons(String obstaclesfile, double offset, int margin) {
        this.numberX = Util.parseInt(this.txtGridXNumber.getText());
        this.numberY = Util.parseInt(this.txtGridYNumber.getText());
        this.lengthX = Util.parseDouble(this.txtGridXLength.getText());
        this.lengthY = Util.parseDouble(this.txtGridYLength.getText());
        try {
            FileWriter fw = new FileWriter(obstaclesfile, true);
            BufferedWriter bw = new BufferedWriter(fw);
            PrintWriter out = new PrintWriter(bw);
            out.println("\n<!-- Polygons -->");
            out.println("<shapes>");
            int p = 0;
            for (int x = 0; x < this.numberX - 1; ++x) {
                for (int y = 0; y < this.numberY - 1; ++y) {
                    double shape_x = offset + (double)x * this.lengthX;
                    double shape_y = offset + (double)y * this.lengthY;
                    double shape_xmin = shape_x + (double)margin;
                    double shape_xmax = shape_x - (double)margin + this.lengthX;
                    double shape_ymin = shape_y + (double)margin;
                    double shape_ymax = shape_y - (double)margin + this.lengthY;
                    StringBuilder sb = new StringBuilder("   <poly id=\"" + p + "\" type=\"building\"");
                    sb.append(" color=\"1.00,0.90,0.90\" fill=\"1\" layer=\"2\"");
                    sb.append(" shape=\"");
                    sb.append(shape_xmin + "," + shape_ymin + " ");
                    sb.append(shape_xmin + "," + shape_ymax + " ");
                    sb.append(shape_xmax + "," + shape_ymax + " ");
                    sb.append(shape_xmax + "," + shape_ymin + " ");
                    sb.append(shape_xmin + "," + shape_ymin);
                    sb.append("\"/>");
                    out.println(sb.toString());
                    ++p;
                }
            }
            out.println("</shapes>");
            out.close();
            bw.close();
            fw.close();
        }
        catch (IOException e) {
            System.err.println("Error while writing to the file '" + obstaclesfile + "'");
        }
    }

    @Override
    public String toString() {
        return "Grid Network";
    }
}

