/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.frontend;

import gatcomsumo.backend.SUMO;
import gatcomsumo.frontend.Panel_Map;
import gatcomsumo.frontend.Panel_Network;
import gatcomsumo.frontend.Panel_Omnet;
import gatcomsumo.frontend.Panel_Tools;
import gatcomsumo.frontend.Panel_TrafficDemand;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import util.Colors;

class MyFrame
extends JFrame
implements WindowListener {
    public SUMO sumo = new SUMO("Project");
    public Colors colors;
    private JTabbedPane tabpane = new JTabbedPane();
    public Panel_Network pNetwork = new Panel_Network(this, "Network", this.sumo);
    public Panel_TrafficDemand pTrafficDemands;
    public Panel_Map pCanvas;
    public Panel_Omnet pOmnet;
    public Panel_Tools pTools;

    public MyFrame(String title) {
        super(title);
        this.tabpane.addTab("Network", this.pNetwork);
        this.pTrafficDemands = new Panel_TrafficDemand(this, this.sumo);
        this.tabpane.addTab("Traffic Demand", this.pTrafficDemands);
        this.pCanvas = new Panel_Map(this, this.sumo);
        this.tabpane.addTab("Map", this.pCanvas);
        this.pOmnet = new Panel_Omnet(this, this.sumo);
        this.tabpane.addTab("OMNeT++", this.pOmnet);
        this.pTools = new Panel_Tools(this, this.sumo);
        this.tabpane.addTab("Tools", this.pTools);
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabpane, "Center");
        this.addWindowListener(this);
        this.setDefaultCloseOperation(0);
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (this.sumo.trafficDemand.getChanged()) {
            int n = JOptionPane.showConfirmDialog(this, "TrafficDemands has changed.\nDo you want to save the changes before exit the application?", "Exit", 1);
            if (n == 0) {
                this.pTrafficDemands.save();
                this.dispose();
            }
            if (n == 1) {
                this.dispose();
            }
        } else {
            this.dispose();
        }
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    public void update() {
        this.pNetwork.update();
        this.pTrafficDemands.update();
        this.pCanvas.updateNetwork();
        this.pCanvas.updateRoutes();
    }
}

