/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.frontend;

import gatcomsumo.backend.Edge;
import gatcomsumo.backend.NetworkBBox;
import gatcomsumo.backend.Node;
import gatcomsumo.backend.Route;
import gatcomsumo.backend.SUMO;
import gatcomsumo.frontend.MyFrame;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;

class MiCanvas
extends JPanel
implements MouseListener,
MouseMotionListener,
MouseWheelListener,
ActionListener {
    private static final int MARGIN_X = 25;
    private static final int MARGIN_Y = 25;
    private static final int MAX_NODES_PER_WAY = 2000;
    private int[] xPoints = new int[2000];
    private int[] yPoints = new int[2000];
    private MyFrame f;
    private SUMO sumo;
    private boolean useBuffer;
    private double zoom;
    private double factor;
    private boolean redraw;
    private boolean showNodes;
    private boolean showEdges;
    private boolean showRoutes;
    private Node selectedNode;
    private Edge selectedEdge;
    private Route selectedRoute;
    private Image buffer;
    private Graphics bg;
    Point pScreen;
    Point p1;
    Point p2;
    Point2D.Double pSUMO;
    Point2D.Double p1_sumo;
    Point2D.Double p2_sumo;
    Point2D.Double p1_utm;
    Point2D.Double p2_utm;
    boolean distance = false;
    private JPopupMenu menu;
    private JMenuItem menuDistance;
    private JMenuItem menuCopyID;
    private JMenuItem menuDeleteObj;
    private JMenuItem menuBBox;

    public MiCanvas(MyFrame f, SUMO sumo, boolean useBuffer) {
        this.f = f;
        this.sumo = sumo;
        this.useBuffer = useBuffer;
        this.zoom = 1.0;
        this.factor = 1.0;
        this.redraw = true;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.pScreen = new Point();
        this.p1 = new Point();
        this.p2 = new Point();
        this.pSUMO = null;
        this.p1_sumo = new Point2D.Double();
        this.p2_sumo = new Point2D.Double();
        this.p1_utm = new Point2D.Double();
        this.p2_utm = new Point2D.Double();
        this.menu = new JPopupMenu("Selected Object");
        this.menuDistance = new JMenuItem("Distance");
        this.menuDistance.addActionListener(this);
        this.menuCopyID = new JMenuItem("Copy ID");
        this.menuCopyID.addActionListener(this);
        this.menuDeleteObj = new JMenuItem("Remove");
        this.menuDeleteObj.addActionListener(this);
        this.menuBBox = new JMenuItem("Show current Bounding Box");
        this.menuBBox.addActionListener(this);
        this.menu.add(this.menuDistance);
        this.menu.add(this.menuBBox);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(6000, 6000);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.pScreen.setLocation(e.getX(), e.getY());
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.pScreen.setLocation(e.getPoint());
        if (e.getButton() == 1) {
            if (this.pSUMO == null) {
                this.pSUMO = new Point2D.Double(0.0, 0.0);
            }
            this.screen2sumo(this.pScreen, this.pSUMO);
            this.f.pCanvas.sb.updateCoord(this.pSUMO);
            Node node = this.sumo.network.nodes.searchNearest(this.pSUMO, 10.0 / this.zoom);
            Edge edge = this.sumo.network.edges.searchNearest(this.pSUMO, 10.0 / this.zoom);
            this.setShowSelected(node, edge, null);
            this.f.pCanvas.sb.updateObjects(node, edge);
        } else if (e.getButton() == 3) {
            if (this.distance) {
                this.distance = false;
            } else {
                this.menu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        int notches = e.getWheelRotation();
        if (notches < 0) {
            this.zoomin();
        } else {
            this.zoomout();
        }
    }

    public void setShowNodes(boolean showNodes) {
        this.showNodes = showNodes;
    }

    public void setShowEdges(boolean showEdges) {
        this.showEdges = showEdges;
    }

    public void setShowRoutes(boolean showRoutes) {
        this.showRoutes = showRoutes;
    }

    public void setShowSelected(Node node, Edge edge, Route route) {
        this.selectedNode = node;
        this.selectedEdge = edge;
        this.selectedRoute = route;
        this.repaint();
    }

    private void zoom(double factor) {
        Point pCenterScreen = this.getVisibleCenterPoint();
        Point2D.Double pCenter = new Point2D.Double();
        this.screen2sumo(pCenterScreen, pCenter);
        this.zoom *= factor;
        this.sumo2screen(pCenter, pCenterScreen);
        this.scrollToPoint(pCenterScreen);
        this.repaint();
    }

    public void zoomin() {
        this.zoom(1.25);
    }

    public void zoomout() {
        this.zoom(0.75);
    }

    public void zoomall() {
        double z2;
        Rectangle visible = this.getVisibleRect();
        double z1 = (double)visible.width / this.sumo.network.location.getWidth_bbox_conv();
        this.zoom = z1 < (z2 = (double)visible.height / this.sumo.network.location.getHeight_bbox_conv()) ? z1 : z2;
        this.scrollToStart();
        this.repaint();
    }

    private Point getVisibleCenterPoint() {
        Rectangle visible = this.getVisibleRect();
        Point pScreen = new Point();
        pScreen.x = visible.x + visible.width / 2;
        pScreen.y = visible.y + visible.height / 2;
        return pScreen;
    }

    public void scrollToCenter() {
        Rectangle visible = this.getVisibleRect();
        Rectangle bounds = this.getBounds();
        visible.y = (bounds.height - visible.height) / 2;
        visible.x = (bounds.width - visible.width) / 2;
        this.scrollRectToVisible(visible);
    }

    public void scrollToStart() {
        Rectangle visible = this.getVisibleRect();
        visible.x = 0;
        visible.y = 0;
        this.scrollRectToVisible(visible);
    }

    public void scrollToEnd() {
        Rectangle visible = this.getVisibleRect();
        Rectangle bounds = this.getBounds();
        visible.x = bounds.width - visible.width + 200;
        visible.y = bounds.height - visible.height + 200;
        this.scrollRectToVisible(visible);
    }

    public void scrollToPoint(Point p) {
        Rectangle visible = this.getVisibleRect();
        visible.x = p.x - visible.width / 2;
        visible.y = p.y - visible.height / 2;
        this.scrollRectToVisible(visible);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.useBuffer) {
            if (this.buffer == null) {
                this.buffer = this.createImage(this.getWidth(), this.getHeight());
                this.bg = this.buffer.getGraphics();
            }
            this.bg.setColor(this.getBackground());
            int w = (int)this.sumo.network.location.rectangle_bbox_conv.width;
            int h = (int)this.sumo.network.location.rectangle_bbox_conv.height;
            this.bg.fillRect(0, 0, w, h);
            this.bg.setColor(this.getForeground());
        } else {
            this.bg = g;
        }
        if (this.sumo.network.nodes.list.isEmpty() && this.sumo.network.edges.list.isEmpty()) {
            return;
        }
        this.drawScenario(this.bg);
        this.drawNetwork(this.bg);
        this.drawSelectedObjects(this.bg);
        if (this.distance) {
            this.drawDistance(this.bg);
        }
        if (this.useBuffer) {
            g.drawImage(this.buffer, 0, 0, this);
        }
    }

    public void sumo2screen(Rectangle2D.Double rSUMO, Rectangle rScreen) {
        Point2D.Double p1SUMO = new Point2D.Double(rSUMO.x, rSUMO.y);
        Point2D.Double p2SUMO = new Point2D.Double(rSUMO.x + rSUMO.width, rSUMO.y + rSUMO.height);
        Point p1Screen = new Point();
        Point p2Screen = new Point();
        this.sumo2screen(p1SUMO, p1Screen);
        this.sumo2screen(p2SUMO, p2Screen);
        double width = p2Screen.getX() - p1Screen.getX();
        double height = p1Screen.getY() - p2Screen.getY();
        rScreen.setRect(p1Screen.getX(), p2Screen.getY(), width, height);
    }

    public void sumo2screen(Point2D pSUMO, Point pScreen) {
        double x_despl = pSUMO.getX();
        double y_despl = pSUMO.getY();
        y_despl = this.sumo.network.location.bbox_conv_ymax - y_despl;
        int x = (int)(x_despl * this.zoom) + 25;
        int y = (int)(y_despl * this.zoom) + 25;
        pScreen.setLocation(x, y);
    }

    public void screen2sumo(Point pScreen, Point2D pSUMO) {
        int x = (int)((pScreen.getX() - 25.0) / this.zoom);
        int y = (int)((pScreen.getY() - 25.0) / this.zoom);
        double x_despl = x;
        double y_despl = y;
        y_despl = this.sumo.network.location.bbox_conv_ymax - y_despl;
        pSUMO.setLocation(x_despl, y_despl);
    }

    private void drawScenario(Graphics g) {
        Rectangle rScreen = new Rectangle();
        this.sumo2screen(this.sumo.network.location.rectangle_bbox_conv, rScreen);
        g.setColor(Color.LIGHT_GRAY);
        g.fillRect(rScreen.x, rScreen.y, rScreen.width, rScreen.height);
        NetworkBBox bbox = this.sumo.network.bbox;
        if (bbox != null) {
            this.sumo2screen(bbox.bbox_conv, rScreen);
            g.setColor(Color.WHITE);
            g.drawRect(rScreen.x, rScreen.y, rScreen.width, rScreen.height);
        }
    }

    public void drawNetwork(Graphics g) {
        if (this.showEdges) {
            g.setColor(Color.BLACK);
            for (Edge edge : this.sumo.network.edges.list) {
                this.drawEdge(g, edge);
            }
        }
        if (this.showNodes) {
            g.setColor(Color.MAGENTA);
            for (Node node : this.sumo.network.nodes.list) {
                this.drawNode(g, node);
            }
        }
    }

    public void drawSelectedObjects(Graphics g) {
        if (this.showEdges && this.selectedEdge != null) {
            g.setColor(Color.GREEN);
            this.drawEdge(g, this.selectedEdge);
        }
        if (this.showRoutes && this.selectedRoute != null) {
            g.setColor(this.selectedRoute.color.getColor());
            for (Edge edge : this.selectedRoute.edges) {
                this.drawEdge(g, edge);
            }
        }
        if (this.showNodes && this.selectedNode != null) {
            g.setColor(Color.GREEN);
            this.drawNode(g, this.selectedNode);
        }
        if (this.pSUMO != null) {
            g.setColor(Color.RED);
            this.drawPoint(this.bg, this.pSUMO);
        }
    }

    private void drawEdge(Graphics g, Edge edge) {
        Point pScreen = null;
        Point pScreenFrom = null;
        Point pScreenTo = null;
        pScreen = new Point();
        pScreenFrom = new Point();
        pScreenTo = new Point();
        Point2D.Double pFrom = new Point2D.Double(edge.fromNode.x, edge.fromNode.y);
        Point2D.Double pTo = new Point2D.Double(edge.toNode.x, edge.toNode.y);
        this.sumo2screen(pFrom, pScreenFrom);
        this.sumo2screen(pTo, pScreenTo);
        int nPoints = edge.shape.size();
        if (nPoints == 0) {
            g.drawLine(pScreenFrom.x, pScreenFrom.y, pScreenTo.x, pScreenTo.y);
        } else {
            if (nPoints >= 2000) {
                nPoints = 1997;
            }
            this.xPoints[0] = pScreenFrom.x;
            this.yPoints[0] = pScreenFrom.y;
            for (int i = 0; i < nPoints; ++i) {
                Point2D.Double p = edge.shape.get(i);
                this.sumo2screen(p, pScreen);
                this.xPoints[i + 1] = pScreen.x;
                this.yPoints[i + 1] = pScreen.y;
            }
            this.xPoints[nPoints + 1] = pScreenTo.x;
            this.yPoints[nPoints + 1] = pScreenTo.y;
            g.drawPolyline(this.xPoints, this.yPoints, nPoints + 2);
        }
    }

    private void drawNode(Graphics g, Node node) {
        Point2D.Double p = new Point2D.Double(node.x, node.y);
        this.drawPoint(g, p);
    }

    private void drawPoint(Graphics g, Point2D.Double pSUMO) {
        Point pScreen = new Point();
        this.sumo2screen(pSUMO, pScreen);
        this.bg.fillOval(pScreen.x - 3, pScreen.y - 3, 6, 6);
    }

    private void drawDistance(Graphics g) {
        if (this.p1 != null && this.p2 != null) {
            double dist = Point.distance(this.p1_utm.x, this.p1_utm.y, this.p2_utm.x, this.p2_utm.y);
            g.setColor(Color.RED);
            g.drawLine(this.p1.x, this.p1.y, this.p2.x, this.p2.y);
            g.drawString(String.format("Distance: %.2f m", dist), this.p2.x, this.p2.y);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.menuDistance) {
            this.distance = true;
            this.p1.setLocation(this.pScreen);
            this.p2.setLocation(this.pScreen);
            this.screen2sumo(this.p1, this.p1_sumo);
            this.screen2sumo(this.p2, this.p2_sumo);
            this.sumo.network.sumo2utm(this.p1_sumo, this.p1_utm);
            this.sumo.network.sumo2utm(this.p2_sumo, this.p2_utm);
        } else if (e.getSource() != this.menuCopyID && e.getSource() != this.menuDeleteObj && e.getSource() == this.menuBBox) {
            NetworkBBox bbox = this.sumo.network.bbox;
            JOptionPane.showMessageDialog(this.f, "Current Bounding Box:\n" + bbox.getString(), "Bounding Box", 1);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        JViewport viewPort;
        if (this.pScreen != null && (viewPort = (JViewport)SwingUtilities.getAncestorOfClass(JViewport.class, this)) != null) {
            int deltaX = this.pScreen.x - e.getX();
            int deltaY = this.pScreen.y - e.getY();
            Rectangle view = viewPort.getViewRect();
            view.x += deltaX;
            view.y += deltaY;
            this.scrollRectToVisible(view);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.distance) {
            this.p2.setLocation(e.getX(), e.getY());
            this.screen2sumo(this.p2, this.p2_sumo);
            this.sumo.network.sumo2utm(this.p2_sumo, this.p2_utm);
            this.repaint();
        }
    }
}

